/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import li.strolch.model.Order;
import li.strolch.model.Resource;
import li.strolch.model.StrolchRootElement;
import li.strolch.model.Version;
import li.strolch.model.activity.Activity;
import li.strolch.model.xml.StrolchElementListener;
import li.strolch.persistence.api.ActivityDao;
import li.strolch.persistence.api.OrderDao;
import li.strolch.persistence.api.ResourceDao;
import li.strolch.persistence.api.StrolchTransaction;

public class StoreToDaoElementListener
implements StrolchElementListener {
    private StrolchTransaction tx;
    private ResourceDao resourceDao;
    private OrderDao orderDao;
    private ActivityDao activityDao;

    public StoreToDaoElementListener(StrolchTransaction tx) {
        this.tx = tx;
        this.resourceDao = tx.getPersistenceHandler().getResourceDao(this.tx);
        this.orderDao = tx.getPersistenceHandler().getOrderDao(this.tx);
        this.activityDao = tx.getPersistenceHandler().getActivityDao(this.tx);
    }

    public void notifyResource(Resource resource) {
        if (resource.getVersion() == null) {
            Version.setInitialVersionFor((StrolchRootElement)resource, (String)this.tx.getCertificate().getUsername());
        }
        this.resourceDao.save(resource);
    }

    public void notifyOrder(Order order) {
        if (order.getVersion() == null) {
            Version.setInitialVersionFor((StrolchRootElement)order, (String)this.tx.getCertificate().getUsername());
        }
        this.orderDao.save(order);
    }

    public void notifyActivity(Activity activity) {
        if (activity.getVersion() == null) {
            Version.setInitialVersionFor((StrolchRootElement)activity, (String)this.tx.getCertificate().getUsername());
        }
        this.activityDao.save(activity);
    }
}

