/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.util.List;
import java.util.Set;
import li.strolch.agent.api.AuditTrail;
import li.strolch.model.audit.Audit;
import li.strolch.model.audit.AuditQuery;
import li.strolch.persistence.api.AuditDao;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.utils.collections.DateRange;

public class TransactionalAuditTrail
implements AuditTrail {
    protected AuditDao getDao(StrolchTransaction tx) {
        return tx.getPersistenceHandler().getAuditDao(tx);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean hasAudit(StrolchTransaction tx, String type, Long id) {
        return this.getDao(tx).hasElement(type, id);
    }

    @Override
    public long querySize(StrolchTransaction tx, DateRange dateRange) {
        return this.getDao(tx).querySize(dateRange);
    }

    @Override
    public long querySize(StrolchTransaction tx, String type, DateRange dateRange) {
        return this.getDao(tx).querySize(type, dateRange);
    }

    @Override
    public Set<String> getTypes(StrolchTransaction tx) {
        return this.getDao(tx).queryTypes();
    }

    @Override
    public Audit getBy(StrolchTransaction tx, String type, Long id) {
        return this.getDao(tx).queryBy(type, id);
    }

    @Override
    public List<Audit> getAllElements(StrolchTransaction tx, String type, DateRange dateRange) {
        return this.getDao(tx).queryAll(type, dateRange);
    }

    @Override
    public void add(StrolchTransaction tx, Audit audit) {
        this.getDao(tx).save(audit);
    }

    @Override
    public void addAll(StrolchTransaction tx, List<Audit> audits) {
        this.getDao(tx).saveAll(audits);
    }

    @Override
    public Audit update(StrolchTransaction tx, Audit audit) {
        this.getDao(tx).update(audit);
        return audit;
    }

    @Override
    public List<Audit> updateAll(StrolchTransaction tx, List<Audit> audits) {
        this.getDao(tx).updateAll(audits);
        return audits;
    }

    @Override
    public void remove(StrolchTransaction tx, Audit audit) {
        this.getDao(tx).remove(audit);
    }

    @Override
    public void removeAll(StrolchTransaction tx, List<Audit> audits) {
        this.getDao(tx).removeAll(audits);
    }

    @Override
    public long removeAll(StrolchTransaction tx, String type, DateRange dateRange) {
        return this.getDao(tx).removeAll(type, dateRange);
    }

    @Override
    public <U> List<U> doQuery(StrolchTransaction tx, AuditQuery<U> query) {
        return this.getDao(tx).doQuery(query);
    }
}

