/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import li.strolch.agent.api.ElementMap;
import li.strolch.agent.api.StrolchAgent;
import li.strolch.agent.api.StrolchRealm;
import li.strolch.exception.StrolchException;
import li.strolch.model.StrolchRootElement;
import li.strolch.model.Version;
import li.strolch.model.parameter.Parameter;
import li.strolch.model.parameter.StringListParameter;
import li.strolch.model.parameter.StringParameter;
import li.strolch.persistence.api.StrolchDao;
import li.strolch.persistence.api.StrolchPersistenceException;
import li.strolch.persistence.api.StrolchTransaction;

public abstract class TransactionalElementMap<T extends StrolchRootElement>
implements ElementMap<T> {
    private StrolchRealm realm;

    public TransactionalElementMap(StrolchRealm realm) {
        this.realm = realm;
    }

    protected StrolchRealm getRealm() {
        return this.realm;
    }

    protected abstract StrolchDao<T> getDao(StrolchTransaction var1);

    @Override
    public boolean hasType(StrolchTransaction tx, String type) {
        return this.getDao(tx).queryTypes().contains(type);
    }

    @Override
    public boolean hasElement(StrolchTransaction tx, String type, String id) {
        return this.getDao(tx).hasElement(type, id);
    }

    @Override
    public long querySize(StrolchTransaction tx) {
        return this.getDao(tx).querySize();
    }

    @Override
    public long querySize(StrolchTransaction tx, String type) {
        return this.getDao(tx).querySize(type);
    }

    @Override
    public T getTemplate(StrolchTransaction tx, String type) {
        return this.getTemplate(tx, type, false);
    }

    @Override
    public T getTemplate(StrolchTransaction tx, String type, boolean assertExists) throws StrolchException {
        T t = this.getBy(tx, "Template", type);
        if (assertExists && t == null) {
            String msg = "The template for type {0} does not exist!";
            msg = MessageFormat.format(msg, type);
            throw new StrolchException(msg);
        }
        if (t == null) {
            return null;
        }
        StrolchRootElement clone = (StrolchRootElement)t.getClone();
        clone.setId(StrolchAgent.getUniqueId());
        clone.setType(type);
        return (T)clone;
    }

    @Override
    public T getBy(StrolchTransaction tx, String type, String id) {
        return this.getBy(tx, type, id, false);
    }

    @Override
    public T getBy(StrolchTransaction tx, String type, String id, boolean assertExists) throws StrolchException {
        T t = this.getDao(tx).queryBy(type, id);
        if (assertExists && t == null) {
            String msg = "The element for type {0} and id {1} does not exist!";
            msg = MessageFormat.format(msg, type, id);
            throw new StrolchException(msg);
        }
        if (t == null) {
            return null;
        }
        if (!this.realm.getMode().isTransient()) {
            return t;
        }
        StrolchRootElement clone = (StrolchRootElement)t.getClone();
        clone.setVersion(t.getVersion());
        return (T)clone;
    }

    @Override
    public T getBy(StrolchTransaction tx, String type, String id, int version) {
        return this.getBy(tx, type, id, version, false);
    }

    @Override
    public T getBy(StrolchTransaction tx, String type, String id, int version, boolean assertExists) throws StrolchException {
        T t = this.getDao(tx).queryBy(type, id, version);
        if (assertExists && t == null) {
            String msg = "The element for type {0} and id {1} and version {2} does not exist!";
            msg = MessageFormat.format(msg, type, id, version);
            throw new StrolchException(msg);
        }
        return t;
    }

    @Override
    public T getBy(StrolchTransaction tx, StringParameter refP, boolean assertExists) throws StrolchException {
        this.assertIsRefParam((Parameter<?>)refP);
        String type = refP.getUom();
        String id = refP.getValue();
        T t = this.getBy(tx, type, id);
        if (assertExists && t == null) {
            String msg = "The element for refP {0} with id {1} does not exist!";
            msg = MessageFormat.format(msg, refP.getLocator(), id);
            throw new StrolchException(msg);
        }
        if (t == null) {
            return null;
        }
        if (!this.realm.getMode().isTransient()) {
            return t;
        }
        StrolchRootElement clone = (StrolchRootElement)t.getClone();
        clone.setVersion(t.getVersion());
        return (T)clone;
    }

    @Override
    public List<T> getBy(StrolchTransaction tx, StringListParameter refP, boolean assertExists) throws StrolchException {
        this.assertIsRefParam((Parameter<?>)refP);
        String type = refP.getUom();
        List ids = refP.getValue();
        return ids.stream().map(id -> {
            T t = this.getBy(tx, type, (String)id);
            if (assertExists && t == null) {
                String msg = "The element for refP {0} with id {1} does not exist!";
                msg = MessageFormat.format(msg, refP.getLocator(), id);
                throw new StrolchException(msg);
            }
            return t;
        }).filter(Objects::nonNull).map(t -> {
            if (!this.realm.getMode().isTransient()) {
                return t;
            }
            StrolchRootElement clone = (StrolchRootElement)t.getClone();
            clone.setVersion(t.getVersion());
            return clone;
        }).collect(Collectors.toList());
    }

    @Override
    public List<T> getVersionsFor(StrolchTransaction tx, String type, String id) {
        return this.getDao(tx).queryVersionsFor(type, id).stream().map(t -> {
            StrolchRootElement clone = (StrolchRootElement)t.getClone();
            clone.setVersion(t.getVersion());
            return clone;
        }).collect(Collectors.toList());
    }

    @Override
    public List<T> getAllElements(StrolchTransaction tx) {
        List<T> all = this.getDao(tx).queryAll();
        if (this.realm.getMode().isTransient()) {
            return all;
        }
        return all.stream().map(t -> {
            StrolchRootElement clone = (StrolchRootElement)t.getClone();
            clone.setVersion(t.getVersion());
            return clone;
        }).collect(Collectors.toList());
    }

    @Override
    public List<T> getElementsBy(StrolchTransaction tx, String type) {
        List<T> all = this.getDao(tx).queryAll(type);
        if (this.realm.getMode().isTransient()) {
            return all;
        }
        return all.stream().map(t -> {
            StrolchRootElement clone = (StrolchRootElement)t.getClone();
            clone.setVersion(t.getVersion());
            return clone;
        }).collect(Collectors.toList());
    }

    @Override
    public Set<String> getTypes(StrolchTransaction tx) {
        return this.getDao(tx).queryTypes();
    }

    @Override
    public Set<String> getAllKeys(StrolchTransaction tx) {
        return this.getDao(tx).queryKeySet();
    }

    @Override
    public Set<String> getKeysBy(StrolchTransaction tx, String type) {
        return this.getDao(tx).queryKeySet(type);
    }

    @Override
    public void add(StrolchTransaction tx, T element) {
        if (this.realm.isVersioningEnabled()) {
            Version.updateVersionFor(element, (String)tx.getCertificate().getUsername(), (boolean)false);
        } else {
            Version.setInitialVersionFor(element, (String)tx.getCertificate().getUsername());
        }
        this.getDao(tx).save(element);
        this.getDao(tx).flush();
    }

    @Override
    public void addAll(StrolchTransaction tx, List<T> elements) {
        for (StrolchRootElement element : elements) {
            if (this.realm.isVersioningEnabled()) {
                Version.updateVersionFor((StrolchRootElement)element, (String)tx.getCertificate().getUsername(), (boolean)false);
                continue;
            }
            Version.setInitialVersionFor((StrolchRootElement)element, (String)tx.getCertificate().getUsername());
        }
        this.getDao(tx).saveAll(elements);
        this.getDao(tx).flush();
    }

    @Override
    public void update(StrolchTransaction tx, T element) {
        if (this.realm.isVersioningEnabled()) {
            Version.updateVersionFor(element, (String)tx.getCertificate().getUsername(), (boolean)false);
        } else {
            Version.setInitialVersionFor(element, (String)tx.getCertificate().getUsername());
        }
        this.getDao(tx).update(element);
        this.getDao(tx).flush();
    }

    @Override
    public void updateAll(StrolchTransaction tx, List<T> elements) {
        for (StrolchRootElement element : elements) {
            if (this.realm.isVersioningEnabled()) {
                Version.updateVersionFor((StrolchRootElement)element, (String)tx.getCertificate().getUsername(), (boolean)false);
                continue;
            }
            Version.setInitialVersionFor((StrolchRootElement)element, (String)tx.getCertificate().getUsername());
        }
        this.getDao(tx).updateAll(elements);
        this.getDao(tx).flush();
    }

    @Override
    public void remove(StrolchTransaction tx, T element) {
        if (this.realm.isVersioningEnabled()) {
            Version.updateVersionFor(element, (String)tx.getCertificate().getUsername(), (boolean)true);
            this.getDao(tx).update(element);
        } else {
            Version.setInitialVersionFor(element, (String)tx.getCertificate().getUsername());
            this.getDao(tx).remove(element);
        }
        this.getDao(tx).flush();
    }

    @Override
    public void removeAll(StrolchTransaction tx, List<T> elements) {
        for (StrolchRootElement element : elements) {
            if (this.realm.isVersioningEnabled()) {
                Version.updateVersionFor((StrolchRootElement)element, (String)tx.getCertificate().getUsername(), (boolean)true);
                continue;
            }
            Version.setInitialVersionFor((StrolchRootElement)element, (String)tx.getCertificate().getUsername());
        }
        if (this.realm.isVersioningEnabled()) {
            this.getDao(tx).updateAll(elements);
        } else {
            this.getDao(tx).removeAll(elements);
        }
        this.getDao(tx).flush();
    }

    @Override
    public long removeAll(StrolchTransaction tx) {
        long removed = this.getDao(tx).removeAll();
        this.getDao(tx).flush();
        return removed;
    }

    @Override
    public long removeAllBy(StrolchTransaction tx, String type) {
        long removed = this.getDao(tx).removeAllBy(type);
        this.getDao(tx).flush();
        return removed;
    }

    @Override
    public T revertToVersion(StrolchTransaction tx, T element) throws StrolchException {
        return this.revertToVersion(tx, element.getType(), element.getId(), element.getVersion().getVersion());
    }

    @Override
    public T revertToVersion(StrolchTransaction tx, String type, String id, int version) throws StrolchException {
        if (!this.realm.isVersioningEnabled()) {
            throw new StrolchPersistenceException("Can not revert to a version if versioning is not enabled!");
        }
        T current = this.getBy(tx, type, id, true);
        T versionT = this.getBy(tx, type, id, version, true);
        StrolchRootElement clone = (StrolchRootElement)versionT.getClone();
        clone.setVersion(current.getVersion().next(tx.getCertificate().getUsername(), false));
        this.getDao(tx).update(clone);
        this.getDao(tx).flush();
        return (T)clone;
    }

    @Override
    public void undoVersion(StrolchTransaction tx, T element) throws StrolchException {
        if (!this.realm.isVersioningEnabled()) {
            throw new StrolchPersistenceException("Can not undo a version if versioning is not enabled!");
        }
        T current = this.getBy(tx, element.getType(), element.getId(), true);
        if (!current.getVersion().equals((Object)element.getVersion())) {
            String msg = "Can not undo the version {0} as it is not the latest {1}!";
            msg = MessageFormat.format(msg, element.getVersion(), current.getVersion());
            throw new StrolchException(msg);
        }
        this.getDao(tx).removeVersion(current);
        this.getDao(tx).flush();
    }

    protected abstract void assertIsRefParam(Parameter<?> var1);
}

