/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.text.MessageFormat;
import li.strolch.agent.api.ActivityMap;
import li.strolch.agent.api.AuditTrail;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.OrderMap;
import li.strolch.agent.api.ResourceMap;
import li.strolch.agent.impl.DataStoreMode;
import li.strolch.agent.impl.InternalStrolchRealm;
import li.strolch.agent.impl.NoStrategyAuditTrail;
import li.strolch.agent.impl.TransactionalActivityMap;
import li.strolch.agent.impl.TransactionalAuditTrail;
import li.strolch.agent.impl.TransactionalOrderMap;
import li.strolch.agent.impl.TransactionalResourceMap;
import li.strolch.persistence.api.PersistenceHandler;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.privilege.model.Certificate;
import li.strolch.privilege.model.PrivilegeContext;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.utils.dbc.DBC;
import li.strolch.utils.helper.StringHelper;

public class TransactionalRealm
extends InternalStrolchRealm {
    private ResourceMap resourceMap;
    private OrderMap orderMap;
    private ActivityMap activityMap;
    private AuditTrail auditTrail;
    private PersistenceHandler persistenceHandler;

    public TransactionalRealm(String realm) {
        super(realm);
    }

    @Override
    public DataStoreMode getMode() {
        return DataStoreMode.TRANSACTIONAL;
    }

    @Override
    public StrolchTransaction openTx(Certificate certificate, String action) {
        DBC.PRE.assertNotNull("Certificate must be set!", (Object)certificate);
        return this.persistenceHandler.openTx(this, certificate, action);
    }

    @Override
    public StrolchTransaction openTx(Certificate certificate, Class<?> clazz) {
        DBC.PRE.assertNotNull("Certificate must be set!", (Object)certificate);
        return this.persistenceHandler.openTx(this, certificate, clazz.getName());
    }

    @Override
    public ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    @Override
    public OrderMap getOrderMap() {
        return this.orderMap;
    }

    @Override
    public ActivityMap getActivityMap() {
        return this.activityMap;
    }

    @Override
    public AuditTrail getAuditTrail() {
        return this.auditTrail;
    }

    @Override
    public void initialize(ComponentContainer container, ComponentConfiguration configuration) {
        super.initialize(container, configuration);
        this.resourceMap = new TransactionalResourceMap(this);
        this.orderMap = new TransactionalOrderMap(this);
        this.activityMap = new TransactionalActivityMap(this);
        this.auditTrail = this.isAuditTrailEnabled() ? new TransactionalAuditTrail() : new NoStrategyAuditTrail();
        this.persistenceHandler = container.getComponent(PersistenceHandler.class);
    }

    @Override
    public void start(PrivilegeContext privilegeContext) {
        long start = System.nanoTime();
        int nrOfOrders = 0;
        int nrOfResources = 0;
        int nrOfActivities = 0;
        try (StrolchTransaction tx = this.openTx(privilegeContext.getCertificate(), "strolch_boot");){
            nrOfOrders = this.orderMap.getAllKeys(tx).size();
        }
        tx = this.openTx(privilegeContext.getCertificate(), "strolch_boot");
        var8_8 = null;
        try {
            nrOfResources = this.resourceMap.getAllKeys(tx).size();
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.openTx(privilegeContext.getCertificate(), "strolch_boot");
        var8_8 = null;
        try {
            nrOfActivities = this.activityMap.getAllKeys(tx).size();
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        long duration = System.nanoTime() - start;
        String durationS = StringHelper.formatNanoDuration((long)duration);
        logger.info(MessageFormat.format("Initialized Transactional Maps for realm {0} took {1}.", this.getRealm(), durationS));
        logger.info(MessageFormat.format("There are {0} Orders", nrOfOrders));
        logger.info(MessageFormat.format("There are {0} Resources", nrOfResources));
        logger.info(MessageFormat.format("There are {0} Activities", nrOfActivities));
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }
}

