/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.agent.impl;

import java.io.File;
import java.text.MessageFormat;
import li.strolch.agent.api.ActivityMap;
import li.strolch.agent.api.AuditTrail;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.OrderMap;
import li.strolch.agent.api.ResourceMap;
import li.strolch.agent.impl.DataStoreMode;
import li.strolch.agent.impl.InMemoryElementListener;
import li.strolch.agent.impl.InternalStrolchRealm;
import li.strolch.agent.impl.NoStrategyAuditTrail;
import li.strolch.agent.impl.TransactionalActivityMap;
import li.strolch.agent.impl.TransactionalAuditTrail;
import li.strolch.agent.impl.TransactionalOrderMap;
import li.strolch.agent.impl.TransactionalResourceMap;
import li.strolch.model.ModelStatistics;
import li.strolch.model.xml.StrolchElementListener;
import li.strolch.model.xml.XmlModelSaxFileReader;
import li.strolch.persistence.api.PersistenceHandler;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.persistence.inmemory.InMemoryPersistence;
import li.strolch.privilege.model.Certificate;
import li.strolch.privilege.model.PrivilegeContext;
import li.strolch.runtime.StrolchConstants;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.runtime.configuration.StrolchConfigurationException;
import li.strolch.utils.dbc.DBC;
import li.strolch.utils.helper.StringHelper;

public class TransientRealm
extends InternalStrolchRealm {
    private ResourceMap resourceMap;
    private OrderMap orderMap;
    private ActivityMap activityMap;
    private AuditTrail auditTrail;
    private PersistenceHandler persistenceHandler;
    private File modelFile;

    public TransientRealm(String realm) {
        super(realm);
    }

    @Override
    public DataStoreMode getMode() {
        return DataStoreMode.TRANSIENT;
    }

    @Override
    public StrolchTransaction openTx(Certificate certificate, String action) {
        DBC.PRE.assertNotNull("Certificate must be set!", (Object)certificate);
        return this.persistenceHandler.openTx(this, certificate, action);
    }

    @Override
    public StrolchTransaction openTx(Certificate certificate, Class<?> clazz) {
        DBC.PRE.assertNotNull("Certificate must be set!", (Object)certificate);
        return this.persistenceHandler.openTx(this, certificate, clazz.getName());
    }

    @Override
    public ResourceMap getResourceMap() {
        return this.resourceMap;
    }

    @Override
    public OrderMap getOrderMap() {
        return this.orderMap;
    }

    @Override
    public ActivityMap getActivityMap() {
        return this.activityMap;
    }

    @Override
    public AuditTrail getAuditTrail() {
        return this.auditTrail;
    }

    @Override
    public void initialize(ComponentContainer container, ComponentConfiguration configuration) {
        super.initialize(container, configuration);
        String key = StrolchConstants.makeRealmKey(this.getRealm(), "dataStoreFile");
        if (!configuration.hasProperty(key)) {
            String msg = "There is no data store file for realm {0}. Set a property with key {1}";
            msg = MessageFormat.format(msg, this.getRealm(), key);
            throw new StrolchConfigurationException(msg);
        }
        this.modelFile = configuration.getDataFile(key, null, configuration.getRuntimeConfiguration(), true);
        this.persistenceHandler = new InMemoryPersistence(container.getPrivilegeHandler(), this.isVersioningEnabled());
        this.resourceMap = new TransactionalResourceMap(this);
        this.orderMap = new TransactionalOrderMap(this);
        this.activityMap = new TransactionalActivityMap(this);
        this.auditTrail = this.isAuditTrailEnabled() ? new TransactionalAuditTrail() : new NoStrategyAuditTrail();
    }

    @Override
    public void start(PrivilegeContext privilegeContext) {
        ModelStatistics statistics;
        try (StrolchTransaction tx = this.openTx(privilegeContext.getCertificate(), "strolch_boot");){
            InMemoryElementListener elementListener = new InMemoryElementListener(tx);
            elementListener.setUpdateResources(false);
            elementListener.setUpdateOrders(false);
            elementListener.setUpdateActivities(false);
            elementListener.setFailOnUpdate(true);
            XmlModelSaxFileReader handler = new XmlModelSaxFileReader((StrolchElementListener)elementListener, this.modelFile, true);
            handler.parseFile();
            statistics = handler.getStatistics();
            tx.commitOnClose();
        }
        String durationS = StringHelper.formatNanoDuration((long)statistics.durationNanos);
        logger.info(MessageFormat.format("Loading XML Model file {0} for realm {1} took {2}.", this.modelFile.getName(), this.getRealm(), durationS));
        logger.info(MessageFormat.format("Loaded {0} Orders", statistics.nrOfOrders));
        logger.info(MessageFormat.format("Loaded {0} Resources", statistics.nrOfResources));
        logger.info(MessageFormat.format("Loaded {0} Activities", statistics.nrOfActivities));
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }
}

