/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.api;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import li.strolch.agent.api.ActivityMap;
import li.strolch.agent.api.AuditTrail;
import li.strolch.agent.api.ObserverHandler;
import li.strolch.agent.api.OrderMap;
import li.strolch.agent.api.ResourceMap;
import li.strolch.agent.api.StrolchAgent;
import li.strolch.agent.api.StrolchLockException;
import li.strolch.agent.api.StrolchRealm;
import li.strolch.agent.impl.AuditingActivityMap;
import li.strolch.agent.impl.AuditingAuditMapFacade;
import li.strolch.agent.impl.AuditingOrderMap;
import li.strolch.agent.impl.AuditingResourceMap;
import li.strolch.agent.impl.InternalStrolchRealm;
import li.strolch.exception.StrolchAccessDeniedException;
import li.strolch.exception.StrolchException;
import li.strolch.model.GroupedParameterizedElement;
import li.strolch.model.Locator;
import li.strolch.model.Order;
import li.strolch.model.ParameterBag;
import li.strolch.model.Resource;
import li.strolch.model.StrolchElement;
import li.strolch.model.StrolchRootElement;
import li.strolch.model.activity.Activity;
import li.strolch.model.audit.AccessType;
import li.strolch.model.audit.Audit;
import li.strolch.model.audit.AuditQuery;
import li.strolch.model.parameter.Parameter;
import li.strolch.model.parameter.StringListParameter;
import li.strolch.model.parameter.StringParameter;
import li.strolch.model.query.ActivityQuery;
import li.strolch.model.query.OrderQuery;
import li.strolch.model.query.ResourceQuery;
import li.strolch.model.query.StrolchQuery;
import li.strolch.model.timedstate.StrolchTimedState;
import li.strolch.model.visitor.ElementTypeVisitor;
import li.strolch.model.visitor.StrolchRootElementVisitor;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.persistence.api.StrolchTransactionException;
import li.strolch.persistence.api.TransactionCloseStrategy;
import li.strolch.persistence.api.TransactionResult;
import li.strolch.persistence.api.TransactionState;
import li.strolch.privilege.base.PrivilegeException;
import li.strolch.privilege.model.Certificate;
import li.strolch.privilege.model.PrivilegeContext;
import li.strolch.privilege.model.Restrictable;
import li.strolch.runtime.privilege.PrivilegeHandler;
import li.strolch.service.api.Command;
import li.strolch.utils.dbc.DBC;
import li.strolch.utils.helper.ExceptionHelper;
import li.strolch.utils.helper.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTransaction
implements StrolchTransaction {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractTransaction.class);
    private InternalStrolchRealm realm;
    private TransactionCloseStrategy closeStrategy;
    private boolean suppressUpdates;
    private boolean suppressAudits;
    private boolean suppressDoNothingLogging;
    private TransactionResult txResult;
    private List<Command> commands;
    private List<Command> flushedCommands;
    private Set<StrolchRootElement> lockedElements;
    private AuditingOrderMap orderMap;
    private AuditingResourceMap resourceMap;
    private AuditingActivityMap activityMap;
    private AuditingAuditMapFacade auditTrail;
    private String action;
    private Certificate certificate;
    private PrivilegeHandler privilegeHandler;

    public AbstractTransaction(PrivilegeHandler privilegeHandler, StrolchRealm realm, Certificate certificate, String action) {
        DBC.PRE.assertNotNull("privilegeHandler must be set!", (Object)privilegeHandler);
        DBC.PRE.assertNotNull("realm must be set!", (Object)realm);
        DBC.PRE.assertNotNull("certificate must be set!", (Object)certificate);
        DBC.PRE.assertNotNull("action must be set!", (Object)action);
        this.privilegeHandler = privilegeHandler;
        this.realm = (InternalStrolchRealm)realm;
        this.action = action;
        this.certificate = certificate;
        this.commands = new ArrayList<Command>();
        this.flushedCommands = new ArrayList<Command>();
        this.lockedElements = new HashSet<StrolchRootElement>();
        this.closeStrategy = TransactionCloseStrategy.DO_NOTHING;
        this.txResult = new TransactionResult(this.getRealmName(), System.nanoTime(), new Date());
        this.txResult.setState(TransactionState.OPEN);
    }

    public TransactionResult getTxResult() {
        return this.txResult;
    }

    @Override
    public TransactionState getState() {
        return this.txResult.getState();
    }

    @Override
    public boolean isRollingBack() {
        return this.txResult.getState().isRollingBack();
    }

    @Override
    public boolean isCommitting() {
        return this.txResult.getState().isCommitting();
    }

    @Override
    public boolean isClosing() {
        return this.txResult.getState().isClosing();
    }

    @Override
    public String getRealmName() {
        return this.realm.getRealm();
    }

    public StrolchRealm getRealm() {
        return this.realm;
    }

    @Override
    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public TransactionCloseStrategy getCloseStrategy() {
        return this.closeStrategy;
    }

    private void setCloseStrategy(TransactionCloseStrategy closeStrategy) {
        this.closeStrategy = closeStrategy;
    }

    @Override
    public void close() throws StrolchTransactionException {
        this.closeStrategy.close(this);
    }

    @Override
    public void doNothingOnClose() {
        this.setCloseStrategy(TransactionCloseStrategy.DO_NOTHING);
    }

    @Override
    public void commitOnClose() {
        this.setCloseStrategy(TransactionCloseStrategy.COMMIT);
    }

    @Override
    public void rollbackOnClose() {
        this.setCloseStrategy(TransactionCloseStrategy.ROLLBACK);
    }

    @Override
    public StrolchTransactionException fail(String string) {
        this.rollbackOnClose();
        return new StrolchTransactionException(string);
    }

    @Override
    public void setSuppressUpdates(boolean suppressUpdates) {
        this.suppressUpdates = suppressUpdates;
    }

    @Override
    public boolean isSuppressUpdates() {
        return this.suppressUpdates;
    }

    @Override
    public void setSuppressAudits(boolean suppressAudits) {
        this.suppressAudits = suppressAudits;
    }

    @Override
    public boolean isSuppressAudits() {
        return this.suppressAudits;
    }

    @Override
    public boolean isSuppressDoNothingLogging() {
        return this.suppressDoNothingLogging;
    }

    @Override
    public void setSuppressDoNothingLogging(boolean quietDoNothing) {
        this.suppressDoNothingLogging = quietDoNothing;
    }

    @Override
    public boolean isVersioningEnabled() {
        return this.realm.isVersioningEnabled();
    }

    @Override
    public <T extends StrolchRootElement> void lock(T element) throws StrolchLockException {
        this.realm.lock(element);
        this.lockedElements.add(element);
    }

    @Override
    public <T extends StrolchRootElement> void releaseLock(T element) throws StrolchLockException {
        this.realm.releaseLock(element);
        this.lockedElements.remove(element);
    }

    private void releaseElementLocks() {
        for (StrolchRootElement lockedElement : this.lockedElements) {
            this.realm.releaseLock(lockedElement);
        }
    }

    @Override
    public void addCommand(Command command) {
        this.commands.add(command);
    }

    @Override
    public ResourceMap getResourceMap() {
        if (this.resourceMap == null) {
            this.resourceMap = new AuditingResourceMap(this.realm.getResourceMap(), this.realm.isAuditTrailEnabledForRead());
        }
        return this.resourceMap;
    }

    @Override
    public OrderMap getOrderMap() {
        if (this.orderMap == null) {
            this.orderMap = new AuditingOrderMap(this.realm.getOrderMap(), this.realm.isAuditTrailEnabledForRead());
        }
        return this.orderMap;
    }

    @Override
    public ActivityMap getActivityMap() {
        if (this.activityMap == null) {
            this.activityMap = new AuditingActivityMap(this.realm.getActivityMap(), this.realm.isAuditTrailEnabledForRead());
        }
        return this.activityMap;
    }

    @Override
    public AuditTrail getAuditTrail() {
        if (this.auditTrail == null) {
            this.auditTrail = new AuditingAuditMapFacade(this.realm.getAuditTrail(), this.realm.isAuditTrailEnabledForRead());
        }
        return this.auditTrail;
    }

    private void assertQueryAllowed(StrolchQuery query) {
        try {
            PrivilegeContext privilegeContext = this.privilegeHandler.getPrivilegeContext(this.certificate);
            privilegeContext.validateAction((Restrictable)query);
        }
        catch (PrivilegeException e) {
            throw new StrolchAccessDeniedException(this.certificate, (Restrictable)query, ExceptionHelper.getExceptionMessage((Throwable)e), (Throwable)e);
        }
    }

    @Override
    public <U> List<U> doQuery(OrderQuery<U> query) {
        this.assertQueryAllowed((StrolchQuery)query);
        DBC.PRE.assertNotNull("orderVisitor", (Object)query.getOrderVisitor());
        return this.getOrderMap().doQuery(this, query);
    }

    @Override
    public <U> List<U> doQuery(ResourceQuery<U> query) {
        this.assertQueryAllowed((StrolchQuery)query);
        DBC.PRE.assertNotNull("resourceVisitor", (Object)query.getResourceVisitor());
        return this.getResourceMap().doQuery(this, query);
    }

    @Override
    public <U> List<U> doQuery(ActivityQuery<U> query) {
        this.assertQueryAllowed((StrolchQuery)query);
        DBC.PRE.assertNotNull("activityVisitor", (Object)query.getActivityVisitor());
        return this.getActivityMap().doQuery(this, query);
    }

    @Override
    public <U> List<U> doQuery(AuditQuery<U> query) {
        this.assertQueryAllowed((StrolchQuery)query);
        DBC.PRE.assertNotNull("auditVisitor", (Object)query.getAuditVisitor());
        return this.getAuditTrail().doQuery(this, query);
    }

    @Override
    public <T extends StrolchElement> T findElement(Locator locator) {
        GroupedParameterizedElement groupedParameterizedElement;
        if (locator.getSize() < 3) {
            String msg = "The locator is invalid as it does not have at least three path elements (e.g. Resource/MyType/@id): {0}";
            msg = MessageFormat.format(msg, locator.toString());
            throw new StrolchException(msg);
        }
        List elements = locator.getPathElements();
        String objectClassType = (String)elements.get(0);
        String type = (String)elements.get(1);
        String id = (String)elements.get(2);
        switch (objectClassType) {
            case "Resource": {
                groupedParameterizedElement = (GroupedParameterizedElement)this.getResourceMap().getBy((StrolchTransaction)this, type, id);
                break;
            }
            case "Order": {
                groupedParameterizedElement = (GroupedParameterizedElement)this.getOrderMap().getBy((StrolchTransaction)this, type, id);
                break;
            }
            case "Activity": {
                groupedParameterizedElement = (GroupedParameterizedElement)this.getActivityMap().getBy((StrolchTransaction)this, type, id);
                break;
            }
            default: {
                throw new StrolchException(MessageFormat.format("Unknown object class {0}", objectClassType));
            }
        }
        if (groupedParameterizedElement == null) {
            String msg = "No top level object could be found with locator {0}";
            throw new StrolchException(MessageFormat.format(msg, locator));
        }
        if (elements.size() == 3) {
            return (T)groupedParameterizedElement;
        }
        String stateOrBagOrActivity = (String)elements.get(3);
        if (stateOrBagOrActivity.equals("Bag")) {
            String parameterBagId = (String)elements.get(4);
            ParameterBag bag = groupedParameterizedElement.getParameterBag(parameterBagId);
            if (bag == null) {
                String msg = "Could not find ParameterBag for locator {0} on element {1}";
                throw new StrolchException(MessageFormat.format(msg, locator, groupedParameterizedElement.getLocator()));
            }
            if (elements.size() == 5) {
                return (T)bag;
            }
            String parameterId = (String)elements.get(5);
            Parameter parameter = (Parameter)bag.getParameter(parameterId);
            return (T)parameter;
        }
        if (stateOrBagOrActivity.equals("State")) {
            if (elements.size() != 5) {
                String msg = "Missing state Id on locator {0}";
                throw new StrolchException(MessageFormat.format(msg, locator));
            }
            Resource resource = (Resource)groupedParameterizedElement;
            String stateId = (String)elements.get(4);
            StrolchTimedState timedState = resource.getTimedState(stateId);
            return (T)timedState;
        }
        if (groupedParameterizedElement instanceof Activity) {
            Activity activity = (Activity)groupedParameterizedElement;
            Iterator iter = elements.subList(3, elements.size()).iterator();
            Activity element = activity;
            while (iter.hasNext()) {
                String next = (String)iter.next();
                if (!(element instanceof Activity)) {
                    String msg = "Invalid locator {0} with part {1} as not an Activity but deeper element specified";
                    throw new StrolchException(MessageFormat.format(msg, locator, next));
                }
                element = element.getElement(next);
            }
            return (T)element;
        }
        String msg = "Invalid locator {0} with part {1}";
        throw new StrolchException(MessageFormat.format(msg, locator, stateOrBagOrActivity));
    }

    @Override
    public Resource getResourceTemplate(String type) {
        return (Resource)this.getResourceMap().getTemplate(this, type);
    }

    @Override
    public Resource getResourceTemplate(String type, boolean assertExists) throws StrolchException {
        return (Resource)this.getResourceMap().getTemplate(this, type, assertExists);
    }

    @Override
    public Order getOrderTemplate(String type) {
        return (Order)this.getOrderMap().getTemplate(this, type);
    }

    @Override
    public Order getOrderTemplate(String type, boolean assertExists) throws StrolchException {
        return (Order)this.getOrderMap().getTemplate(this, type, assertExists);
    }

    @Override
    public Activity getActivityTemplate(String type) {
        return (Activity)this.getActivityMap().getTemplate(this, type);
    }

    @Override
    public Activity getActivityTemplate(String type, boolean assertExists) throws StrolchException {
        return (Activity)this.getActivityMap().getTemplate(this, type, assertExists);
    }

    @Override
    public Order getOrderBy(String type, String id) {
        return this.getOrderBy(type, id, false);
    }

    @Override
    public Order getOrderBy(String type, String id, boolean assertExists) throws StrolchException {
        return (Order)this.getOrderMap().getBy((StrolchTransaction)this, type, id, assertExists);
    }

    @Override
    public Order getOrderBy(StringParameter refP) throws StrolchException {
        DBC.PRE.assertNotNull("refP", (Object)refP);
        return this.getOrderBy(refP, false);
    }

    @Override
    public Order getOrderBy(StringParameter refP, boolean assertExists) throws StrolchException {
        DBC.PRE.assertNotNull("refP", (Object)refP);
        return (Order)this.getOrderMap().getBy((StrolchTransaction)this, refP, assertExists);
    }

    @Override
    public List<Order> getOrdersBy(StringListParameter refP) throws StrolchException {
        DBC.PRE.assertNotNull("refP", (Object)refP);
        return this.getOrderMap().getBy((StrolchTransaction)this, refP, false);
    }

    @Override
    public List<Order> getOrdersBy(StringListParameter refP, boolean assertExists) throws StrolchException {
        DBC.PRE.assertNotNull("refP", (Object)refP);
        return this.getOrderMap().getBy((StrolchTransaction)this, refP, assertExists);
    }

    @Override
    public Resource getResourceBy(String type, String id) {
        return this.getResourceBy(type, id, false);
    }

    @Override
    public Resource getResourceBy(String type, String id, boolean assertExists) throws StrolchException {
        Resource resource = (Resource)this.getResourceMap().getBy((StrolchTransaction)this, type, id);
        if (assertExists && resource == null) {
            String msg = "No Resource exists with the id {0} with type {1}";
            throw new StrolchException(MessageFormat.format(msg, id, type));
        }
        return resource;
    }

    @Override
    public Resource getResourceBy(StringParameter refP) throws StrolchException {
        DBC.PRE.assertNotNull("refP", (Object)refP);
        return this.getResourceBy(refP, false);
    }

    @Override
    public Resource getResourceBy(StringParameter refP, boolean assertExists) throws StrolchException {
        DBC.PRE.assertNotNull("refP", (Object)refP);
        return (Resource)this.getResourceMap().getBy((StrolchTransaction)this, refP, assertExists);
    }

    @Override
    public List<Resource> getResourcesBy(StringListParameter refP) throws StrolchException {
        DBC.PRE.assertNotNull("refP", (Object)refP);
        return this.getResourceMap().getBy((StrolchTransaction)this, refP, false);
    }

    @Override
    public List<Resource> getResourcesBy(StringListParameter refP, boolean assertExists) throws StrolchException {
        DBC.PRE.assertNotNull("refP", (Object)refP);
        return this.getResourceMap().getBy((StrolchTransaction)this, refP, assertExists);
    }

    @Override
    public Activity getActivityBy(String type, String id) {
        return this.getActivityBy(type, id, false);
    }

    @Override
    public Activity getActivityBy(String type, String id, boolean assertExists) throws StrolchException {
        Activity activity = (Activity)this.getActivityMap().getBy((StrolchTransaction)this, type, id);
        if (assertExists && activity == null) {
            String msg = "No Activity exists with the id {0} with type {1}";
            throw new StrolchException(MessageFormat.format(msg, id, type));
        }
        return activity;
    }

    @Override
    public Activity getActivityBy(StringParameter refP) throws StrolchException {
        DBC.PRE.assertNotNull("refP", (Object)refP);
        return this.getActivityBy(refP, false);
    }

    @Override
    public Activity getActivityBy(StringParameter refP, boolean assertExists) throws StrolchException {
        DBC.PRE.assertNotNull("refP", (Object)refP);
        return (Activity)this.getActivityMap().getBy((StrolchTransaction)this, refP, assertExists);
    }

    @Override
    public List<Activity> getActivitiesBy(StringListParameter refP) throws StrolchException {
        DBC.PRE.assertNotNull("refP", (Object)refP);
        return this.getActivityMap().getBy((StrolchTransaction)this, refP, false);
    }

    @Override
    public List<Activity> getActivitiesBy(StringListParameter refP, boolean assertExists) throws StrolchException {
        DBC.PRE.assertNotNull("refP", (Object)refP);
        return this.getActivityMap().getBy((StrolchTransaction)this, refP, assertExists);
    }

    @Override
    public void flush() {
        try {
            this.validateCommands();
            this.doCommands();
            this.writeChanges();
        }
        catch (Exception e) {
            this.closeStrategy = TransactionCloseStrategy.ROLLBACK;
            String msg = "Strolch Transaction for realm {0} failed due to {1}";
            msg = MessageFormat.format(msg, this.getRealmName(), ExceptionHelper.getExceptionMessage((Throwable)e));
            throw new StrolchTransactionException(msg, e);
        }
    }

    @Override
    public void autoCloseableCommit() {
        long start = System.nanoTime();
        try {
            this.txResult.setState(TransactionState.COMMITTING);
            this.validateCommands();
            this.doCommands();
            this.writeChanges();
            long auditTrailDuration = this.writeAuditTrail();
            long updateObserversDuration = this.updateObservers();
            this.commit();
            this.handleCommit(start, auditTrailDuration, updateObserversDuration);
            this.txResult.setState(TransactionState.COMMITTED);
        }
        catch (Exception e) {
            this.txResult.setState(TransactionState.ROLLING_BACK);
            try {
                this.undoCommands();
            }
            catch (Exception ex) {
                logger.error("Failed to commit transaction and then undo commands due to " + ex.getMessage(), (Throwable)ex);
                try {
                    this.rollback();
                    this.handleRollback(start);
                }
                catch (Exception exc) {
                    logger.error("Failed to roll back after failing to undo commands: " + exc.getMessage(), (Throwable)exc);
                }
                this.handleFailure(start, ex);
            }
            try {
                this.rollback();
                this.handleRollback(start);
            }
            catch (Exception ex) {
                logger.error("Failed to commit transaction and then rollback due to " + ex.getMessage(), (Throwable)ex);
                this.handleFailure(start, e);
            }
            this.txResult.setState(TransactionState.FAILED);
            String msg = "Strolch Transaction for realm {0} failed due to {1}";
            msg = MessageFormat.format(msg, this.getRealmName(), ExceptionHelper.getExceptionMessage((Throwable)e));
            throw new StrolchTransactionException(msg, e);
        }
        finally {
            this.releaseElementLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void autoCloseableRollback() {
        long start = System.nanoTime();
        logger.warn(MessageFormat.format("Rolling back TX for realm {0}...", this.getRealmName()));
        try {
            this.txResult.setState(TransactionState.ROLLING_BACK);
            this.undoCommands();
            this.rollback();
            this.handleRollback(start);
            this.txResult.setState(TransactionState.ROLLED_BACK);
        }
        catch (Exception e) {
            this.handleFailure(start, e);
            this.txResult.setState(TransactionState.FAILED);
        }
        finally {
            this.releaseElementLocks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void autoCloseableDoNothing() throws StrolchTransactionException {
        long start = System.nanoTime();
        try {
            this.txResult.setState(TransactionState.CLOSING);
            if (!this.commands.isEmpty()) {
                logger.error("There are commands registered on a read-only transaction. Changing to rollback! Probably due to an exception!");
                this.autoCloseableRollback();
                return;
            }
            long auditTrailDuration = this.writeAuditTrail();
            this.rollback();
            this.handleDoNothing(start, auditTrailDuration);
            this.txResult.setState(TransactionState.CLOSED);
        }
        catch (Exception e) {
            this.handleFailure(start, e);
            this.txResult.setState(TransactionState.FAILED);
        }
        finally {
            this.releaseElementLocks();
        }
    }

    protected abstract void writeChanges() throws Exception;

    protected abstract void rollback() throws Exception;

    protected abstract void commit() throws Exception;

    private void handleDoNothing(long start, long auditTrailDuration) {
        if (this.suppressDoNothingLogging) {
            return;
        }
        long end = System.nanoTime();
        long txDuration = end - this.txResult.getStartNanos();
        long closeDuration = end - start;
        this.txResult.setTxDuration(txDuration);
        this.txResult.setCloseDuration(closeDuration);
        StringBuilder sb = new StringBuilder();
        sb.append("TX user=");
        sb.append(this.certificate.getUsername());
        sb.append(", realm=");
        sb.append(this.getRealmName());
        sb.append(", took=");
        sb.append(StringHelper.formatNanoDuration((long)txDuration));
        sb.append(", action=");
        sb.append(this.action);
        if (closeDuration >= 100000000L) {
            sb.append(", close=");
            sb.append(StringHelper.formatNanoDuration((long)closeDuration));
        }
        if (this.isAuditTrailEnabled() && auditTrailDuration >= 100000000L) {
            sb.append(", auditTrail=");
            sb.append(StringHelper.formatNanoDuration((long)auditTrailDuration));
        }
        logger.info(sb.toString());
    }

    private void handleCommit(long start, long auditTrailDuration, long observerUpdateDuration) {
        long end = System.nanoTime();
        long txDuration = end - this.txResult.getStartNanos();
        long closeDuration = end - start;
        this.txResult.setTxDuration(txDuration);
        this.txResult.setCloseDuration(closeDuration);
        StringBuilder sb = new StringBuilder();
        sb.append("TX user=");
        sb.append(this.certificate.getUsername());
        sb.append(", realm=");
        sb.append(this.getRealmName());
        sb.append(", took=");
        sb.append(StringHelper.formatNanoDuration((long)txDuration));
        sb.append(", action=");
        sb.append(this.action);
        if (closeDuration >= 100000000L) {
            sb.append(", close=");
            sb.append(StringHelper.formatNanoDuration((long)closeDuration));
        }
        if (this.isAuditTrailEnabled() && auditTrailDuration >= 100000000L) {
            sb.append(", auditTrail=");
            sb.append(StringHelper.formatNanoDuration((long)auditTrailDuration));
        }
        if (this.isObserverUpdatesEnabled() && observerUpdateDuration >= 100000000L) {
            sb.append(", updates=");
            sb.append(StringHelper.formatNanoDuration((long)observerUpdateDuration));
        }
        logger.info(sb.toString());
    }

    private void handleRollback(long start) {
        long end = System.nanoTime();
        long txDuration = end - this.txResult.getStartNanos();
        long closeDuration = end - start;
        this.txResult.setTxDuration(txDuration);
        this.txResult.setCloseDuration(closeDuration);
        StringBuilder sb = new StringBuilder();
        sb.append("TX ROLLBACK user=");
        sb.append(this.certificate.getUsername());
        sb.append(", realm=");
        sb.append(this.getRealmName());
        sb.append(" failed=");
        sb.append(StringHelper.formatNanoDuration((long)txDuration));
        sb.append(", action=");
        sb.append(this.action);
        if (closeDuration >= 100000000L) {
            sb.append(", close=");
            sb.append(StringHelper.formatNanoDuration((long)closeDuration));
        }
        logger.error(sb.toString());
    }

    protected void handleFailure(long closeStartNanos, Exception e) {
        long end = System.nanoTime();
        long txDuration = end - this.txResult.getStartNanos();
        long closeDuration = end - closeStartNanos;
        this.txResult.setState(TransactionState.FAILED);
        this.txResult.setTxDuration(txDuration);
        this.txResult.setCloseDuration(closeDuration);
        StringBuilder sb = new StringBuilder();
        sb.append("TX FAILED user=");
        sb.append(this.certificate.getUsername());
        sb.append(", realm=");
        sb.append(this.getRealmName());
        sb.append(" failed=");
        sb.append(StringHelper.formatNanoDuration((long)txDuration));
        sb.append(", action=");
        sb.append(this.action);
        if (closeDuration >= 100000000L) {
            sb.append(", close=");
            sb.append(StringHelper.formatNanoDuration((long)closeDuration));
        }
        String msg = "Strolch Transaction for realm {0} failed due to {1}\n{2}";
        msg = MessageFormat.format(msg, this.getRealmName(), ExceptionHelper.getExceptionMessage((Throwable)e), sb.toString());
        throw new StrolchTransactionException(msg, e);
    }

    private boolean isAuditTrailEnabled() {
        return this.getAuditTrail().isEnabled();
    }

    private long updateObservers() {
        if (!this.isObserverUpdatesEnabled()) {
            return 0L;
        }
        long observerUpdateStart = System.nanoTime();
        ObserverHandler observerHandler = this.realm.getObserverHandler();
        if (this.orderMap != null) {
            observerHandler.add("Order", new ArrayList<StrolchRootElement>(this.orderMap.getCreated()));
            observerHandler.update("Order", new ArrayList<StrolchRootElement>(this.orderMap.getUpdated()));
            observerHandler.remove("Order", new ArrayList<StrolchRootElement>(this.orderMap.getDeleted()));
        }
        if (this.resourceMap != null) {
            observerHandler.add("Resource", new ArrayList<StrolchRootElement>(this.resourceMap.getCreated()));
            observerHandler.update("Resource", new ArrayList<StrolchRootElement>(this.resourceMap.getUpdated()));
            observerHandler.remove("Resource", new ArrayList<StrolchRootElement>(this.resourceMap.getDeleted()));
        }
        long observerUpdateDuration = System.nanoTime() - observerUpdateStart;
        return observerUpdateDuration;
    }

    private boolean isObserverUpdatesEnabled() {
        return !this.suppressUpdates && this.realm.isUpdateObservers();
    }

    private long writeAuditTrail() {
        if (!this.isAuditTrailEnabled()) {
            return 0L;
        }
        if (this.isSuppressAudits()) {
            return 0L;
        }
        long auditTrailStart = System.nanoTime();
        ArrayList<Audit> audits = new ArrayList<Audit>();
        if (this.orderMap != null) {
            if (this.realm.isAuditTrailEnabledForRead()) {
                this.auditsFor(audits, AccessType.READ, "Order", this.orderMap.getRead());
            }
            this.auditsFor(audits, AccessType.CREATE, "Order", this.orderMap.getCreated());
            this.auditsFor(audits, AccessType.UPDATE, "Order", this.orderMap.getUpdated());
            this.auditsFor(audits, AccessType.DELETE, "Order", this.orderMap.getDeleted());
        }
        if (this.resourceMap != null) {
            if (this.realm.isAuditTrailEnabledForRead()) {
                this.auditsFor(audits, AccessType.READ, "Resource", this.resourceMap.getRead());
            }
            this.auditsFor(audits, AccessType.CREATE, "Resource", this.resourceMap.getCreated());
            this.auditsFor(audits, AccessType.UPDATE, "Resource", this.resourceMap.getUpdated());
            this.auditsFor(audits, AccessType.DELETE, "Resource", this.resourceMap.getDeleted());
        }
        if (this.auditTrail != null) {
            if (this.realm.isAuditTrailEnabledForRead()) {
                this.auditsForAudits(audits, AccessType.READ, "Audit", this.auditTrail.getRead());
            }
            this.auditsForAudits(audits, AccessType.CREATE, "Audit", this.auditTrail.getCreated());
            this.auditsForAudits(audits, AccessType.UPDATE, "Audit", this.auditTrail.getUpdated());
            this.auditsForAudits(audits, AccessType.DELETE, "Audit", this.auditTrail.getDeleted());
        }
        this.realm.getAuditTrail().addAll(this, audits);
        long auditTrailDuration = System.nanoTime() - auditTrailStart;
        return auditTrailDuration;
    }

    private <T extends StrolchRootElement> void auditsFor(List<Audit> audits, AccessType accessType, String elementType, Set<T> elements) {
        for (StrolchRootElement element : elements) {
            audits.add(this.auditFrom(accessType, element));
        }
    }

    private <T extends StrolchRootElement> void auditsForAudits(List<Audit> audits, AccessType accessType, String elementType, Set<Audit> elements) {
        for (Audit element : elements) {
            audits.add(this.auditFrom(accessType, elementType, "-", element.getId().toString()));
        }
    }

    @Override
    public Audit auditFrom(AccessType accessType, StrolchRootElement element) {
        String type = (String)element.accept((StrolchRootElementVisitor)new ElementTypeVisitor());
        String subType = element.getType();
        String id = element.getId();
        return this.auditFrom(accessType, type, subType, id);
    }

    @Override
    public Audit auditFrom(AccessType accessType, String elementType, String elementSubType, String id) {
        Audit audit = new Audit();
        audit.setId(StrolchAgent.getUniqueIdLong().longValue());
        audit.setUsername(this.certificate.getUsername());
        audit.setFirstname(this.certificate.getFirstname());
        audit.setLastname(this.certificate.getLastname());
        audit.setDate(new Date());
        audit.setElementType(elementType);
        audit.setElementSubType(elementSubType);
        audit.setElementAccessed(id);
        audit.setAction(this.action);
        audit.setAccessType(accessType);
        return audit;
    }

    private void validateCommands() {
        for (Command command : this.commands) {
            command.validate();
        }
    }

    private void doCommands() {
        ListIterator<Command> iter = this.commands.listIterator();
        while (iter.hasNext()) {
            Command command = iter.next();
            this.flushedCommands.add(command);
            command.doCommand();
            iter.remove();
        }
    }

    private void undoCommands() {
        ListIterator<Command> iter = this.flushedCommands.listIterator(this.flushedCommands.size());
        while (iter.hasPrevious()) {
            Command command = iter.previous();
            command.undo();
            iter.remove();
        }
    }
}

