/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.api;

import java.util.List;
import li.strolch.agent.api.ActivityMap;
import li.strolch.agent.api.AuditTrail;
import li.strolch.agent.api.OrderMap;
import li.strolch.agent.api.ResourceMap;
import li.strolch.agent.api.StrolchLockException;
import li.strolch.exception.StrolchException;
import li.strolch.model.Locator;
import li.strolch.model.Order;
import li.strolch.model.Resource;
import li.strolch.model.StrolchElement;
import li.strolch.model.StrolchRootElement;
import li.strolch.model.activity.Activity;
import li.strolch.model.audit.AccessType;
import li.strolch.model.audit.Audit;
import li.strolch.model.audit.AuditQuery;
import li.strolch.model.parameter.StringListParameter;
import li.strolch.model.parameter.StringParameter;
import li.strolch.model.query.ActivityQuery;
import li.strolch.model.query.OrderQuery;
import li.strolch.model.query.ResourceQuery;
import li.strolch.persistence.api.PersistenceHandler;
import li.strolch.persistence.api.StrolchTransactionException;
import li.strolch.persistence.api.TransactionCloseStrategy;
import li.strolch.persistence.api.TransactionState;
import li.strolch.privilege.model.Certificate;
import li.strolch.service.api.Command;

public interface StrolchTransaction
extends AutoCloseable {
    public String getRealmName();

    public Certificate getCertificate();

    public AuditTrail getAuditTrail();

    public ResourceMap getResourceMap();

    public OrderMap getOrderMap();

    public ActivityMap getActivityMap();

    public PersistenceHandler getPersistenceHandler();

    public TransactionCloseStrategy getCloseStrategy();

    public void autoCloseableDoNothing() throws StrolchTransactionException;

    public void autoCloseableCommit() throws StrolchTransactionException;

    public void autoCloseableRollback() throws StrolchTransactionException;

    @Override
    public void close() throws StrolchTransactionException;

    public void doNothingOnClose();

    public void commitOnClose();

    public void rollbackOnClose();

    public StrolchTransactionException fail(String var1);

    public void flush();

    public TransactionState getState();

    public boolean isRollingBack();

    public boolean isCommitting();

    public boolean isClosing();

    public void setSuppressUpdates(boolean var1);

    public boolean isSuppressUpdates();

    public void setSuppressAudits(boolean var1);

    public boolean isSuppressAudits();

    public void setSuppressDoNothingLogging(boolean var1);

    public boolean isSuppressDoNothingLogging();

    public boolean isVersioningEnabled();

    public <T extends StrolchRootElement> void lock(T var1) throws StrolchLockException;

    public <T extends StrolchRootElement> void releaseLock(T var1) throws StrolchLockException;

    public void addCommand(Command var1);

    public Audit auditFrom(AccessType var1, String var2, String var3, String var4);

    public Audit auditFrom(AccessType var1, StrolchRootElement var2);

    public <U> List<U> doQuery(OrderQuery<U> var1);

    public <U> List<U> doQuery(ResourceQuery<U> var1);

    public <U> List<U> doQuery(ActivityQuery<U> var1);

    public <U> List<U> doQuery(AuditQuery<U> var1);

    public <T extends StrolchElement> T findElement(Locator var1) throws StrolchException, ClassCastException;

    public Resource getResourceTemplate(String var1);

    public Resource getResourceTemplate(String var1, boolean var2) throws StrolchException;

    public Order getOrderTemplate(String var1);

    public Order getOrderTemplate(String var1, boolean var2) throws StrolchException;

    public Activity getActivityTemplate(String var1);

    public Activity getActivityTemplate(String var1, boolean var2) throws StrolchException;

    public Resource getResourceBy(String var1, String var2);

    public Resource getResourceBy(String var1, String var2, boolean var3) throws StrolchException;

    public Resource getResourceBy(StringParameter var1) throws StrolchException;

    public Resource getResourceBy(StringParameter var1, boolean var2) throws StrolchException;

    public List<Resource> getResourcesBy(StringListParameter var1) throws StrolchException;

    public List<Resource> getResourcesBy(StringListParameter var1, boolean var2) throws StrolchException;

    public Activity getActivityBy(String var1, String var2);

    public Activity getActivityBy(String var1, String var2, boolean var3) throws StrolchException;

    public Activity getActivityBy(StringParameter var1) throws StrolchException;

    public Activity getActivityBy(StringParameter var1, boolean var2) throws StrolchException;

    public List<Activity> getActivitiesBy(StringListParameter var1) throws StrolchException;

    public List<Activity> getActivitiesBy(StringListParameter var1, boolean var2) throws StrolchException;

    public Order getOrderBy(String var1, String var2);

    public Order getOrderBy(String var1, String var2, boolean var3) throws StrolchException;

    public Order getOrderBy(StringParameter var1) throws StrolchException;

    public Order getOrderBy(StringParameter var1, boolean var2) throws StrolchException;

    public List<Order> getOrdersBy(StringListParameter var1) throws StrolchException;

    public List<Order> getOrdersBy(StringListParameter var1, boolean var2) throws StrolchException;
}

