/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.api;

import java.util.Date;
import li.strolch.persistence.api.TransactionState;
import li.strolch.utils.helper.StringHelper;

public class TransactionResult {
    private String realm;
    private TransactionState state;
    private Exception failCause;
    private long startNanos;
    private Date startTime;
    private long txDuration;
    private long closeDuration;
    private long created;
    private long read;
    private long updated;
    private long deleted;

    public TransactionResult(String realm, long startNanos, Date startDate) {
        this.realm = realm;
        this.startNanos = startNanos;
        this.startTime = startDate;
        this.state = TransactionState.OPEN;
    }

    public String getRealm() {
        return this.realm;
    }

    public TransactionState getState() {
        return this.state;
    }

    public void setState(TransactionState state) {
        this.state = state;
    }

    public Exception getFailCause() {
        return this.failCause;
    }

    public void setFailCause(Exception failCause) {
        this.failCause = failCause;
    }

    public long getStartNanos() {
        return this.startNanos;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public long getTxDuration() {
        return this.txDuration;
    }

    public void setTxDuration(long txDuration) {
        this.txDuration = txDuration;
    }

    public long getCloseDuration() {
        return this.closeDuration;
    }

    public void setCloseDuration(long closeDuration) {
        this.closeDuration = closeDuration;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public long getRead() {
        return this.read;
    }

    public void setRead(long read) {
        this.read = read;
    }

    public long getUpdated() {
        return this.updated;
    }

    public void setUpdated(long updated) {
        this.updated = updated;
    }

    public long getDeleted() {
        return this.deleted;
    }

    public void setDeleted(long deleted) {
        this.deleted = deleted;
    }

    public void incCreated(long created) {
        this.created += created;
    }

    public void incRead(long read) {
        this.read += read;
    }

    public void incUpdated(long updated) {
        this.updated += updated;
    }

    public void incDeleted(long deleted) {
        this.deleted += deleted;
    }

    private long getAccessed() {
        return this.created + this.read + this.updated + this.deleted;
    }

    public String getLogMessage() {
        StringBuilder sb = new StringBuilder();
        switch (this.state) {
            case OPEN: {
                sb.append("TX is still open after ");
                break;
            }
            case COMMITTED: {
                sb.append("TX was completed after ");
                break;
            }
            case ROLLED_BACK: {
                sb.append("TX was rolled back after ");
                break;
            }
            case FAILED: {
                sb.append("TX has failed after ");
                break;
            }
            default: {
                sb.append("TX is in unhandled state ");
                sb.append((Object)this.state);
                sb.append(" after ");
            }
        }
        sb.append(StringHelper.formatNanoDuration((long)this.txDuration));
        sb.append(" with close operation taking ");
        sb.append(StringHelper.formatNanoDuration((long)this.closeDuration));
        sb.append(". ");
        sb.append(this.getAccessed());
        sb.append(" objects accessed (");
        sb.append(this.created);
        sb.append(" created, ");
        sb.append(this.read);
        sb.append(" read, ");
        sb.append(this.updated);
        sb.append(" updated, ");
        sb.append(this.deleted);
        sb.append(" deleted, ");
        return sb.toString();
    }

    public void clear() {
        this.realm = null;
        this.state = null;
        this.failCause = null;
        this.startTime = null;
        this.txDuration = 0L;
        this.closeDuration = 0L;
        this.created = 0L;
        this.read = 0L;
        this.updated = 0L;
        this.deleted = 0L;
    }
}

