/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.inmemory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import li.strolch.model.audit.Audit;
import li.strolch.model.audit.AuditQuery;
import li.strolch.persistence.api.AuditDao;
import li.strolch.runtime.query.inmemory.InMemoryAuditQuery;
import li.strolch.runtime.query.inmemory.InMemoryAuditQueryVisitor;
import li.strolch.utils.collections.DateRange;
import li.strolch.utils.collections.MapOfMaps;

public class InMemoryAuditDao
implements AuditDao {
    private MapOfMaps<String, Long, Audit> auditMap = new MapOfMaps();

    @Override
    public synchronized boolean hasElement(String type, Long id) {
        Map byType = this.auditMap.getMap((Object)type);
        if (byType == null) {
            return false;
        }
        return byType.containsKey(id);
    }

    @Override
    public synchronized long querySize(DateRange dateRange) {
        long size = 0L;
        for (String type : this.auditMap.keySet()) {
            Map byType = this.auditMap.getMap((Object)type);
            for (Audit audit : byType.values()) {
                if (!dateRange.contains(audit.getDate())) continue;
                ++size;
            }
        }
        return size;
    }

    @Override
    public synchronized long querySize(String type, DateRange dateRange) {
        Map byType = this.auditMap.getMap((Object)type);
        if (byType == null) {
            return 0L;
        }
        long size = 0L;
        for (Audit audit : byType.values()) {
            if (!dateRange.contains(audit.getDate())) continue;
            ++size;
        }
        return size;
    }

    @Override
    public synchronized Audit queryBy(String type, Long id) {
        return (Audit)this.auditMap.getElement((Object)type, (Object)id);
    }

    @Override
    public synchronized Set<String> queryTypes() {
        return new HashSet<String>(this.auditMap.keySet());
    }

    @Override
    public synchronized List<Audit> queryAll(String type, DateRange dateRange) {
        ArrayList<Audit> audits = new ArrayList<Audit>();
        Map byType = this.auditMap.getMap((Object)type);
        if (byType == null) {
            return audits;
        }
        for (Audit audit : byType.values()) {
            if (!dateRange.contains(audit.getDate())) continue;
            audits.add(audit);
        }
        return audits;
    }

    @Override
    public synchronized void save(Audit audit) {
        this.auditMap.addElement((Object)audit.getElementType(), (Object)audit.getId(), (Object)audit);
    }

    @Override
    public synchronized void saveAll(List<Audit> audits) {
        for (Audit audit : audits) {
            this.auditMap.addElement((Object)audit.getElementType(), (Object)audit.getId(), (Object)audit);
        }
    }

    @Override
    public synchronized void update(Audit audit) {
        this.auditMap.addElement((Object)audit.getElementType(), (Object)audit.getId(), (Object)audit);
    }

    @Override
    public synchronized void updateAll(List<Audit> audits) {
        for (Audit audit : audits) {
            this.auditMap.addElement((Object)audit.getElementType(), (Object)audit.getId(), (Object)audit);
        }
    }

    @Override
    public synchronized void remove(Audit audit) {
        this.auditMap.removeElement((Object)audit.getElementType(), (Object)audit.getId());
    }

    @Override
    public synchronized void removeAll(List<Audit> audits) {
        for (Audit audit : audits) {
            this.auditMap.removeElement((Object)audit.getElementType(), (Object)audit.getId());
        }
    }

    @Override
    public synchronized long removeAll(String type, DateRange dateRange) {
        Map byType = this.auditMap.getMap((Object)type);
        if (byType == null) {
            return 0L;
        }
        ArrayList<Audit> toRemoveList = new ArrayList<Audit>();
        for (Audit audit : byType.values()) {
            if (!dateRange.contains(audit.getDate())) continue;
            toRemoveList.add(audit);
        }
        for (Audit toRemove : toRemoveList) {
            this.auditMap.removeElement((Object)type, (Object)toRemove.getId());
        }
        return toRemoveList.size();
    }

    @Override
    public <U> List<U> doQuery(AuditQuery<U> auditQuery) {
        InMemoryAuditQueryVisitor<U> visitor = new InMemoryAuditQueryVisitor<U>();
        InMemoryAuditQuery query = visitor.toInMemory(auditQuery);
        return query.doQuery(this);
    }
}

