/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.persistence.inmemory;

import java.util.HashMap;
import java.util.Map;
import li.strolch.agent.api.StrolchRealm;
import li.strolch.persistence.api.ActivityDao;
import li.strolch.persistence.api.AuditDao;
import li.strolch.persistence.api.OrderDao;
import li.strolch.persistence.api.PersistenceHandler;
import li.strolch.persistence.api.ResourceDao;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.persistence.inmemory.InMemoryActivityDao;
import li.strolch.persistence.inmemory.InMemoryAuditDao;
import li.strolch.persistence.inmemory.InMemoryOrderDao;
import li.strolch.persistence.inmemory.InMemoryResourceDao;
import li.strolch.persistence.inmemory.InMemoryTransaction;
import li.strolch.privilege.model.Certificate;
import li.strolch.runtime.privilege.PrivilegeHandler;

public class InMemoryPersistence
implements PersistenceHandler {
    private boolean versioningEnabled;
    private Map<String, DaoCache> daoCache;
    private PrivilegeHandler privilegeHandler;

    public InMemoryPersistence(PrivilegeHandler privilegeHandler, boolean versioningEnabled) {
        this.privilegeHandler = privilegeHandler;
        this.versioningEnabled = versioningEnabled;
        this.daoCache = new HashMap<String, DaoCache>();
    }

    @Override
    public StrolchTransaction openTx(StrolchRealm realm, Certificate certificate, String action) {
        return new InMemoryTransaction(this.privilegeHandler, realm, certificate, action, this);
    }

    @Override
    public OrderDao getOrderDao(StrolchTransaction tx) {
        DaoCache daoCache = this.getDaoCache(tx);
        return daoCache.getOrderDao();
    }

    @Override
    public ResourceDao getResourceDao(StrolchTransaction tx) {
        DaoCache daoCache = this.getDaoCache(tx);
        return daoCache.getResourceDao();
    }

    @Override
    public ActivityDao getActivityDao(StrolchTransaction tx) {
        DaoCache daoCache = this.getDaoCache(tx);
        return daoCache.getActivityDao();
    }

    @Override
    public AuditDao getAuditDao(StrolchTransaction tx) {
        DaoCache daoCache = this.getDaoCache(tx);
        return daoCache.getAuditDao();
    }

    @Override
    public void performDbInitialization() {
    }

    private synchronized DaoCache getDaoCache(StrolchTransaction tx) {
        DaoCache daoCache = this.daoCache.get(tx.getRealmName());
        if (daoCache == null) {
            daoCache = new DaoCache(new InMemoryOrderDao(this.versioningEnabled), new InMemoryResourceDao(this.versioningEnabled), new InMemoryActivityDao(this.versioningEnabled), new InMemoryAuditDao());
            this.daoCache.put(tx.getRealmName(), daoCache);
        }
        return daoCache;
    }

    private class DaoCache {
        private OrderDao orderDao;
        private ResourceDao resourceDao;
        private ActivityDao activityDao;
        private AuditDao auditDao;

        public DaoCache(OrderDao orderDao, ResourceDao resourceDao, ActivityDao activityDao, AuditDao auditDao) {
            this.orderDao = orderDao;
            this.resourceDao = resourceDao;
            this.activityDao = activityDao;
            this.auditDao = auditDao;
        }

        public OrderDao getOrderDao() {
            return this.orderDao;
        }

        public ResourceDao getResourceDao() {
            return this.resourceDao;
        }

        public AuditDao getAuditDao() {
            return this.auditDao;
        }

        public ActivityDao getActivityDao() {
            return this.activityDao;
        }
    }
}

