/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.policy;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Map;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.StrolchComponent;
import li.strolch.exception.StrolchPolicyException;
import li.strolch.model.policy.JavaPolicyDef;
import li.strolch.model.policy.KeyPolicyDef;
import li.strolch.model.policy.PolicyDef;
import li.strolch.model.policy.PolicyDefVisitor;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.policy.PolicyHandler;
import li.strolch.policy.StrolchPolicy;
import li.strolch.policy.StrolchPolicyFileParser;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.utils.collections.MapOfMaps;
import li.strolch.utils.helper.XmlHelper;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultPolicyHandler
extends StrolchComponent
implements PolicyHandler,
PolicyDefVisitor {
    private static final String PROP_POLICY_CONFIG = "policyConfig";
    private static final String PROP_READ_POLICY_FILE = "readPolicyFile";
    private static final String DEF_STROLCH_POLICIES_XML = "StrolchPolicies.xml";
    private MapOfMaps<String, String, Class<? extends StrolchPolicy>> classByTypeMap;

    public DefaultPolicyHandler(ComponentContainer container, String componentName) {
        super(container, componentName);
    }

    @Override
    public void initialize(ComponentConfiguration configuration) throws Exception {
        if (configuration.getBoolean(PROP_READ_POLICY_FILE, Boolean.FALSE)) {
            File policyFile = configuration.getConfigFile(PROP_POLICY_CONFIG, DEF_STROLCH_POLICIES_XML, configuration.getRuntimeConfiguration());
            this.parsePolicyFile(policyFile);
        } else {
            logger.warn("Not loading Policy configuration file, as disabled by config");
        }
        super.initialize(configuration);
    }

    @Override
    public <T extends StrolchPolicy> T getPolicy(PolicyDef policyDef, StrolchTransaction tx) {
        try {
            Class clazz = policyDef.accept((PolicyDefVisitor)this);
            Constructor constructor = clazz.getConstructor(ComponentContainer.class, StrolchTransaction.class);
            return (T)((StrolchPolicy)constructor.newInstance(this.getContainer(), tx));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new StrolchPolicyException(MessageFormat.format("Failed to instantiate policy {0} due to {1}", policyDef, e.getMessage()), (Throwable)e);
        }
    }

    public <T> Class<T> visit(JavaPolicyDef policyDef) throws ClassNotFoundException {
        String value = policyDef.getValue();
        Class<?> clazz = Class.forName(value);
        return clazz;
    }

    public <T> Class<T> visit(KeyPolicyDef policyDef) throws ClassNotFoundException {
        Class clazz = (Class)this.classByTypeMap.getElement((Object)policyDef.getType(), (Object)policyDef.getValue());
        if (clazz == null) {
            throw new StrolchPolicyException(MessageFormat.format("No policy is configured for {0}", policyDef));
        }
        return clazz;
    }

    private void parsePolicyFile(File policyFile) {
        StrolchPolicyFileParser xmlHandler = new StrolchPolicyFileParser();
        XmlHelper.parseDocument((File)policyFile, (DefaultHandler)xmlHandler);
        StrolchPolicyFileParser.PolicyModel policyModel = xmlHandler.getPolicyModel();
        Map<String, StrolchPolicyFileParser.PolicyType> policyTypes = policyModel.getPolicyTypes();
        this.classByTypeMap = new MapOfMaps();
        for (StrolchPolicyFileParser.PolicyType policyType : policyTypes.values()) {
            String type = policyType.getType();
            String api = policyType.getApi();
            try {
                Class<?> apiClass = Class.forName(api);
                Map<String, String> policyByKeyMap = policyType.getPolicyByKeyMap();
                for (String key : policyByKeyMap.keySet()) {
                    String className = policyByKeyMap.get(key);
                    try {
                        Class<?> implClass = Class.forName(className);
                        if (!StrolchPolicy.class.isAssignableFrom(implClass)) {
                            throw new StrolchPolicyException("Invalid Policy configuration for Type=" + type + " Key=" + key + " as " + className + " is not a " + StrolchPolicy.class.getName());
                        }
                        if (!apiClass.isAssignableFrom(implClass)) {
                            throw new StrolchPolicyException("Invalid Policy configuration for Type=" + type + " Key=" + key + " as " + className + " is not assignable from " + api);
                        }
                        logger.info("Loaded Policy " + type + " / " + key + " / " + className);
                        this.classByTypeMap.addElement((Object)type, (Object)key, implClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new StrolchPolicyException("Invalid Policy configuration for Type=" + type + " Key=" + key + " due to " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new StrolchPolicyException("Invalid PolicyType configuration for Type=" + type + " due to " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

