/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.policy;

import li.strolch.agent.api.ComponentContainer;
import li.strolch.exception.StrolchException;
import li.strolch.model.Resource;
import li.strolch.model.activity.Action;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.utils.helper.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StrolchPolicy {
    protected static final Logger logger = LoggerFactory.getLogger(StrolchPolicy.class);
    private final ComponentContainer container;
    private final StrolchTransaction tx;

    public StrolchPolicy(ComponentContainer container, StrolchTransaction tx) {
        this.container = container;
        this.tx = tx;
    }

    protected <V> V getComponent(Class<V> clazz) throws IllegalArgumentException {
        return this.container.getComponent(clazz);
    }

    protected ComponentContainer getContainer() {
        return this.container;
    }

    protected StrolchTransaction tx() {
        return this.tx;
    }

    protected Resource getResource(Action action) throws IllegalArgumentException, StrolchException {
        String resourceId = action.getResourceId();
        if (StringHelper.isEmpty((String)resourceId) || resourceId.equals("-")) {
            throw new IllegalArgumentException("No resourceId defined on action " + action.getLocator());
        }
        String resourceType = action.getResourceType();
        if (StringHelper.isEmpty((String)resourceType) || resourceType.equals("-")) {
            throw new IllegalArgumentException("No resourceType defined on action " + action.getLocator());
        }
        Resource resource = this.tx.getResourceBy(resourceType, resourceId, true);
        return resource;
    }

    public abstract void undo();
}

