/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.policy;

import java.util.HashMap;
import java.util.Map;
import li.strolch.utils.dbc.DBC;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StrolchPolicyFileParser
extends DefaultHandler {
    public static final String POLICY = "Policy";
    public static final String POLICY_TYPE = "PolicyType";
    public static final String TYPE = "Type";
    public static final String API = "Api";
    public static final String KEY = "Key";
    public static final String CLASS = "Class";
    private PolicyModel policyModel = new PolicyModel();
    private PolicyType policyType;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (qName) {
            case "PolicyType": {
                String type = attributes.getValue(TYPE);
                String api = attributes.getValue(API);
                DBC.PRE.assertNotEmpty("Type not defined on a PolicyType", type);
                DBC.PRE.assertNotEmpty("Api not defined on a PolicyType", api);
                this.policyType = new PolicyType(type, api);
                this.policyModel.getPolicyTypes().put(type, this.policyType);
                break;
            }
            case "Policy": {
                String key = attributes.getValue(KEY);
                String clazz = attributes.getValue(CLASS);
                DBC.PRE.assertNotEmpty("Key not defined on a PolicyType", key);
                DBC.PRE.assertNotEmpty("Class not defined on a PolicyType", clazz);
                this.policyType.getPolicyByKeyMap().put(key, clazz);
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (qName) {
            case "PolicyType": {
                this.policyType = null;
                break;
            }
        }
    }

    public PolicyModel getPolicyModel() {
        return this.policyModel;
    }

    public class PolicyType {
        private String type;
        private String api;
        private Map<String, String> policyByKeyMap;

        public PolicyType(String type, String api) {
            this.type = type;
            this.api = api;
            this.policyByKeyMap = new HashMap<String, String>();
        }

        public String getApi() {
            return this.api;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, String> getPolicyByKeyMap() {
            return this.policyByKeyMap;
        }
    }

    public class PolicyModel {
        private Map<String, PolicyType> policyTypes = new HashMap<String, PolicyType>();

        public Map<String, PolicyType> getPolicyTypes() {
            return this.policyTypes;
        }
    }
}

