/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.configuration;

import java.io.File;
import java.text.MessageFormat;
import li.strolch.runtime.configuration.ConfigurationSaxParser;
import li.strolch.runtime.configuration.StrolchConfiguration;
import li.strolch.runtime.configuration.StrolchConfigurationException;
import li.strolch.utils.dbc.DBC;
import li.strolch.utils.helper.XmlHelper;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigurationParser {
    public static final String STROLCH_CONFIGURATION_XML = "StrolchConfiguration.xml";

    public static StrolchConfiguration parseConfiguration(String environment, File configPathF, File dataPathF, File tempPathF) {
        DBC.PRE.assertNotEmpty("environment value must be set!", environment);
        DBC.PRE.assertNotNull("configPathF must be set!", (Object)configPathF);
        DBC.PRE.assertNotNull("dataPathF must be set!", (Object)dataPathF);
        DBC.PRE.assertNotNull("tempPathF must be set!", (Object)tempPathF);
        DBC.PRE.assertNotEquals("environment must be a value other than 'global'!", (Object)"global", (Object)environment);
        if (!configPathF.isDirectory() || !configPathF.canRead()) {
            String msg = "Config path is not readable at {0}";
            msg = MessageFormat.format(msg, configPathF);
            throw new StrolchConfigurationException(msg);
        }
        if (!(dataPathF.isDirectory() && dataPathF.canRead() && dataPathF.canWrite())) {
            String msg = "Data path is not a directory or readable or writeable at {0}";
            msg = MessageFormat.format(msg, dataPathF);
            throw new StrolchConfigurationException(msg);
        }
        if (!(tempPathF.isDirectory() && tempPathF.canRead() && tempPathF.canWrite())) {
            String msg = "Temp path is not a directory or readable or writeable at {0}";
            msg = MessageFormat.format(msg, tempPathF);
            throw new StrolchConfigurationException(msg);
        }
        File configurationFile = new File(configPathF, STROLCH_CONFIGURATION_XML);
        if (!configurationFile.isFile() || !configurationFile.canRead()) {
            String msg = "Configuration file is not readable at {0}";
            msg = MessageFormat.format(msg, configurationFile);
            throw new StrolchConfigurationException(msg);
        }
        ConfigurationSaxParser configurationParser = new ConfigurationSaxParser(environment);
        XmlHelper.parseDocument((File)configurationFile, (DefaultHandler)configurationParser);
        ConfigurationSaxParser.ConfigurationBuilder globalEnvBuilder = configurationParser.getGlobalEnvBuilder();
        ConfigurationSaxParser.ConfigurationBuilder envBuilder = configurationParser.getEnvBuilder();
        if (envBuilder == null) {
            String msg = "The environment {0} does not exist!";
            msg = MessageFormat.format(msg, environment);
            throw new StrolchConfigurationException(msg);
        }
        globalEnvBuilder.merge(envBuilder);
        StrolchConfiguration strolchConfiguration = globalEnvBuilder.build(configPathF, dataPathF, tempPathF);
        return strolchConfiguration;
    }
}

