/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.configuration;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import li.strolch.model.Locator;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.runtime.configuration.RuntimeConfiguration;
import li.strolch.runtime.configuration.StrolchConfiguration;
import li.strolch.utils.dbc.DBC;
import li.strolch.utils.helper.StringHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigurationSaxParser
extends DefaultHandler {
    private final String environment;
    private String currentEnvironment;
    private ConfigurationBuilder globalEnvBuilder;
    private Map<String, ConfigurationBuilder> envBuilders;
    private Locator.LocatorBuilder locatorBuilder;
    private Deque<ElementHandler> delegateHandlers;

    public ConfigurationSaxParser(String environment) {
        this.environment = environment;
        this.locatorBuilder = new Locator.LocatorBuilder();
        this.delegateHandlers = new ArrayDeque<ElementHandler>();
        this.globalEnvBuilder = new ConfigurationBuilder();
        this.envBuilders = new HashMap<String, ConfigurationBuilder>();
    }

    public ConfigurationBuilder getGlobalEnvBuilder() {
        return this.globalEnvBuilder;
    }

    public ConfigurationBuilder getEnvBuilder() {
        return this.envBuilders.get(this.environment);
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getCurrentEnvironment() {
        return this.currentEnvironment;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.delegateHandlers.isEmpty()) {
            this.delegateHandlers.peek().characters(ch, start, length);
        }
    }

    private boolean isRequiredEnv(String env) {
        return env.equals("global") || env.equals(this.environment);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.locatorBuilder.append(qName);
        Locator locator = this.locatorBuilder.build();
        switch (locator.toString()) {
            case "StrolchConfiguration/env": {
                String env = attributes.getValue("id");
                DBC.PRE.assertNotEmpty("attribute 'id' must be set on element 'env'", env);
                if (this.envBuilders.containsKey(env)) {
                    String msg = "Environment {0} already exists!";
                    throw new IllegalStateException(MessageFormat.format(msg, env));
                }
                this.currentEnvironment = env;
                ConfigurationBuilder newEnvBuilder = new ConfigurationBuilder();
                newEnvBuilder.runtimeBuilder().setEnvironment(this.currentEnvironment);
                this.envBuilders.put(env, newEnvBuilder);
                break;
            }
            case "StrolchConfiguration/env/Runtime": {
                if (!this.isRequiredEnv(this.currentEnvironment)) break;
                ConfigurationBuilder configurationBuilder = this.getEnvBuilder(this.currentEnvironment);
                RuntimeHandler runtimeHandler = new RuntimeHandler(configurationBuilder, locator);
                this.delegateHandlers.push(runtimeHandler);
                break;
            }
            case "StrolchConfiguration/env/Runtime/Properties": {
                if (!this.isRequiredEnv(this.currentEnvironment)) break;
                ConfigurationBuilder configurationBuilder = this.getEnvBuilder(this.currentEnvironment);
                PropertiesHandler runtimePropertiesHandler = new PropertiesHandler(configurationBuilder, locator);
                this.delegateHandlers.push(runtimePropertiesHandler);
                configurationBuilder.setPropertyBuilder(configurationBuilder.runtimeBuilder());
                break;
            }
            case "StrolchConfiguration/env/Component": {
                if (!this.isRequiredEnv(this.currentEnvironment)) break;
                ConfigurationBuilder configurationBuilder = this.getEnvBuilder(this.currentEnvironment);
                configurationBuilder.nextComponentBuilder();
                ComponentHandler componentHandler = new ComponentHandler(configurationBuilder, locator);
                this.delegateHandlers.push(componentHandler);
                break;
            }
            case "StrolchConfiguration/env/Component/Properties": {
                if (!this.isRequiredEnv(this.currentEnvironment)) break;
                ConfigurationBuilder configurationBuilder = this.getEnvBuilder(this.currentEnvironment);
                PropertiesHandler componentPropertiesHandler = new PropertiesHandler(configurationBuilder, locator);
                this.delegateHandlers.push(componentPropertiesHandler);
                configurationBuilder.setPropertyBuilder(configurationBuilder.componentBuilder());
                break;
            }
            default: {
                if (this.delegateHandlers.isEmpty()) break;
                this.delegateHandlers.peek().startElement(uri, localName, qName, attributes);
            }
        }
    }

    private ConfigurationBuilder getEnvBuilder(String environment) {
        if (StringHelper.isEmpty((String)environment)) {
            throw new IllegalStateException("environment must be set!");
        }
        if (environment.equals("global")) {
            return this.globalEnvBuilder;
        }
        ConfigurationBuilder envBuilder = this.envBuilders.get(environment);
        if (envBuilder == null) {
            throw new IllegalStateException(MessageFormat.format("No ConfigurationBuilder exists for env {0}", environment));
        }
        return envBuilder;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Locator locator = this.locatorBuilder.build();
        switch (locator.toString()) {
            case "StrolchConfiguration/env": {
                break;
            }
            case "StrolchConfiguration/env/Runtime": {
                if (!this.isRequiredEnv(this.currentEnvironment)) break;
                this.assertExpectedLocator(locator, this.delegateHandlers.pop().getLocator());
                break;
            }
            case "StrolchConfiguration/env/Runtime/Properties": {
                if (!this.isRequiredEnv(this.currentEnvironment)) break;
                ConfigurationBuilder configurationBuilder = this.getEnvBuilder(this.currentEnvironment);
                this.assertExpectedLocator(locator, this.delegateHandlers.pop().getLocator());
                configurationBuilder.setPropertyBuilder(null);
                break;
            }
            case "StrolchConfiguration/env/Component": {
                if (!this.isRequiredEnv(this.currentEnvironment)) break;
                this.assertExpectedLocator(locator, this.delegateHandlers.pop().getLocator());
                break;
            }
            case "StrolchConfiguration/env/Component/Properties": {
                if (!this.isRequiredEnv(this.currentEnvironment)) break;
                ConfigurationBuilder configurationBuilder = this.getEnvBuilder(this.currentEnvironment);
                this.assertExpectedLocator(locator, this.delegateHandlers.pop().getLocator());
                configurationBuilder.setPropertyBuilder(null);
                break;
            }
            default: {
                if (this.delegateHandlers.isEmpty()) break;
                this.delegateHandlers.peek().endElement(uri, localName, qName);
            }
        }
        this.locatorBuilder.removeLast();
    }

    private void assertExpectedLocator(Locator expectedLocator, Locator actualLocator) {
        if (!expectedLocator.equals((Object)actualLocator)) {
            String msg = "Locator mismatch. Expected {0}. Current: {1}";
            msg = MessageFormat.format(msg, expectedLocator, actualLocator);
            throw new IllegalStateException(msg);
        }
    }

    public class ComponentBuilder
    extends PropertyBuilder {
        private String name;
        private String api;
        private String impl;
        private Set<String> dependencies;

        public ComponentBuilder() {
            this.dependencies = new HashSet<String>();
        }

        public ComponentConfiguration build(RuntimeConfiguration runtimeConfiguration) {
            ComponentConfiguration componentConfiguration = new ComponentConfiguration(runtimeConfiguration, this.name, this.getProperties(), this.api, this.impl, this.dependencies);
            return componentConfiguration;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getApi() {
            return this.api;
        }

        public void setApi(String api) {
            this.api = api;
        }

        public String getImpl() {
            return this.impl;
        }

        public void setImpl(String impl) {
            this.impl = impl;
        }

        public Set<String> getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(Set<String> dependencies) {
            this.dependencies = dependencies;
        }

        public void addDependency(String dependency) {
            this.dependencies.add(dependency);
        }
    }

    public class RuntimeBuilder
    extends PropertyBuilder {
        private String applicationName;
        private String environment;

        public String getApplicationName() {
            return this.applicationName;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public RuntimeConfiguration build(File configPathF, File dataPathF, File tempPathF) {
            RuntimeConfiguration configuration = new RuntimeConfiguration(this.applicationName, this.environment, this.getProperties(), configPathF, dataPathF, tempPathF);
            return configuration;
        }

        public RuntimeBuilder setApplicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public RuntimeBuilder setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }
    }

    public abstract class PropertyBuilder {
        private Map<String, String> properties = new HashMap<String, String>();

        public void addProperty(String key, String value) {
            if (StringHelper.isEmpty((String)key)) {
                throw new IllegalStateException("Key is empty!");
            }
            this.properties.put(key, value);
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }

    public class ConfigurationBuilder {
        private RuntimeBuilder runtimeBuilder;
        private ComponentBuilder componentBuilder;
        private PropertyBuilder propertyBuilder;
        private List<ComponentBuilder> componentBuilders = new ArrayList<ComponentBuilder>();

        public ConfigurationBuilder() {
            this.runtimeBuilder = new RuntimeBuilder();
        }

        public void setPropertyBuilder(PropertyBuilder propertyBuilder) {
            this.propertyBuilder = propertyBuilder;
        }

        public PropertyBuilder getPropertyBuilder() {
            return this.propertyBuilder;
        }

        public RuntimeBuilder runtimeBuilder() {
            return this.runtimeBuilder;
        }

        public ComponentBuilder nextComponentBuilder() {
            this.componentBuilder = new ComponentBuilder();
            this.componentBuilders.add(this.componentBuilder);
            return this.componentBuilder;
        }

        public ComponentBuilder componentBuilder() {
            return this.componentBuilder;
        }

        public StrolchConfiguration build(File configPathF, File dataPathF, File tempPathF) {
            RuntimeConfiguration runtimeConfiguration = this.runtimeBuilder.build(configPathF, dataPathF, tempPathF);
            HashMap<String, ComponentConfiguration> configurationByComponent = new HashMap<String, ComponentConfiguration>();
            for (ComponentBuilder componentBuilder : this.componentBuilders) {
                ComponentConfiguration componentConfiguration = componentBuilder.build(runtimeConfiguration);
                configurationByComponent.put(componentConfiguration.getName(), componentConfiguration);
            }
            StrolchConfiguration strolchConfiguration = new StrolchConfiguration(runtimeConfiguration, configurationByComponent);
            return strolchConfiguration;
        }

        public void merge(ConfigurationBuilder otherConfBuilder) {
            this.runtimeBuilder().setEnvironment(otherConfBuilder.runtimeBuilder().getEnvironment());
            if (otherConfBuilder.runtimeBuilder != null) {
                RuntimeBuilder thisRuntime = this.runtimeBuilder;
                RuntimeBuilder other = otherConfBuilder.runtimeBuilder;
                if (StringHelper.isNotEmpty((String)other.getApplicationName())) {
                    thisRuntime.setApplicationName(other.getApplicationName());
                }
                if (!other.getProperties().isEmpty()) {
                    thisRuntime.getProperties().putAll(other.getProperties());
                }
            }
            if (!otherConfBuilder.componentBuilders.isEmpty()) {
                HashMap<String, ComponentBuilder> thisComponentBuilders = new HashMap<String, ComponentBuilder>();
                for (ComponentBuilder thisComponentBuilder : this.componentBuilders) {
                    thisComponentBuilders.put(thisComponentBuilder.getName(), thisComponentBuilder);
                }
                List<ComponentBuilder> otherComponents = otherConfBuilder.componentBuilders;
                for (ComponentBuilder otherComponentBuilder : otherComponents) {
                    ComponentBuilder thisComponentBuilder = (ComponentBuilder)thisComponentBuilders.get(otherComponentBuilder.getName());
                    if (thisComponentBuilder == null) {
                        this.componentBuilders.add(otherComponentBuilder);
                        continue;
                    }
                    if (StringHelper.isNotEmpty((String)otherComponentBuilder.getImpl())) {
                        thisComponentBuilder.setImpl(otherComponentBuilder.getImpl());
                        thisComponentBuilder.setDependencies(otherComponentBuilder.getDependencies());
                    }
                    thisComponentBuilder.getProperties().putAll(otherComponentBuilder.getProperties());
                }
            }
        }
    }

    public class PropertiesHandler
    extends ElementHandler {
        private String propertyName;

        public PropertiesHandler(ConfigurationBuilder configurationBuilder, Locator locator) {
            super(configurationBuilder, locator);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.propertyName != null) {
                String msg = "Opening another tag {0} although {1} is still open!";
                msg = MessageFormat.format(msg, this.propertyName, qName);
                throw new IllegalStateException(msg);
            }
            this.propertyName = qName;
            this.valueBuffer = new StringBuilder();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.propertyName == null || !this.propertyName.equals(qName)) {
                String msg = "Previous tag {0} was not closed before new tag {1}!";
                msg = MessageFormat.format(msg, this.propertyName, qName);
                throw new IllegalStateException(msg);
            }
            String propertyValue = this.valueBuffer.toString().trim();
            this.configurationBuilder.getPropertyBuilder().addProperty(this.propertyName, propertyValue);
            this.propertyName = null;
            this.valueBuffer = null;
        }
    }

    public class ComponentHandler
    extends ElementHandler {
        public ComponentHandler(ConfigurationBuilder configurationBuilder, Locator locator) {
            super(configurationBuilder, locator);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName) {
                case "name": {
                    this.valueBuffer = new StringBuilder();
                    break;
                }
                case "api": {
                    this.valueBuffer = new StringBuilder();
                    break;
                }
                case "impl": {
                    this.valueBuffer = new StringBuilder();
                    break;
                }
                case "depends": {
                    this.valueBuffer = new StringBuilder();
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (qName) {
                case "name": {
                    String name = this.valueBuffer.toString();
                    this.configurationBuilder.componentBuilder().setName(name);
                    this.valueBuffer = null;
                    break;
                }
                case "api": {
                    String api = this.valueBuffer.toString();
                    this.configurationBuilder.componentBuilder().setApi(api);
                    this.valueBuffer = null;
                    break;
                }
                case "impl": {
                    String impl = this.valueBuffer.toString();
                    this.configurationBuilder.componentBuilder().setImpl(impl);
                    break;
                }
                case "depends": {
                    String depends = this.valueBuffer.toString();
                    this.configurationBuilder.componentBuilder().addDependency(depends);
                    break;
                }
            }
        }
    }

    public class RuntimeHandler
    extends ElementHandler {
        public RuntimeHandler(ConfigurationBuilder configurationBuilder, Locator locator) {
            super(configurationBuilder, locator);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName) {
                case "applicationName": {
                    this.valueBuffer = new StringBuilder();
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (qName) {
                case "applicationName": {
                    String applicationName = this.valueBuffer.toString();
                    this.configurationBuilder.runtimeBuilder().setApplicationName(applicationName);
                    this.valueBuffer = null;
                    break;
                }
            }
        }
    }

    public class ElementHandler
    extends DefaultHandler {
        protected final ConfigurationBuilder configurationBuilder;
        protected final Locator locator;
        protected StringBuilder valueBuffer;

        public ElementHandler(ConfigurationBuilder configurationBuilder, Locator locator) {
            DBC.PRE.assertNotNull("configurationBuilder must be set!", (Object)configurationBuilder);
            DBC.PRE.assertNotNull("locator must be set!", (Object)locator);
            this.configurationBuilder = configurationBuilder;
            this.locator = locator;
        }

        public Locator getLocator() {
            return this.locator;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.valueBuffer != null) {
                this.valueBuffer.append(ch, start, length);
            }
        }
    }
}

