/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.configuration;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.StrolchRealm;
import li.strolch.persistence.api.StrolchPersistenceException;
import li.strolch.runtime.StrolchConstants;
import li.strolch.runtime.configuration.ComponentConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbConnectionBuilder {
    private static final String PROP_DB_POOL_PREFIX = "db.pool";
    protected static final Logger logger = LoggerFactory.getLogger(DbConnectionBuilder.class);
    private ComponentContainer container;
    private ComponentConfiguration configuration;

    public DbConnectionBuilder(ComponentContainer container, ComponentConfiguration persistenceHandlerConfiguration) {
        this.container = container;
        this.configuration = persistenceHandlerConfiguration;
    }

    public Map<String, DataSource> build() {
        HashMap<String, DataSource> dsMap = new HashMap<String, DataSource>();
        Set<String> realmNames = this.container.getRealmNames();
        for (String realmName : realmNames) {
            StrolchRealm realm = this.container.getRealm(realmName);
            if (realm.getMode().isTransient()) continue;
            String dbIgnoreRealmKey = StrolchConstants.makeRealmKey(realmName, "db.ignore.realm");
            String dbUrlKey = StrolchConstants.makeRealmKey(realmName, "db.url");
            String dbUsernameKey = StrolchConstants.makeRealmKey(realmName, "db.username");
            String dbPasswordKey = StrolchConstants.makeRealmKey(realmName, "db.password");
            boolean dbIgnoreRealm = this.configuration.getBoolean(dbIgnoreRealmKey, Boolean.FALSE);
            if (dbIgnoreRealm) {
                logger.info("Ignoring any DB configuration for Realm " + realmName);
                continue;
            }
            String dbUrl = this.configuration.getString(dbUrlKey, null);
            String username = this.configuration.getString(dbUsernameKey, null);
            String password = this.configuration.getString(dbPasswordKey, null);
            Set<String> propertyKeys = this.configuration.getPropertyKeys();
            Properties props = new Properties();
            for (String key : propertyKeys) {
                String foundRealm;
                if (!key.startsWith(PROP_DB_POOL_PREFIX)) continue;
                String[] segments = key.split("\\.");
                if (segments.length == 4) {
                    foundRealm = segments[3];
                } else if (segments.length == 3) {
                    foundRealm = "defaultRealm";
                } else {
                    throw new IllegalArgumentException("Can't detect realm of this property: " + key);
                }
                if (!foundRealm.equals(realmName)) continue;
                String poolKey = segments[2];
                String value = this.configuration.getString(key, null);
                props.setProperty(poolKey, value);
            }
            DataSource ds = this.build(realmName, dbUrl, username, password, props);
            dsMap.put(realmName, ds);
        }
        return dsMap;
    }

    protected abstract DataSource build(String var1, String var2, String var3, String var4, Properties var5);

    protected void validateConnection(DataSource ds) {
        try (Connection con = ds.getConnection();){
            con.commit();
        }
        catch (SQLException e) {
            throw new StrolchPersistenceException("Failed to validate connection to " + ds, e);
        }
    }
}

