/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.configuration;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import li.strolch.runtime.configuration.AbstractionConfiguration;
import li.strolch.runtime.configuration.StrolchConfigurationException;

public class RuntimeConfiguration
extends AbstractionConfiguration {
    public static final String PROP_LOCALE = "locale";
    public static final String RUNTIME = "Runtime";
    private final String applicationName;
    private final String environment;
    private final File configPath;
    private final File dataPath;
    private final File tempPath;
    private Locale locale;

    public RuntimeConfiguration(String applicationName, String environment, Map<String, String> configurationValues, File configPathF, File dataPathF, File tempPathF) {
        super(RUNTIME, configurationValues);
        if (!configPathF.isDirectory() || !configPathF.canRead()) {
            String msg = "Config path is not readable at {0}";
            msg = MessageFormat.format(msg, configPathF);
            throw new StrolchConfigurationException(msg);
        }
        if (!(dataPathF.isDirectory() && dataPathF.canRead() && dataPathF.canWrite())) {
            String msg = "Data path is not a directory or readable or writeable at {0}";
            msg = MessageFormat.format(msg, dataPathF);
            throw new StrolchConfigurationException(msg);
        }
        if (!(tempPathF.isDirectory() && tempPathF.canRead() && tempPathF.canWrite())) {
            String msg = "Temp path is not a directory or readable or writeable at {0}";
            msg = MessageFormat.format(msg, tempPathF);
            throw new StrolchConfigurationException(msg);
        }
        this.applicationName = applicationName;
        this.environment = environment;
        this.configPath = configPathF;
        this.dataPath = dataPathF;
        this.tempPath = tempPathF;
        this.locale = new Locale(this.getString(PROP_LOCALE, Locale.getDefault().toString()));
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public File getTempPath() {
        return this.tempPath;
    }

    public File getConfigPath() {
        return this.configPath;
    }

    public File getDataPath() {
        return this.dataPath;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public File getConfigFile(String context, String fileName, boolean checkExists) {
        File configFile = new File(this.getDataPath(), fileName);
        if (!(!checkExists || configFile.isFile() && configFile.canRead())) {
            String msg = "[{0}] requires config file which does not exist with name: {1}";
            msg = MessageFormat.format(msg, this.getName(), context, fileName);
            throw new StrolchConfigurationException(msg);
        }
        return configFile;
    }

    public File getDataFile(String context, String fileName, boolean checkExists) {
        File dataFile = new File(this.getDataPath(), fileName);
        if (!(!checkExists || dataFile.isFile() && dataFile.canRead())) {
            String msg = "[{0}] requires data file which does not exist with name: {1}";
            msg = MessageFormat.format(msg, this.getName(), context, fileName);
            throw new StrolchConfigurationException(msg);
        }
        return dataFile;
    }

    public File getDataDir(String context, String dirName, boolean checkExists) {
        File dataDir = new File(this.getDataPath(), dirName);
        if (!(!checkExists || dataDir.isDirectory() && dataDir.canRead())) {
            String msg = "[{0}] requires data directory which does not exist with name: {1}";
            msg = MessageFormat.format(msg, this.getName(), context, dirName);
            throw new StrolchConfigurationException(msg);
        }
        return dataDir;
    }
}

