/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import li.strolch.runtime.configuration.StrolchConfigurationException;
import li.strolch.utils.dbc.DBC;
import li.strolch.utils.helper.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrolchEnvironment {
    public static final String ENV_PROPERTIES_FILE = "ENV.properties";
    private static final Logger logger = LoggerFactory.getLogger(StrolchEnvironment.class);

    public static String getEnvironmentFromSystemProperties() {
        String environment = System.getProperties().getProperty("ENV_STROLCH");
        if (StringHelper.isEmpty((String)environment)) {
            String msg = "The system property {0} is missing!";
            throw new StrolchConfigurationException(MessageFormat.format(msg, "ENV_STROLCH"));
        }
        return environment;
    }

    public static String getEnvironmentFromEnvProperties(File rootPath) {
        File envF = new File(rootPath, ENV_PROPERTIES_FILE);
        DBC.PRE.assertExists(MessageFormat.format("{0} does not exist in {1}", ENV_PROPERTIES_FILE, rootPath.getAbsolutePath()), envF);
        Properties envP = new Properties();
        try (FileInputStream fin = new FileInputStream(envF);){
            envP.load(fin);
        }
        catch (Exception e) {
            throw new StrolchConfigurationException(MessageFormat.format("Failed to load {0} in {1}", ENV_PROPERTIES_FILE, rootPath), e);
        }
        String environment = envP.getProperty("ENV_STROLCH");
        if (StringHelper.isEmpty((String)environment)) {
            String msg = "The property {0} does not exist in {1}";
            msg = MessageFormat.format(msg, "ENV_STROLCH", envF.getAbsolutePath());
            throw new StrolchConfigurationException(msg);
        }
        return environment;
    }

    public static String getEnvironmentFromResourceEnv(Class<?> clazz) {
        InputStream stream = clazz.getResourceAsStream("/ENV.properties");
        DBC.PRE.assertNotNull(MessageFormat.format("{0} does not exist as root resource for class {1}", ENV_PROPERTIES_FILE, clazz), (Object)stream);
        Properties envP = new Properties();
        try {
            envP.load(stream);
        }
        catch (Exception e) {
            throw new StrolchConfigurationException(MessageFormat.format("Failed to load {0}", ENV_PROPERTIES_FILE), e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.error("Failed to close InputStream!", (Throwable)e);
            }
        }
        String environment = envP.getProperty("ENV_STROLCH");
        if (StringHelper.isEmpty((String)environment)) {
            String msg = "The property {0} does not exist in {1}";
            msg = MessageFormat.format(msg, "ENV_STROLCH", ENV_PROPERTIES_FILE);
            throw new StrolchConfigurationException(msg);
        }
        return environment;
    }
}

