/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.main;

import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import li.strolch.agent.api.StrolchAgent;
import li.strolch.agent.api.StrolchBootstrapper;
import li.strolch.agent.api.StrolchVersion;
import li.strolch.utils.dbc.DBC;
import li.strolch.utils.helper.StringHelper;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainStarter {
    private static final Logger logger = LoggerFactory.getLogger(MainStarter.class);
    private static final String OPT_ROOT_PATH = "root-path";
    private static final String OPT_ENV = "env";
    private Options options;
    private String env;
    private File pathF;
    private StrolchAgent agent;
    private StrolchVersion appVersion;

    public MainStarter(StrolchVersion appVersion) {
        DBC.PRE.assertNotNull("appVersion must be set!", (Object)appVersion);
        this.appVersion = appVersion;
        this.configureOptions();
    }

    public MainStarter(Class<?> appClass) {
        StrolchVersion appVersion;
        DBC.PRE.assertNotNull("appClass must be set!", appClass);
        Properties env = new Properties();
        try (InputStream in = appClass.getResourceAsStream("/appVersion.properties");){
            env.load(in);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find resource /appVersion.properties on ClassLoader of class " + appClass);
        }
        this.appVersion = appVersion = new StrolchVersion(env);
        this.configureOptions();
    }

    private void configureOptions() {
        Options op = new Options();
        Option rootPathOption = new Option("p", OPT_ROOT_PATH, true, "root path to strolch runtime");
        rootPathOption.setOptionalArg(false);
        rootPathOption.setRequired(true);
        op.addOption(rootPathOption);
        Option envOption = new Option("e", OPT_ENV, true, "environment to load from configuration file");
        envOption.setOptionalArg(false);
        envOption.setRequired(true);
        op.addOption(envOption);
        this.options = op;
    }

    public int start(String[] args) {
        int ret = this.parseArgs(args);
        if (ret != 0) {
            return ret;
        }
        this.setup();
        this.initialize();
        this.start();
        return this.keepAlive();
    }

    public int parseArgs(String[] args) {
        CommandLine line;
        GnuParser parser = new GnuParser();
        try {
            line = parser.parse(this.options, args);
        }
        catch (ParseException exp) {
            logger.error("Parsing failed.  Reason: " + exp.getMessage());
            this.printUsage();
            return 1;
        }
        this.env = line.getOptionValue(OPT_ENV);
        if (StringHelper.isEmpty((String)this.env)) {
            logger.error("env argument is missing!");
            this.printUsage();
            return 1;
        }
        String pathS = line.getOptionValue(OPT_ROOT_PATH);
        this.pathF = new File(pathS);
        if (!this.pathF.exists()) {
            logger.error(MessageFormat.format("Path parameter does not exist at: {0}", pathS));
            this.printUsage();
            return 1;
        }
        return 0;
    }

    public void setup() {
        this.agent = new StrolchBootstrapper(this.appVersion).setupByRoot(this.env, this.pathF);
    }

    public void initialize() {
        this.getAgent().initialize();
    }

    public void start() {
        this.getAgent().start();
    }

    public void stop() {
        this.getAgent().stop();
    }

    public void destroy() {
        this.getAgent().destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int keepAlive() {
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<MainStarter> clazz = MainStarter.class;
                synchronized (MainStarter.class) {
                    System.out.println("VM Shutting down. Stopping Strolch...");
                    System.out.println("");
                    System.out.println("Strolch application " + MainStarter.this.getAgent().getApplicationName() + " shutting down...");
                    MainStarter.this.getAgent().stop();
                    MainStarter.this.getAgent().destroy();
                    System.out.println("Strolch application " + MainStarter.this.getAgent().getApplicationName() + " shut down. Exiting VM.");
                    atomicBoolean.set(true);
                    MainStarter.class.notify();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        logger.info("");
        logger.info("Strolch application " + this.getAgent().getApplicationName() + " started ");
        while (!atomicBoolean.get()) {
            Class<MainStarter> clazz = MainStarter.class;
            // MONITORENTER : li.strolch.runtime.main.MainStarter.class
            try {
                MainStarter.class.wait();
            }
            catch (InterruptedException e) {
                logger.error("Interrupted.");
                // MONITOREXIT : clazz
                return 1;
            }
        }
        return 0;
    }

    private void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -classpath lib/ -jar <jar.containing.main.class>.jar <options>", this.options);
    }

    public StrolchAgent getAgent() {
        return this.agent;
    }
}

