/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.privilege;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.StrolchComponent;
import li.strolch.agent.api.StrolchRealm;
import li.strolch.model.audit.AccessType;
import li.strolch.model.audit.Audit;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.privilege.base.PrivilegeException;
import li.strolch.privilege.handler.SystemAction;
import li.strolch.privilege.handler.SystemActionWithResult;
import li.strolch.privilege.handler.XmlPersistenceHandler;
import li.strolch.privilege.helper.PrivilegeInitializationHelper;
import li.strolch.privilege.model.Certificate;
import li.strolch.privilege.model.PrivilegeContext;
import li.strolch.privilege.model.internal.PrivilegeContainerModel;
import li.strolch.privilege.xml.PrivilegeConfigSaxReader;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.runtime.configuration.RuntimeConfiguration;
import li.strolch.runtime.privilege.PrivilegeHandler;
import li.strolch.runtime.privilege.PrivilegedRunnable;
import li.strolch.runtime.privilege.PrivilegedRunnableWithResult;
import li.strolch.runtime.privilege.StrolchSystemAction;
import li.strolch.runtime.privilege.StrolchSystemActionWithResult;
import li.strolch.utils.helper.XmlHelper;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultStrolchPrivilegeHandler
extends StrolchComponent
implements PrivilegeHandler {
    public static final String PROP_PRIVILEGE_CONFIG_FILE = "privilegeConfigFile";
    public static final String PRIVILEGE_CONFIG_XML = "PrivilegeConfig.xml";
    private li.strolch.privilege.handler.PrivilegeHandler privilegeHandler;

    public DefaultStrolchPrivilegeHandler(ComponentContainer container, String componentName) {
        super(container, componentName);
    }

    @Override
    public void initialize(ComponentConfiguration configuration) throws Exception {
        li.strolch.privilege.handler.PrivilegeHandler privilegeHandler;
        super.initialize(configuration);
        RuntimeConfiguration runtimeConfiguration = configuration.getRuntimeConfiguration();
        File privilegeConfigFile = configuration.getConfigFile(PROP_PRIVILEGE_CONFIG_FILE, PRIVILEGE_CONFIG_XML, runtimeConfiguration);
        this.privilegeHandler = privilegeHandler = this.initializeFromXml(configuration, privilegeConfigFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private li.strolch.privilege.handler.PrivilegeHandler initializeFromXml(ComponentConfiguration configuration, File privilegeXmlFile) {
        if (!privilegeXmlFile.exists()) {
            String msg = "Privilege file does not exist at path {0}";
            msg = MessageFormat.format(msg, privilegeXmlFile.getAbsolutePath());
            throw new PrivilegeException(msg);
        }
        try (FileInputStream inputStream = new FileInputStream(privilegeXmlFile);){
            PrivilegeContainerModel containerModel = new PrivilegeContainerModel();
            PrivilegeConfigSaxReader xmlHandler = new PrivilegeConfigSaxReader(containerModel);
            XmlHelper.parseDocument((InputStream)inputStream, (DefaultHandler)xmlHandler);
            Map parameterMap = containerModel.getParameterMap();
            RuntimeConfiguration runtimeConfig = configuration.getRuntimeConfiguration();
            if (Boolean.valueOf((String)parameterMap.get("persistSessions")).booleanValue()) {
                File dataPath = runtimeConfig.getTempPath();
                String sessionsPath = new File(dataPath, "sessions.dat").getAbsolutePath();
                parameterMap.put("persistSessionsPath", sessionsPath);
            }
            if (containerModel.getPersistenceHandlerClassName().equals(XmlPersistenceHandler.class.getName())) {
                Map xmlParams = containerModel.getPersistenceHandlerParameterMap();
                File configPath = runtimeConfig.getConfigPath();
                xmlParams.put("basePath", configPath.getPath());
            }
            li.strolch.privilege.handler.PrivilegeHandler privilegeHandler = PrivilegeInitializationHelper.initializeFromXml((PrivilegeContainerModel)containerModel);
            return privilegeHandler;
        }
        catch (Exception e) {
            String msg = "Failed to load Privilege configuration from {0}";
            msg = MessageFormat.format(msg, privilegeXmlFile.getAbsolutePath());
            throw new PrivilegeException(msg, (Throwable)e);
        }
    }

    @Override
    public Certificate authenticate(String username, byte[] password) {
        this.assertContainerStarted();
        Certificate certificate = this.privilegeHandler.authenticate(username, password);
        StrolchRealm realm = this.getContainer().getRealm(certificate);
        try (StrolchTransaction tx = realm.openTx(certificate, "Login");){
            tx.setSuppressDoNothingLogging(true);
            tx.setSuppressAudits(true);
            Audit audit = tx.auditFrom(AccessType.CREATE, "Privilege", "Certificate", username);
            tx.getAuditTrail().add(tx, audit);
        }
        return certificate;
    }

    @Override
    public void isCertificateValid(Certificate certificate) throws PrivilegeException {
        this.assertStarted();
        this.privilegeHandler.isCertificateValid(certificate);
    }

    @Override
    public boolean invalidateSession(Certificate certificate) {
        boolean invalidateSession = this.privilegeHandler.invalidateSession(certificate);
        StrolchRealm realm = this.getContainer().getRealm(certificate);
        try (StrolchTransaction tx = realm.openTx(certificate, "Logout");){
            tx.setSuppressDoNothingLogging(true);
            tx.setSuppressAudits(true);
            Audit audit = tx.auditFrom(AccessType.DELETE, "Privilege", "Certificate", certificate.getUsername());
            tx.getAuditTrail().add(tx, audit);
        }
        return invalidateSession;
    }

    @Override
    public boolean sessionTimeout(Certificate certificate) {
        this.assertStarted();
        boolean invalidateSession = this.privilegeHandler.invalidateSession(certificate);
        StrolchRealm realm = this.getContainer().getRealm(certificate);
        try (StrolchTransaction tx = realm.openTx(certificate, "SessionTimeout");){
            tx.setSuppressDoNothingLogging(true);
            tx.setSuppressAudits(true);
            Audit audit = tx.auditFrom(AccessType.DELETE, "Privilege", "Certificate", certificate.getUsername());
            tx.getAuditTrail().add(tx, audit);
        }
        return invalidateSession;
    }

    @Override
    public void runAs(String username, SystemAction action) throws PrivilegeException {
        this.privilegeHandler.runAs(username, action);
    }

    @Override
    public <T> T runWithResult(String username, SystemActionWithResult<T> action) throws PrivilegeException {
        return (T)this.privilegeHandler.runWithResult(username, action);
    }

    @Override
    public void runAs(String username, PrivilegedRunnable runnable) throws PrivilegeException {
        this.privilegeHandler.runAs(username, (SystemAction)new StrolchSystemAction(runnable));
    }

    @Override
    public <T> T runWithResult(String username, PrivilegedRunnableWithResult<T> runnable) throws PrivilegeException {
        return (T)this.privilegeHandler.runWithResult(username, new StrolchSystemActionWithResult<T>(runnable));
    }

    @Override
    public void runAsAgent(SystemAction action) throws PrivilegeException {
        this.privilegeHandler.runAs("agent", action);
    }

    @Override
    public <T> T runAsAgentWithResult(SystemActionWithResult<T> action) throws PrivilegeException {
        return (T)this.privilegeHandler.runWithResult("agent", action);
    }

    @Override
    public void runAsAgent(PrivilegedRunnable runnable) throws PrivilegeException {
        this.privilegeHandler.runAs("agent", (SystemAction)new StrolchSystemAction(runnable));
    }

    @Override
    public <T> T runAsAgentWithResult(PrivilegedRunnableWithResult<T> runnable) throws PrivilegeException {
        return (T)this.privilegeHandler.runWithResult("agent", new StrolchSystemActionWithResult<T>(runnable));
    }

    @Override
    public PrivilegeContext getPrivilegeContext(Certificate certificate) throws PrivilegeException {
        return this.privilegeHandler.getPrivilegeContext(certificate);
    }

    @Override
    public li.strolch.privilege.handler.PrivilegeHandler getPrivilegeHandler() {
        return this.privilegeHandler;
    }
}

