/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.query.enums;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.StrolchComponent;
import li.strolch.exception.StrolchException;
import li.strolch.model.Locator;
import li.strolch.model.ParameterBag;
import li.strolch.model.Resource;
import li.strolch.model.parameter.StringParameter;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.privilege.model.Certificate;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.runtime.query.enums.EnumHandler;
import li.strolch.runtime.query.enums.EnumValue;
import li.strolch.runtime.query.enums.StrolchEnum;
import li.strolch.utils.dbc.DBC;

public class DefaultEnumHandler
extends StrolchComponent
implements EnumHandler {
    private static final String PROP_REALM = "realm";
    private String realm;
    private Map<String, Locator> enumLocators;

    public DefaultEnumHandler(ComponentContainer container, String componentName) {
        super(container, componentName);
    }

    @Override
    public void initialize(ComponentConfiguration configuration) throws Exception {
        this.enumLocators = new HashMap<String, Locator>();
        this.realm = configuration.getString(PROP_REALM, "defaultRealm");
        Set<String> enumNames = configuration.getPropertyKeys();
        for (String enumName : enumNames) {
            if (enumName.equals(PROP_REALM)) continue;
            String enumLocatorS = configuration.getString(enumName, null);
            Locator enumLocator = Locator.valueOf((String)enumLocatorS);
            logger.info(MessageFormat.format("Registered enum {0} at {1}", enumName, enumLocator));
            this.enumLocators.put(enumName, enumLocator);
        }
        super.initialize(configuration);
    }

    @Override
    public StrolchEnum getEnum(Certificate certificate, String name, Locale locale) {
        DBC.PRE.assertNotEmpty("Enum name must be given!", name);
        DBC.PRE.assertNotNull("Locale must be given!", (Object)locale);
        Locator enumLocator = this.enumLocators.get(name);
        if (enumLocator == null) {
            throw new StrolchException(MessageFormat.format("No enumeration is configured for the name {0}", name));
        }
        try (StrolchTransaction tx = this.getContainer().getRealm(this.realm).openTx(certificate, EnumHandler.class);){
            Resource enumeration = (Resource)tx.findElement(enumLocator);
            ParameterBag enumValuesByLanguage = this.findParameterBagByLanguage(enumeration, locale);
            Set parameterKeySet = enumValuesByLanguage.getParameterKeySet();
            HashMap<String, EnumValue> values = new HashMap<String, EnumValue>(parameterKeySet.size());
            for (String paramKey : parameterKeySet) {
                StringParameter enumParam = (StringParameter)enumValuesByLanguage.getParameter(paramKey);
                values.put(paramKey, new EnumValue(paramKey, enumParam.getValue()));
            }
            StrolchEnum strolchEnum = new StrolchEnum(name, locale, values);
            return strolchEnum;
        }
    }

    private ParameterBag findParameterBagByLanguage(Resource enumeration, Locale locale) {
        String localeS = locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant();
        if (enumeration.hasParameterBag(localeS)) {
            return enumeration.getParameterBag(localeS);
        }
        localeS = locale.getLanguage() + "_" + locale.getCountry();
        if (enumeration.hasParameterBag(localeS)) {
            return enumeration.getParameterBag(localeS);
        }
        localeS = locale.getLanguage();
        if (enumeration.hasParameterBag(localeS)) {
            return enumeration.getParameterBag(localeS);
        }
        String msg = "No enumeration exists for language {0} on enumeration {1}";
        msg = MessageFormat.format(msg, locale, enumeration.getLocator());
        throw new StrolchException(msg);
    }
}

