/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.query.enums;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import li.strolch.runtime.query.enums.EnumValue;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="StrolchEnum")
@XmlType(propOrder={"name", "locale", "values"})
public class StrolchEnum {
    @XmlAttribute(name="name")
    private String name;
    @XmlAttribute(name="locale")
    private String locale;
    private Map<String, EnumValue> values;
    @XmlTransient
    private Locale localeL;

    public StrolchEnum() {
    }

    public StrolchEnum(String name, Locale locale, Map<String, EnumValue> values) {
        this.name = name;
        this.locale = locale.toString();
        this.localeL = locale;
        this.values = values;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.localeL = new Locale(locale);
        this.locale = locale;
    }

    public Locale getLocaleL() {
        return this.localeL;
    }

    public void setLocaleL(Locale localeL) {
        this.locale = localeL.getLanguage() + "_" + localeL.getCountry();
        this.localeL = localeL;
    }

    @XmlElement(name="values")
    public Collection<EnumValue> getValues() {
        if (this.values == null) {
            return null;
        }
        return this.values.values();
    }

    public void setValues(Collection<EnumValue> values) {
        this.values = new HashMap<String, EnumValue>(values.size());
        for (EnumValue enumValue : values) {
            this.values.put(enumValue.getId(), enumValue);
        }
    }

    public List<String> getEnumValueIds() {
        return new ArrayList<String>(this.values.keySet());
    }

    public List<String> getEnumValues() {
        ArrayList<String> values = new ArrayList<String>(this.values.size());
        for (EnumValue enumValue : this.values.values()) {
            values.add(enumValue.getValue());
        }
        return values;
    }

    public String getValue(String id) {
        EnumValue enumValue = this.values.get(id);
        if (enumValue == null) {
            return null;
        }
        return enumValue.getValue();
    }
}

