/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.query.inmemory;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import li.strolch.model.audit.AccessType;
import li.strolch.model.audit.ActionSelection;
import li.strolch.model.audit.Audit;
import li.strolch.model.audit.ElementSelection;
import li.strolch.model.audit.IdentitySelection;
import li.strolch.model.query.StringSelection;

public abstract class AuditSelector {
    public abstract boolean select(Audit var1);

    public static AuditSelector selectorFor(ElementSelection selection) {
        return new ElementSelector(selection);
    }

    public static AuditSelector selectorFor(IdentitySelection selection) {
        return new IdentitySelector(selection);
    }

    public static AuditSelector selectorFor(ActionSelection selection) {
        return new ActionSelector(selection);
    }

    public static class ActionSelector
    extends AuditSelector {
        private Set<AccessType> accessTypes;
        private StringSelection actionSelection;

        public ActionSelector(ActionSelection selection) {
            if (selection.getAccessTypes() != null && selection.getAccessTypes().length != 0) {
                this.accessTypes = new HashSet<AccessType>(Arrays.asList(selection.getAccessTypes()));
            }
            this.actionSelection = selection.getActionSelection();
        }

        @Override
        public boolean select(Audit audit) {
            if (this.accessTypes != null && !this.accessTypes.contains(audit.getAccessType())) {
                return false;
            }
            return this.actionSelection == null || this.actionSelection.matches(audit.getAction());
        }
    }

    public static class IdentitySelector
    extends AuditSelector {
        private StringSelection firstnameSelection;
        private StringSelection lastnameSelection;
        private StringSelection usernameSelection;

        public IdentitySelector(IdentitySelection selection) {
            this.firstnameSelection = selection.getFirstnameSelection();
            this.lastnameSelection = selection.getLastnameSelection();
            this.usernameSelection = selection.getUsernameSelection();
        }

        @Override
        public boolean select(Audit audit) {
            if (this.firstnameSelection != null && !this.firstnameSelection.matches(audit.getFirstname())) {
                return false;
            }
            if (this.lastnameSelection != null && !this.lastnameSelection.matches(audit.getLastname())) {
                return false;
            }
            return this.usernameSelection == null || this.usernameSelection.matches(audit.getUsername());
        }
    }

    private static class ElementSelector
    extends AuditSelector {
        private StringSelection elementSubTypeSelection;
        private StringSelection elementAccessedSelection;

        public ElementSelector(ElementSelection selection) {
            this.elementSubTypeSelection = selection.getElementSubTypeSelection();
            this.elementAccessedSelection = selection.getElementAccessedSelection();
        }

        @Override
        public boolean select(Audit audit) {
            if (this.elementSubTypeSelection != null && !this.elementSubTypeSelection.matches(audit.getElementSubType())) {
                return false;
            }
            return this.elementAccessedSelection == null || this.elementAccessedSelection.matches(audit.getElementAccessed());
        }
    }
}

