/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.query.inmemory;

import java.util.List;
import li.strolch.model.StrolchElement;
import li.strolch.runtime.query.inmemory.Selector;
import li.strolch.utils.StringMatchMode;

public class IdSelector<T extends StrolchElement>
implements Selector<T> {
    private StringMatchMode matchMode;
    private List<String> ids;

    public IdSelector(List<String> ids, StringMatchMode matchMode) {
        this.ids = ids;
        this.matchMode = matchMode;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public StringMatchMode getMatchMode() {
        return this.matchMode;
    }

    public IdSelector<T> with(String id) {
        this.ids.add(id);
        return this;
    }

    @Override
    public boolean select(StrolchElement element) {
        if (this.ids.isEmpty()) {
            return true;
        }
        String elemId = element.getId();
        if (this.ids.size() == 1) {
            return this.matchMode.matches(elemId, this.ids.get(0));
        }
        for (String id : this.ids) {
            if (!this.matchMode.matches(elemId, id)) continue;
            return true;
        }
        return false;
    }
}

