/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.query.inmemory;

import java.util.List;
import li.strolch.model.activity.Activity;
import li.strolch.model.query.ActivityQuery;
import li.strolch.model.query.ActivityQueryVisitor;
import li.strolch.model.query.StrolchTypeNavigation;
import li.strolch.model.visitor.ActivityVisitor;
import li.strolch.runtime.query.inmemory.ActivityTypeNavigator;
import li.strolch.runtime.query.inmemory.InMemoryQuery;
import li.strolch.runtime.query.inmemory.InMemoryQueryVisitor;
import li.strolch.runtime.query.inmemory.Navigator;
import li.strolch.runtime.query.inmemory.QueryException;
import li.strolch.utils.dbc.DBC;

public class InMemoryActivityQueryVisitor
extends InMemoryQueryVisitor<Activity>
implements ActivityQueryVisitor {
    @Override
    protected InMemoryQueryVisitor<Activity> newInstance() {
        return new InMemoryActivityQueryVisitor();
    }

    public <U> InMemoryQuery<Activity, U> visit(ActivityQuery<U> activityQuery) {
        ActivityVisitor activityVisitor = activityQuery.getActivityVisitor();
        DBC.PRE.assertNotNull("ActivityVisitor may not be null!", (Object)activityVisitor);
        activityQuery.accept((ActivityQueryVisitor)this);
        Navigator navigator = this.getNavigator();
        if (navigator == null) {
            String msg = "Query is missing a navigation!";
            throw new QueryException(msg);
        }
        List selectors = this.getSelectors();
        if (selectors.isEmpty()) {
            return new InMemoryQuery(navigator, null, activityVisitor, this.getComparator());
        }
        DBC.PRE.assertTrue("Invalid query as it may only contain one selector!", selectors.size() == 1);
        return new InMemoryQuery(navigator, selectors.get(0), activityVisitor, this.getComparator());
    }

    public void visit(StrolchTypeNavigation navigation) {
        this.setNavigator(new ActivityTypeNavigator(navigation.getType()));
    }
}

