/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.query.inmemory;

import java.util.ArrayList;
import java.util.List;
import li.strolch.model.audit.Audit;
import li.strolch.model.audit.AuditVisitor;
import li.strolch.persistence.inmemory.InMemoryAuditDao;
import li.strolch.runtime.query.inmemory.AuditSelector;
import li.strolch.runtime.query.inmemory.AuditTypeNavigator;
import li.strolch.utils.dbc.DBC;

public class InMemoryAuditQuery<U> {
    private AuditTypeNavigator navigator;
    private List<AuditSelector> selectors;
    private AuditVisitor<U> auditVisitor;
    private long limit;

    public InMemoryAuditQuery(AuditTypeNavigator navigator, long limit, List<AuditSelector> selectors, AuditVisitor<U> auditVisitor) {
        DBC.PRE.assertNotNull("Navigator must be set!", (Object)navigator);
        DBC.PRE.assertNotNull("selectors must be set!", selectors);
        DBC.PRE.assertNotNull("auditVisitor must be set!", auditVisitor);
        this.navigator = navigator;
        this.limit = limit;
        this.selectors = selectors;
        this.auditVisitor = auditVisitor;
    }

    public List<U> doQuery(InMemoryAuditDao dao) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<Audit> elements = this.navigator.navigate(dao);
        elements.sort((a1, a2) -> a2.getDate().compareTo(a1.getDate()));
        for (Audit audit : elements) {
            if (!this.selectors.isEmpty()) {
                boolean nok = false;
                for (AuditSelector selector : this.selectors) {
                    if (selector.select(audit)) continue;
                    nok = true;
                    break;
                }
                if (nok) continue;
            }
            Object returnValue = this.auditVisitor.visitAudit(audit);
            DBC.INTERIM.assertNotNull("Visitor may not return null in query!", returnValue);
            result.add(returnValue);
            if (this.limit <= 0L || (long)result.size() < this.limit) continue;
            break;
        }
        return result;
    }
}

