/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.query.inmemory;

import java.util.ArrayList;
import java.util.List;
import li.strolch.model.audit.ActionSelection;
import li.strolch.model.audit.AuditQuery;
import li.strolch.model.audit.AuditQueryVisitor;
import li.strolch.model.audit.AuditVisitor;
import li.strolch.model.audit.ElementSelection;
import li.strolch.model.audit.IdentitySelection;
import li.strolch.runtime.query.inmemory.AuditSelector;
import li.strolch.runtime.query.inmemory.AuditTypeNavigator;
import li.strolch.runtime.query.inmemory.InMemoryAuditQuery;
import li.strolch.runtime.query.inmemory.QueryException;
import li.strolch.utils.collections.DateRange;
import li.strolch.utils.dbc.DBC;

public class InMemoryAuditQueryVisitor<U>
implements AuditQueryVisitor {
    private AuditTypeNavigator navigator;
    private List<AuditSelector> selectors;

    public InMemoryAuditQuery<U> toInMemory(AuditQuery<U> auditQuery) {
        AuditVisitor auditVisitor = auditQuery.getAuditVisitor();
        DBC.PRE.assertNotNull("auditVisitor", (Object)auditVisitor);
        this.selectors = new ArrayList<AuditSelector>();
        auditQuery.accept((AuditQueryVisitor)this);
        if (this.navigator == null) {
            String msg = "Query is missing a navigation!";
            throw new QueryException(msg);
        }
        long limit = auditQuery.getLimit();
        return new InMemoryAuditQuery(this.navigator, limit, this.selectors, auditVisitor);
    }

    public void visit(ElementSelection selection) {
        this.selectors.add(AuditSelector.selectorFor(selection));
    }

    public void visit(IdentitySelection selection) {
        this.selectors.add(AuditSelector.selectorFor(selection));
    }

    public void visit(ActionSelection selection) {
        this.selectors.add(AuditSelector.selectorFor(selection));
    }

    public void visit(AuditQuery<?> auditQuery) {
        String type = auditQuery.getElementTypeSelection();
        DateRange dateRange = auditQuery.getDateRange();
        this.navigator = new AuditTypeNavigator(type, dateRange);
    }
}

