/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.query.inmemory;

import java.util.List;
import li.strolch.model.Order;
import li.strolch.model.query.DateSelection;
import li.strolch.model.query.OrderQuery;
import li.strolch.model.query.OrderQueryVisitor;
import li.strolch.model.query.StateSelection;
import li.strolch.model.query.StrolchTypeNavigation;
import li.strolch.model.visitor.OrderVisitor;
import li.strolch.runtime.query.inmemory.DateSelector;
import li.strolch.runtime.query.inmemory.InMemoryQuery;
import li.strolch.runtime.query.inmemory.InMemoryQueryVisitor;
import li.strolch.runtime.query.inmemory.Navigator;
import li.strolch.runtime.query.inmemory.OrderTypeNavigator;
import li.strolch.runtime.query.inmemory.QueryException;
import li.strolch.runtime.query.inmemory.StateSelector;
import li.strolch.utils.dbc.DBC;

public class InMemoryOrderQueryVisitor
extends InMemoryQueryVisitor<Order>
implements OrderQueryVisitor {
    @Override
    protected InMemoryQueryVisitor<Order> newInstance() {
        return new InMemoryOrderQueryVisitor();
    }

    public <U> InMemoryQuery<Order, U> visit(OrderQuery<U> orderQuery) {
        OrderVisitor orderVisitor = orderQuery.getOrderVisitor();
        DBC.PRE.assertNotNull("OrderVisitor may not be null!", (Object)orderVisitor);
        orderQuery.accept((OrderQueryVisitor)this);
        Navigator navigator = this.getNavigator();
        if (navigator == null) {
            String msg = "Query is missing a navigation!";
            throw new QueryException(msg);
        }
        List selectors = this.getSelectors();
        if (selectors.isEmpty()) {
            return new InMemoryQuery(navigator, null, orderVisitor, this.getComparator());
        }
        DBC.PRE.assertTrue("Invalid query as it may only contain one selector!", selectors.size() == 1);
        return new InMemoryQuery(navigator, selectors.get(0), orderVisitor, this.getComparator());
    }

    public void visit(StrolchTypeNavigation navigation) {
        this.setNavigator(new OrderTypeNavigator(navigation.getType()));
    }

    public void visit(DateSelection selection) {
        this.addSelector(new DateSelector(selection.getDateRange()));
    }

    public void visit(StateSelection selection) {
        this.addSelector(new StateSelector(selection.getState()));
    }
}

