/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.query.inmemory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import li.strolch.model.StrolchElement;
import li.strolch.model.StrolchRootElement;
import li.strolch.model.visitor.StrolchElementVisitor;
import li.strolch.persistence.api.StrolchDao;
import li.strolch.runtime.query.inmemory.Navigator;
import li.strolch.runtime.query.inmemory.Selector;
import li.strolch.utils.dbc.DBC;

public class InMemoryQuery<T extends StrolchRootElement, U> {
    private Navigator<T> navigator;
    private Selector<T> selector;
    private StrolchElementVisitor<T, U> elementVisitor;
    private Comparator<T> comparator;

    public InMemoryQuery() {
    }

    public InMemoryQuery(Navigator<T> navigator, Selector<T> selector, StrolchElementVisitor<T, U> elementVisitor, Comparator<T> comparator) {
        this.navigator = navigator;
        this.selector = selector;
        this.elementVisitor = elementVisitor;
        this.comparator = comparator;
    }

    public void setNavigator(Navigator<T> navigator) {
        this.navigator = navigator;
    }

    public void setSelector(Selector<T> selector) {
        this.selector = selector;
    }

    public void setElementVisitor(StrolchElementVisitor<T, U> elementVisitor) {
        this.elementVisitor = elementVisitor;
    }

    public List<U> doQuery(StrolchDao<T> dao) {
        if (this.selector == null) {
            return Collections.emptyList();
        }
        List<T> elements = this.navigator.navigate(dao);
        if (this.comparator != null) {
            elements.sort(this.comparator);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (StrolchRootElement element : elements) {
            if (!this.selector.select(element)) continue;
            Object returnValue = this.elementVisitor.visit((StrolchElement)element);
            DBC.INTERIM.assertNotNull("Visitor may not return null in query!", returnValue);
            result.add(returnValue);
        }
        return result;
    }
}

