/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.query.inmemory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import li.strolch.model.StrolchRootElement;
import li.strolch.model.query.AndSelection;
import li.strolch.model.query.IdSelection;
import li.strolch.model.query.NameSelection;
import li.strolch.model.query.NotSelection;
import li.strolch.model.query.OrSelection;
import li.strolch.model.query.ParameterBagSelection;
import li.strolch.model.query.ParameterSelection;
import li.strolch.model.query.ParameterSelectionVisitor;
import li.strolch.model.query.Selection;
import li.strolch.model.query.StrolchRootElementSelectionVisitor;
import li.strolch.model.query.ordering.OrderById;
import li.strolch.model.query.ordering.OrderByName;
import li.strolch.model.query.ordering.OrderByParameter;
import li.strolch.model.query.ordering.StrolchQueryOrderingVisitor;
import li.strolch.runtime.query.inmemory.AndSelector;
import li.strolch.runtime.query.inmemory.AnySelector;
import li.strolch.runtime.query.inmemory.IdSelector;
import li.strolch.runtime.query.inmemory.InMemoryStrolchQueryOrderingVisitor;
import li.strolch.runtime.query.inmemory.NameSelector;
import li.strolch.runtime.query.inmemory.Navigator;
import li.strolch.runtime.query.inmemory.NotSelector;
import li.strolch.runtime.query.inmemory.OrSelector;
import li.strolch.runtime.query.inmemory.ParameterBagSelector;
import li.strolch.runtime.query.inmemory.ParameterSelector;
import li.strolch.runtime.query.inmemory.Selector;
import li.strolch.runtime.query.inmemory.StrolchTypeNavigator;
import li.strolch.utils.dbc.DBC;

public abstract class InMemoryQueryVisitor<T extends StrolchRootElement>
implements StrolchRootElementSelectionVisitor,
ParameterSelectionVisitor,
StrolchQueryOrderingVisitor {
    private Navigator<T> navigator;
    private Comparator<T> comparator;
    private List<Selector<T>> selectors = new ArrayList<Selector<T>>();
    private boolean any;

    public List<Selector<T>> getSelectors() {
        return Collections.unmodifiableList(this.selectors);
    }

    public Navigator<T> getNavigator() {
        return this.navigator;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    protected void setNavigator(StrolchTypeNavigator<T> navigator) {
        this.navigator = navigator;
    }

    protected abstract InMemoryQueryVisitor<T> newInstance();

    private void assertNotAny() {
        DBC.INTERIM.assertFalse("Not allowed to use further Selections with Any!", this.any);
    }

    protected void addSelector(Selector<T> selector) {
        this.assertNotAny();
        this.selectors.add(selector);
    }

    public void visitAny() {
        DBC.PRE.assertEmpty("Only one selection allowed when using Any!", this.selectors);
        this.addSelector(new AnySelector());
        this.any = true;
    }

    public void visitAnd(AndSelection andSelection) {
        this.assertNotAny();
        InMemoryQueryVisitor<T> query = this.newInstance();
        List selections = andSelection.getSelections();
        for (Selection selection : selections) {
            selection.accept(query);
        }
        AndSelector<T> andSelector = new AndSelector<T>(query.getSelectors());
        this.addSelector(andSelector);
    }

    public void visitOr(OrSelection orSelection) {
        this.assertNotAny();
        InMemoryQueryVisitor<T> query = this.newInstance();
        List selections = orSelection.getSelections();
        for (Selection selection : selections) {
            selection.accept(query);
        }
        OrSelector<T> orSelector = new OrSelector<T>(query.getSelectors());
        this.addSelector(orSelector);
    }

    public void visitNot(NotSelection notSelection) {
        this.assertNotAny();
        InMemoryQueryVisitor<T> query = this.newInstance();
        List selections = notSelection.getSelections();
        for (Selection selection : selections) {
            selection.accept(query);
        }
        List<Selector<T>> notSelectors = query.getSelectors();
        if (!notSelectors.isEmpty()) {
            NotSelector<T> notSelector = new NotSelector<T>(notSelectors.get(0));
            this.addSelector(notSelector);
        }
    }

    public void visit(IdSelection selection) {
        this.addSelector(new IdSelector(selection.getIds(), selection.getMatchMode()));
    }

    public void visit(NameSelection selection) {
        this.addSelector(new NameSelector(selection.getName(), selection.getMatchMode()));
    }

    public void visit(ParameterSelection.StringParameterSelection selection) {
        ParameterSelector.StringParameterSelector stringSelector = ParameterSelector.stringSelector(selection.getBagKey(), selection.getParamKey(), selection.getValue(), selection.getMatchMode());
        this.addSelector(stringSelector);
    }

    public void visit(ParameterSelection.IntegerParameterSelection selection) {
        this.addSelector(ParameterSelector.integerSelector(selection.getBagKey(), selection.getParamKey(), selection.getValue()));
    }

    public void visit(ParameterSelection.BooleanParameterSelection selection) {
        this.addSelector(ParameterSelector.booleanSelector(selection.getBagKey(), selection.getParamKey(), selection.getValue()));
    }

    public void visit(ParameterSelection.LongParameterSelection selection) {
        this.addSelector(ParameterSelector.longSelector(selection.getBagKey(), selection.getParamKey(), selection.getValue()));
    }

    public void visit(ParameterSelection.FloatParameterSelection selection) {
        this.addSelector(ParameterSelector.floatSelector(selection.getBagKey(), selection.getParamKey(), selection.getValue()));
    }

    public void visit(ParameterSelection.DateParameterSelection selection) {
        this.addSelector(ParameterSelector.dateSelector(selection.getBagKey(), selection.getParamKey(), selection.getValue()));
    }

    public void visit(ParameterSelection.DurationParameterSelection selection) {
        this.addSelector(ParameterSelector.durationSelector(selection.getBagKey(), selection.getParamKey(), selection.getValue()));
    }

    public void visit(ParameterSelection.DateRangeParameterSelection selection) {
        this.addSelector(ParameterSelector.dateRangeSelector(selection.getBagKey(), selection.getParamKey(), selection.getDateRange()));
    }

    public void visit(ParameterSelection.StringListParameterSelection selection) {
        this.addSelector(ParameterSelector.stringListSelector(selection.getBagKey(), selection.getParamKey(), selection.getValue()));
    }

    public void visit(ParameterSelection.IntegerListParameterSelection selection) {
        this.addSelector(ParameterSelector.integerListSelector(selection.getBagKey(), selection.getParamKey(), selection.getValue()));
    }

    public void visit(ParameterSelection.FloatListParameterSelection selection) {
        this.addSelector(ParameterSelector.floatListSelector(selection.getBagKey(), selection.getParamKey(), selection.getValue()));
    }

    public void visit(ParameterSelection.LongListParameterSelection selection) {
        this.addSelector(ParameterSelector.longListSelector(selection.getBagKey(), selection.getParamKey(), selection.getValue()));
    }

    public void visit(ParameterSelection.NullParameterSelection selection) {
        this.addSelector(ParameterSelector.nullSelector(selection.getBagKey(), selection.getParamKey()));
    }

    public void visit(ParameterBagSelection.NullParameterBagSelection selection) {
        this.addSelector(new ParameterBagSelector.NullParameterBagSelector(selection.getBagKey()));
    }

    public void visit(ParameterBagSelection selection) {
        this.addSelector(new ParameterBagSelector(selection.getBagKey()));
    }

    public void visit(ParameterSelection.AnyTypeParameterSelection selection) {
        this.addSelector(ParameterSelector.anyTypeSelection(selection.getBagKey(), selection.getParamKey(), selection.getValue(), selection.getMatchMode()));
    }

    public InMemoryQueryVisitor<T> visit(OrderById ordering) {
        this.comparator = new InMemoryStrolchQueryOrderingVisitor().visit(ordering).getComparator();
        return this;
    }

    public InMemoryQueryVisitor<T> visit(OrderByName ordering) {
        this.comparator = new InMemoryStrolchQueryOrderingVisitor().visit(ordering).getComparator();
        return this;
    }

    public InMemoryQueryVisitor<T> visit(OrderByParameter ordering) {
        this.comparator = new InMemoryStrolchQueryOrderingVisitor().visit(ordering).getComparator();
        return this;
    }
}

