/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.query.inmemory;

import java.util.List;
import li.strolch.model.Resource;
import li.strolch.model.query.ResourceQuery;
import li.strolch.model.query.ResourceQueryVisitor;
import li.strolch.model.query.StrolchTypeNavigation;
import li.strolch.model.visitor.ResourceVisitor;
import li.strolch.runtime.query.inmemory.InMemoryQuery;
import li.strolch.runtime.query.inmemory.InMemoryQueryVisitor;
import li.strolch.runtime.query.inmemory.Navigator;
import li.strolch.runtime.query.inmemory.QueryException;
import li.strolch.runtime.query.inmemory.ResourceTypeNavigator;
import li.strolch.utils.dbc.DBC;

public class InMemoryResourceQueryVisitor
extends InMemoryQueryVisitor<Resource>
implements ResourceQueryVisitor {
    @Override
    protected InMemoryQueryVisitor<Resource> newInstance() {
        return new InMemoryResourceQueryVisitor();
    }

    public <U> InMemoryQuery<Resource, U> visit(ResourceQuery<U> resourceQuery) {
        ResourceVisitor resourceVisitor = resourceQuery.getResourceVisitor();
        DBC.PRE.assertNotNull("ResourceVisitor may not be null!", (Object)resourceVisitor);
        resourceQuery.accept((ResourceQueryVisitor)this);
        Navigator navigator = this.getNavigator();
        if (navigator == null) {
            String msg = "Query is missing a navigation!";
            throw new QueryException(msg);
        }
        List selectors = this.getSelectors();
        if (selectors.isEmpty()) {
            return new InMemoryQuery(navigator, null, resourceVisitor, this.getComparator());
        }
        DBC.INTERIM.assertTrue("Invalid query as it may only contain one selector!", selectors.size() == 1);
        return new InMemoryQuery(navigator, selectors.get(0), resourceVisitor, this.getComparator());
    }

    public void visit(StrolchTypeNavigation navigation) {
        this.setNavigator(new ResourceTypeNavigator(navigation.getType()));
    }
}

