/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.runtime.query.inmemory;

import java.util.Comparator;
import li.strolch.model.StrolchRootElement;
import li.strolch.model.query.ordering.ByIdComparator;
import li.strolch.model.query.ordering.ByNameComparator;
import li.strolch.model.query.ordering.ByParamComparator;
import li.strolch.model.query.ordering.OrderById;
import li.strolch.model.query.ordering.OrderByName;
import li.strolch.model.query.ordering.OrderByParameter;
import li.strolch.model.query.ordering.StrolchQueryOrderingVisitor;

public class InMemoryStrolchQueryOrderingVisitor<T extends StrolchRootElement>
implements StrolchQueryOrderingVisitor {
    private Comparator<T> comparator;

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public InMemoryStrolchQueryOrderingVisitor<T> visit(OrderById ordering) {
        this.comparator = new ByIdComparator(ordering.isAscending());
        return this;
    }

    public InMemoryStrolchQueryOrderingVisitor<T> visit(OrderByName ordering) {
        this.comparator = new ByNameComparator(ordering.isAscending());
        return this;
    }

    public InMemoryStrolchQueryOrderingVisitor<T> visit(OrderByParameter ordering) {
        this.comparator = new ByParamComparator(ordering.getBagKey(), ordering.getParamKey(), ordering.isAscending());
        return this;
    }
}

