/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.service.api;

import java.text.MessageFormat;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.StrolchRealm;
import li.strolch.exception.StrolchException;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.privilege.base.PrivilegeException;
import li.strolch.privilege.handler.SystemAction;
import li.strolch.privilege.handler.SystemActionWithResult;
import li.strolch.privilege.model.Certificate;
import li.strolch.privilege.model.PrivilegeContext;
import li.strolch.runtime.configuration.RuntimeConfiguration;
import li.strolch.runtime.privilege.PrivilegeHandler;
import li.strolch.runtime.privilege.PrivilegedRunnable;
import li.strolch.runtime.privilege.PrivilegedRunnableWithResult;
import li.strolch.service.api.Service;
import li.strolch.service.api.ServiceArgument;
import li.strolch.service.api.ServiceResult;
import li.strolch.service.api.ServiceResultState;
import li.strolch.utils.dbc.DBC;
import li.strolch.utils.helper.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractService<T extends ServiceArgument, U extends ServiceResult>
implements Service<T, U> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractService.class);
    private static final long serialVersionUID = 1L;
    private ComponentContainer container;
    private PrivilegeContext privilegeContext;

    public final void setPrivilegeContext(PrivilegeContext privilegeContext) {
        DBC.PRE.assertNull("PrivilegeContext is already set!", (Object)this.privilegeContext);
        this.privilegeContext = privilegeContext;
    }

    public final PrivilegeContext getPrivilegeContext() {
        return this.privilegeContext;
    }

    protected final Certificate getCertificate() {
        return this.privilegeContext.getCertificate();
    }

    public final void setContainer(ComponentContainer container) {
        this.container = container;
    }

    protected final ComponentContainer getContainer() {
        return this.container;
    }

    public PrivilegeHandler getPrivilegeHandler() throws IllegalArgumentException {
        return this.container.getPrivilegeHandler();
    }

    protected final <V> V getComponent(Class<V> clazz) {
        return this.container.getComponent(clazz);
    }

    protected final RuntimeConfiguration getRuntimeConfiguration() {
        return this.container.getAgent().getStrolchConfiguration().getRuntimeConfiguration();
    }

    protected final StrolchRealm getRealm(String realm) throws StrolchException {
        return this.container.getRealm(realm);
    }

    protected StrolchTransaction openTx(String realm) throws StrolchException {
        return this.container.getRealm(realm).openTx(this.getCertificate(), this.getClass());
    }

    protected StrolchTransaction openArgOrUserTx(ServiceArgument arg) throws StrolchException {
        if (StringHelper.isEmpty((String)arg.realm)) {
            return this.openUserTx();
        }
        return this.openTx(arg.realm);
    }

    protected StrolchTransaction openArgOrUserTx(ServiceArgument arg, String action) throws StrolchException {
        if (StringHelper.isEmpty((String)arg.realm)) {
            return this.openUserTx();
        }
        return this.openTx(arg.realm, action);
    }

    protected StrolchTransaction openTx(String realm, String action) throws StrolchException {
        return this.container.getRealm(realm).openTx(this.getCertificate(), action);
    }

    protected StrolchTransaction openUserTx() throws StrolchException {
        return this.container.getRealm(this.getCertificate()).openTx(this.getCertificate(), this.getClass());
    }

    protected StrolchTransaction openUserTx(String action) throws StrolchException {
        return this.container.getRealm(this.getCertificate()).openTx(this.getCertificate(), action);
    }

    protected void runAs(String username, SystemAction action) throws PrivilegeException {
        this.container.getPrivilegeHandler().runAs(username, action);
    }

    protected <V> V runWithResult(String username, SystemActionWithResult<V> action) throws PrivilegeException {
        return this.container.getPrivilegeHandler().runWithResult(username, action);
    }

    protected void runAs(String username, PrivilegedRunnable runnable) throws PrivilegeException {
        this.container.getPrivilegeHandler().runAs(username, runnable);
    }

    protected <V> V runWithResult(String username, PrivilegedRunnableWithResult<V> runnable) throws PrivilegeException {
        return this.container.getPrivilegeHandler().runWithResult(username, runnable);
    }

    protected void runAsAgent(SystemAction action) throws PrivilegeException {
        this.container.getPrivilegeHandler().runAsAgent(action);
    }

    protected <V> V runAsAgentWithResult(SystemActionWithResult<V> action) throws PrivilegeException {
        return this.container.getPrivilegeHandler().runAsAgentWithResult(action);
    }

    protected void runAsAgent(PrivilegedRunnable runnable) throws PrivilegeException {
        this.container.getPrivilegeHandler().runAsAgent(runnable);
    }

    protected <V> V runAsAgentWithResult(PrivilegedRunnableWithResult<V> runnable) throws PrivilegeException {
        return this.container.getPrivilegeHandler().runAsAgentWithResult(runnable);
    }

    @Override
    public final U doService(T argument) {
        if (this.isArgumentRequired() && argument == null) {
            String msg = "Failed to perform service {0} because no argument was passed although it is required!";
            msg = MessageFormat.format(msg, this.getClass());
            logger.error(msg);
            U result = this.getResultInstance();
            ((ServiceResult)result).setState(ServiceResultState.FAILED);
            ((ServiceResult)result).setMessage(msg);
            return result;
        }
        try {
            U serviceResult = this.internalDoService(argument);
            if (serviceResult == null) {
                String msg = "Service {0} is not properly implemented as it returned a null result!";
                msg = MessageFormat.format(msg, this.getClass().getName());
                throw new StrolchException(msg);
            }
            return serviceResult;
        }
        catch (Exception e) {
            U result = this.getResultInstance();
            ((ServiceResult)result).setState(ServiceResultState.FAILED);
            ((ServiceResult)result).setMessage(e.getMessage());
            ((ServiceResult)result).setThrowable(e);
            return result;
        }
    }

    protected boolean isArgumentRequired() {
        return true;
    }

    protected abstract U getResultInstance();

    protected abstract U internalDoService(T var1) throws Exception;

    public String getPrivilegeName() {
        return Service.class.getName();
    }

    public Object getPrivilegeValue() {
        return this.getClass().getName();
    }
}

