/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.service.api;

import li.strolch.agent.api.ComponentContainer;
import li.strolch.model.PolicyContainer;
import li.strolch.model.policy.PolicyDef;
import li.strolch.model.policy.PolicyDefs;
import li.strolch.persistence.api.StrolchTransaction;
import li.strolch.policy.PolicyHandler;
import li.strolch.policy.StrolchPolicy;
import li.strolch.privilege.base.PrivilegeException;
import li.strolch.privilege.handler.SystemAction;
import li.strolch.privilege.handler.SystemActionWithResult;
import li.strolch.privilege.model.Restrictable;
import li.strolch.runtime.privilege.PrivilegedRunnable;
import li.strolch.runtime.privilege.PrivilegedRunnableWithResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Command
implements Restrictable {
    protected static final Logger logger = LoggerFactory.getLogger(Command.class);
    private final ComponentContainer container;
    private final StrolchTransaction tx;

    public Command(ComponentContainer container, StrolchTransaction tx) {
        this.container = container;
        this.tx = tx;
    }

    protected <V> V getComponent(Class<V> clazz) throws IllegalArgumentException {
        return this.container.getComponent(clazz);
    }

    protected ComponentContainer getContainer() {
        return this.container;
    }

    protected <T extends StrolchPolicy> T getPolicy(Class<T> policyClass, PolicyContainer policyContainer) {
        PolicyDefs policyDefs = policyContainer.getPolicyDefs();
        PolicyDef policyDef = policyDefs.getPolicyDef(policyClass.getSimpleName());
        PolicyHandler policyHandler = this.getComponent(PolicyHandler.class);
        Object policy = policyHandler.getPolicy(policyDef, this.tx());
        return policy;
    }

    protected void runAs(String username, SystemAction action) throws PrivilegeException {
        this.container.getPrivilegeHandler().runAs(username, action);
    }

    protected <T> T runWithResult(String username, SystemActionWithResult<T> action) throws PrivilegeException {
        return this.container.getPrivilegeHandler().runWithResult(username, action);
    }

    protected void runAs(String username, PrivilegedRunnable runnable) throws PrivilegeException {
        this.container.getPrivilegeHandler().runAs(username, runnable);
    }

    protected <V> V runWithResult(String username, PrivilegedRunnableWithResult<V> runnable) throws PrivilegeException {
        return this.container.getPrivilegeHandler().runWithResult(username, runnable);
    }

    protected void runAsAgent(SystemAction action) throws PrivilegeException {
        this.container.getPrivilegeHandler().runAsAgent(action);
    }

    protected <V> V runAsAgentWithResult(SystemActionWithResult<V> action) throws PrivilegeException {
        return this.container.getPrivilegeHandler().runAsAgentWithResult(action);
    }

    protected void runAsAgent(PrivilegedRunnable runnable) throws PrivilegeException {
        this.container.getPrivilegeHandler().runAsAgent(runnable);
    }

    protected <V> V runAsAgentWithResult(PrivilegedRunnableWithResult<V> runnable) throws PrivilegeException {
        return this.container.getPrivilegeHandler().runAsAgentWithResult(runnable);
    }

    protected StrolchTransaction tx() {
        return this.tx;
    }

    public String getPrivilegeName() {
        return Command.class.getName();
    }

    public Object getPrivilegeValue() {
        return this.getClass().getName();
    }

    public abstract void validate();

    public abstract void doCommand();

    public abstract void undo();
}

