/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.service.api;

import java.text.MessageFormat;
import li.strolch.agent.api.ComponentContainer;
import li.strolch.agent.api.StrolchComponent;
import li.strolch.exception.StrolchAccessDeniedException;
import li.strolch.exception.StrolchException;
import li.strolch.privilege.base.PrivilegeException;
import li.strolch.privilege.model.Certificate;
import li.strolch.privilege.model.PrivilegeContext;
import li.strolch.runtime.configuration.ComponentConfiguration;
import li.strolch.runtime.configuration.RuntimeConfiguration;
import li.strolch.runtime.privilege.PrivilegeHandler;
import li.strolch.service.api.AbstractService;
import li.strolch.service.api.Service;
import li.strolch.service.api.ServiceArgument;
import li.strolch.service.api.ServiceHandler;
import li.strolch.service.api.ServiceResult;
import li.strolch.service.api.ServiceResultState;
import li.strolch.utils.helper.StringHelper;

public class DefaultServiceHandler
extends StrolchComponent
implements ServiceHandler {
    private static final String PARAM_THROW_ON_PRIVILEGE_FAIL = "throwOnPrivilegeFail";
    private RuntimeConfiguration runtimeConfiguration;
    private PrivilegeHandler privilegeHandler;
    private boolean throwOnPrivilegeFail;

    public DefaultServiceHandler(ComponentContainer container, String componentName) {
        super(container, componentName);
    }

    @Override
    public void initialize(ComponentConfiguration configuration) throws Exception {
        this.privilegeHandler = this.getContainer().getPrivilegeHandler();
        this.runtimeConfiguration = configuration.getRuntimeConfiguration();
        this.throwOnPrivilegeFail = configuration.getBoolean(PARAM_THROW_ON_PRIVILEGE_FAIL, Boolean.FALSE);
        super.initialize(configuration);
    }

    public <T> T getComponent(Class<T> clazz) {
        return this.getContainer().getComponent(clazz);
    }

    public RuntimeConfiguration getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    @Override
    public <U extends ServiceResult> U doService(Certificate certificate, Service<ServiceArgument, U> service) {
        return this.doService(certificate, service, null);
    }

    @Override
    public <T extends ServiceArgument, U extends ServiceResult> U doService(Certificate certificate, Service<T, U> service, T argument) {
        PrivilegeContext privilegeContext;
        long start = System.nanoTime();
        String username = certificate == null ? "null" : certificate.getUsername();
        try {
            privilegeContext = this.privilegeHandler.getPrivilegeContext(certificate);
            privilegeContext.validateAction(service);
        }
        catch (PrivilegeException e) {
            long end = System.nanoTime();
            String msg = "User {0}: Service {1} failed after {2} due to {3}";
            msg = MessageFormat.format(msg, username, service.getClass().getName(), StringHelper.formatNanoDuration((long)(end - start)), e.getMessage());
            logger.error(msg);
            if (!this.throwOnPrivilegeFail && service instanceof AbstractService) {
                logger.error(e.getMessage(), (Throwable)e);
                AbstractService abstractService = (AbstractService)service;
                Object arg = abstractService.getResultInstance();
                ((ServiceResult)arg).setState(ServiceResultState.ACCESS_DENIED);
                ((ServiceResult)arg).setMessage(e.getMessage());
                ((ServiceResult)arg).setThrowable(e);
                return arg;
            }
            throw new StrolchAccessDeniedException(certificate, service, e.getMessage(), (Throwable)e);
        }
        try {
            U serviceResult;
            if (service instanceof AbstractService) {
                AbstractService abstractService = (AbstractService)service;
                abstractService.setContainer(this.getContainer());
                abstractService.setPrivilegeContext(privilegeContext);
            }
            if ((serviceResult = service.doService(argument)) == null) {
                String msg = "Service {0} is not properly implemented as it returned a null result!";
                msg = MessageFormat.format(msg, service.getClass().getSimpleName());
                throw new StrolchException(msg);
            }
            this.logResult(service, start, username, (ServiceResult)serviceResult);
            return serviceResult;
        }
        catch (Exception e) {
            long end = System.nanoTime();
            String msg = "User {0}: Service failed {1} after {2} due to {3}";
            msg = MessageFormat.format(msg, username, service.getClass().getName(), StringHelper.formatNanoDuration((long)(end - start)), e.getMessage());
            logger.error(msg);
            throw new StrolchException(msg, (Throwable)e);
        }
    }

    private void logResult(Service<?, ?> service, long start, String username, ServiceResult serviceResult) {
        long end = System.nanoTime();
        String msg = "User {0}: Service {1} took {2}";
        msg = MessageFormat.format(msg, username, service.getClass().getName(), StringHelper.formatNanoDuration((long)(end - start)));
        if (serviceResult.getState() == ServiceResultState.SUCCESS) {
            logger.info(msg);
        } else if (serviceResult.getState() == ServiceResultState.WARNING) {
            msg = (Object)((Object)ServiceResultState.WARNING) + " " + msg;
            logger.warn(msg);
            if (StringHelper.isNotEmpty((String)serviceResult.getMessage()) && serviceResult.getThrowable() != null) {
                logger.warn("Reason: " + serviceResult.getMessage(), serviceResult.getThrowable());
            } else if (StringHelper.isNotEmpty((String)serviceResult.getMessage())) {
                logger.warn("Reason: " + serviceResult.getMessage());
            } else if (serviceResult.getThrowable() != null) {
                logger.warn("Reason: " + serviceResult.getThrowable().getMessage(), serviceResult.getThrowable());
            }
        } else if (serviceResult.getState() == ServiceResultState.FAILED) {
            msg = (Object)((Object)ServiceResultState.FAILED) + " " + msg;
            logger.error(msg);
            if (StringHelper.isNotEmpty((String)serviceResult.getMessage()) && serviceResult.getThrowable() != null) {
                logger.error("Reason: " + serviceResult.getMessage(), serviceResult.getThrowable());
            } else if (StringHelper.isNotEmpty((String)serviceResult.getMessage())) {
                logger.error("Reason: " + serviceResult.getMessage());
            } else if (serviceResult.getThrowable() != null) {
                logger.error("Reason: " + serviceResult.getThrowable().getMessage(), serviceResult.getThrowable());
            }
        } else if (serviceResult.getState() == null) {
            logger.warn("Service " + service.getClass().getName() + " returned a null ServiceResultState!");
            logger.warn(msg);
        } else {
            logger.warn("UNHANDLED SERVICE RESULT STATE: " + (Object)((Object)serviceResult.getState()));
            logger.warn(msg);
        }
    }
}

