/*
 * Decompiled with CFR 0.152.
 */
package li.strolch.service.api;

import java.io.Serializable;
import li.strolch.service.api.ServiceResultState;

public class ServiceResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ServiceResultState state;
    private String message;
    private Throwable throwable;

    public ServiceResult() {
    }

    public ServiceResult(ServiceResultState state) {
        this.state = state;
    }

    public ServiceResult(ServiceResultState state, String message) {
        this.state = state;
        this.message = message;
    }

    public ServiceResult(ServiceResultState state, String message, Throwable throwable) {
        this.state = state;
        this.message = message;
        this.throwable = throwable;
    }

    public boolean isOk() {
        return this.state == ServiceResultState.SUCCESS;
    }

    public boolean isNok() {
        return this.state != ServiceResultState.SUCCESS;
    }

    public ServiceResultState getState() {
        return this.state;
    }

    public void setState(ServiceResultState state) {
        this.state = state;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getRootMessage() {
        Throwable t = this.getRootCause();
        if (t == null) {
            return null;
        }
        return t.getMessage() == null ? t.getClass().getName() : t.getClass().getName() + ": " + t.getMessage();
    }

    public Throwable getRootCause() {
        if (this.throwable == null) {
            return null;
        }
        Throwable t = this.throwable;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public static ServiceResult success() {
        return new ServiceResult(ServiceResultState.SUCCESS, null, null);
    }

    public static ServiceResult success(String msg) {
        return new ServiceResult(ServiceResultState.SUCCESS, msg, null);
    }

    public static ServiceResult warning(String warning) {
        return new ServiceResult(ServiceResultState.WARNING, warning, null);
    }

    public static ServiceResult warning(String warning, Throwable t) {
        return new ServiceResult(ServiceResultState.WARNING, warning, t);
    }

    public static ServiceResult error(String error) {
        return new ServiceResult(ServiceResultState.FAILED, error, null);
    }

    public static ServiceResult failed(String error, Throwable t) {
        return new ServiceResult(ServiceResultState.FAILED, error, t);
    }
}

