/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.spring.boot.common.example.data.redis;

import cn.hutool.core.date.StopWatch;
import cn.hutool.core.thread.ThreadUtil;
import javax.annotation.PostConstruct;
import link.thingscloud.spring.boot.common.example.CommonTest;
import link.thingscloud.spring.boot.common.redis.SimpleDistributedLocker;
import link.thingscloud.spring.boot.common.redis.callback.RedisResponseCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DistributedLockerTest
implements CommonTest {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockerTest.class);
    @Autowired
    private SimpleDistributedLocker simpleDistributedLocker;
    private final String key = this.getClass().getSimpleName();
    private final RedisResponseCallback callback = new RedisResponseCallback(){

        public void onSucceed() {
            log.info("lock {} onSucceed", (Object)DistributedLockerTest.this.key);
        }

        public void onFailure() {
            log.info("lock {} onFailure", (Object)DistributedLockerTest.this.key);
        }

        public void onException(Throwable cause) {
            log.error("lock {} onException", (Object)DistributedLockerTest.this.key, (Object)cause);
        }
    };

    private void tryLock() {
        int i;
        this.simpleDistributedLocker.tryLock(this.key, this.callback);
        this.simpleDistributedLocker.tryLock(this.key, this.callback);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        for (i = 0; i < 10; ++i) {
            this.simpleDistributedLocker.tryLock(this.key, this.callback);
        }
        stopWatch.stop();
        System.out.println(stopWatch.prettyPrint());
        for (i = 0; i < 10; ++i) {
            ThreadUtil.execute(() -> this.simpleDistributedLocker.tryLock(this.key, this.callback));
        }
    }

    private void lock() {
        int i;
        this.simpleDistributedLocker.lock(this.key, 1000L, this.callback);
        this.simpleDistributedLocker.lock(this.key, 1000L, this.callback);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        for (i = 0; i < 10; ++i) {
            this.simpleDistributedLocker.lock(this.key, 1000L, this.callback);
        }
        stopWatch.stop();
        System.out.println(stopWatch.prettyPrint());
        for (i = 0; i < 10; ++i) {
            ThreadUtil.execute(() -> this.simpleDistributedLocker.lock(this.key, 1000L, this.callback));
        }
    }

    @Override
    @PostConstruct
    public void startup() {
        this.tryLock();
        this.lock();
    }
}

