/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.mobile.area.impl;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import link.thingscloud.mobile.area.MobileArea;
import link.thingscloud.mobile.area.domain.Area;
import link.thingscloud.mobile.area.domain.Mobile;
import link.thingscloud.mobile.area.domain.Type;
import link.thingscloud.mobile.area.util.MapBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobileAreaImpl
implements MobileArea {
    private static final Logger log = LoggerFactory.getLogger(MobileAreaImpl.class);
    private final Map<String, Type> typeMap = new HashMap<String, Type>();
    private final Map<String, Mobile> mobileMap = new HashMap<String, Mobile>(409600);
    private static final String MOBILE_RESOURCE_FILE = "classpath:/mobile-20220720.csv";

    public MobileAreaImpl() {
        this.load0();
        this.loadMobile();
    }

    @Override
    public Mobile getMobile(String mobileNo) {
        if (mobileNo == null) {
            return null;
        }
        return this.mobileMap.get(this.trimMobileNo(mobileNo));
    }

    @Override
    public Area getArea(String mobileNo) {
        Mobile mobile = this.getMobile(mobileNo);
        if (mobile == null) {
            return null;
        }
        return mobile.getArea();
    }

    @Override
    public Type getType(String mobileNo) {
        Mobile mobile = this.getMobile(mobileNo);
        if (mobile == null) {
            return Type.NONE;
        }
        return mobile.getType();
    }

    private String trimMobileNo(String mobileNo) {
        if (mobileNo == null || mobileNo.length() < 11) {
            return mobileNo;
        }
        return mobileNo.substring(mobileNo.length() - 11, mobileNo.length() - 4);
    }

    private void load0() {
        MapBuilder<String, Type> builder = MapBuilder.newBuilder();
        builder.put("133", Type.CTCC).put("149", Type.CTCC).put("153", Type.CTCC).put("162", Type.CTCC).put("173", Type.CTCC).put("174", Type.CTCC).put("177", Type.CTCC).put("180", Type.CTCC).put("181", Type.CTCC).put("189", Type.CTCC).put("190", Type.CTCC).put("191", Type.CTCC).put("193", Type.CTCC).put("199", Type.CTCC);
        builder.put("130", Type.CUCC).put("131", Type.CUCC).put("132", Type.CUCC).put("145", Type.CUCC).put("146", Type.CUCC).put("155", Type.CUCC).put("156", Type.CUCC).put("167", Type.CUCC).put("175", Type.CUCC).put("176", Type.CUCC).put("185", Type.CUCC).put("186", Type.CUCC).put("166", Type.CUCC).put("196", Type.CUCC);
        builder.put("1340", Type.CMCC).put("1341", Type.CMCC).put("1342", Type.CMCC).put("1343", Type.CMCC).put("1344", Type.CMCC).put("1345", Type.CMCC).put("1346", Type.CMCC).put("1347", Type.CMCC).put("1348", Type.CMCC).put("135", Type.CMCC).put("136", Type.CMCC).put("137", Type.CMCC).put("138", Type.CMCC).put("139", Type.CMCC).put("147", Type.CMCC).put("148", Type.CMCC).put("150", Type.CMCC).put("151", Type.CMCC).put("152", Type.CMCC).put("157", Type.CMCC).put("158", Type.CMCC).put("159", Type.CMCC).put("165", Type.CMCC).put("172", Type.CMCC).put("178", Type.CMCC).put("179", Type.CMCC).put("182", Type.CMCC).put("183", Type.CMCC).put("184", Type.CMCC).put("187", Type.CMCC).put("188", Type.CMCC).put("195", Type.CMCC).put("198", Type.CMCC);
        builder.put("1349", Type.CSCC);
        builder.put("1700", Type.V_CTCC).put("1701", Type.V_CTCC).put("1702", Type.V_CTCC);
        builder.put("1703", Type.V_CMCC).put("1705", Type.V_CMCC).put("1706", Type.V_CMCC);
        builder.put("1704", Type.V_CUCC).put("1707", Type.V_CUCC).put("1708", Type.V_CUCC).put("1709", Type.V_CUCC).put("171", Type.V_CUCC);
        this.typeMap.putAll(builder.build());
    }

    private Type getType0(String mobileNo) {
        return this.typeMap.getOrDefault(mobileNo.substring(0, 4), this.typeMap.get(mobileNo.substring(0, 3)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMobile() {
        long start = System.currentTimeMillis();
        HashMap<String, Area> areaMap = new HashMap<String, Area>();
        BufferedReader bufferedReader = null;
        try {
            String line;
            InputStream inputStream = MobileAreaImpl.class.getResourceAsStream(MOBILE_RESOURCE_FILE.replace("classpath:", ""));
            InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            bufferedReader = new BufferedReader(reader);
            while ((line = bufferedReader.readLine()) != null) {
                String[] strs = line.split(",");
                if (strs.length != 4 && strs.length != 3) continue;
                Type type = this.getType0(strs[0]);
                if (type == null) {
                    log.error("not found type for : {}", (Object)line);
                    continue;
                }
                Area area = (Area)areaMap.get(strs[1] + "," + strs[2]);
                if (area == null) {
                    area = new Area(strs[1], strs[2]);
                    areaMap.put(strs[1] + "," + strs[2], area);
                }
                if (strs.length == 4) {
                    this.mobileMap.put(strs[0], new Mobile(strs[0], type, area, strs[3]));
                    continue;
                }
                this.mobileMap.put(strs[0], new Mobile(strs[0], type, area, ""));
            }
            this.close(bufferedReader);
        }
        catch (IOException e) {
            log.error("load resource [{}] failed, cause : ", (Object)MOBILE_RESOURCE_FILE, (Object)e);
        }
        finally {
            this.close(bufferedReader);
        }
        log.info("load resource file name : {}, mobile size : {}, area size : {}, type size : {}, used {} ms.", new Object[]{MOBILE_RESOURCE_FILE, this.mobileMap.size(), areaMap.size(), this.typeMap.size(), System.currentTimeMillis() - start});
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

