(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'kotlinx-serialization-kotlinx-serialization-core-js-legacy', 'catcode2-core'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('kotlinx-serialization-kotlinx-serialization-core-js-legacy'), require('catcode2-core'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'catcode2-serialization-kotlinx'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'catcode2-serialization-kotlinx'.");
    }
    if (typeof this['kotlinx-serialization-kotlinx-serialization-core-js-legacy'] === 'undefined') {
      throw new Error("Error loading module 'catcode2-serialization-kotlinx'. Its dependency 'kotlinx-serialization-kotlinx-serialization-core-js-legacy' was not found. Please, check whether 'kotlinx-serialization-kotlinx-serialization-core-js-legacy' is loaded prior to 'catcode2-serialization-kotlinx'.");
    }
    if (typeof this['catcode2-core'] === 'undefined') {
      throw new Error("Error loading module 'catcode2-serialization-kotlinx'. Its dependency 'catcode2-core' was not found. Please, check whether 'catcode2-core' is loaded prior to 'catcode2-serialization-kotlinx'.");
    }
    root['catcode2-serialization-kotlinx'] = factory(typeof this['catcode2-serialization-kotlinx'] === 'undefined' ? {} : this['catcode2-serialization-kotlinx'], kotlin, this['kotlinx-serialization-kotlinx-serialization-core-js-legacy'], this['catcode2-core']);
  }
}(this, function (_, Kotlin, $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy, $module$catcode2_core) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var EmptySerializersModule = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.modules.EmptySerializersModule;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Unit = Kotlin.kotlin.Unit;
  var getCallableRef = Kotlin.getCallableRef;
  var CatCodeLiteralBuilder = $module$catcode2_core.catcode2.cat.CatCodeLiteralBuilder;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var StringFormat = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.StringFormat;
  var PolymorphicKind = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.descriptors.PolymorphicKind;
  var catcode2 = $module$catcode2_core.catcode2;
  var toBoxedChar = Kotlin.toBoxedChar;
  var startsWith = Kotlin.kotlin.text.startsWith_7epoxm$;
  var getValue = Kotlin.kotlin.collections.getValue_t9ocha$;
  var SerializationException_init = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.SerializationException_init_pdl1vj$;
  var toBoolean = Kotlin.kotlin.text.toBoolean_5cw0du$;
  var toByte = Kotlin.kotlin.text.toByte_pdl1vz$;
  var toShort = Kotlin.kotlin.text.toShort_pdl1vz$;
  var toInt = Kotlin.kotlin.text.toInt_pdl1vz$;
  var toLong = Kotlin.kotlin.text.toLong_pdl1vz$;
  var toDouble = Kotlin.kotlin.text.toDouble_pdl1vz$;
  var single = Kotlin.kotlin.text.single_gw00vp$;
  var StructureKind = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.descriptors.StructureKind;
  var equals = Kotlin.equals;
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var LinkedHashMap_init = Kotlin.kotlin.collections.LinkedHashMap_init_q3lmfv$;
  var checkCatCode = $module$catcode2_core.catcode2.checkCatCode;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var checkCatCodeLoosely = $module$catcode2_core.catcode2.checkCatCodeLoosely_61zpoe$;
  var indexOf = Kotlin.kotlin.text.indexOf_8eortd$;
  var get_lastIndex = Kotlin.kotlin.text.get_lastIndex_gw00vp$;
  var Collection = Kotlin.kotlin.collections.Collection;
  var throwCCE = Kotlin.throwCCE;
  var last = Kotlin.kotlin.collections.last_2p1efm$;
  var lastOrNull = Kotlin.kotlin.collections.lastOrNull_2p1efm$;
  var get_lastIndex_0 = Kotlin.kotlin.collections.get_lastIndex_55thoc$;
  var Decoder = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.encoding.Decoder;
  var CompositeDecoder = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.encoding.CompositeDecoder;
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_287e2$;
  var Encoder = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.encoding.Encoder;
  var CompositeEncoder = $module$kotlinx_serialization_kotlinx_serialization_core_js_legacy.kotlinx.serialization.encoding.CompositeEncoder;
  var Annotation = Kotlin.kotlin.Annotation;
  CatCode$Default.prototype = Object.create(CatCode.prototype);
  CatCode$Default.prototype.constructor = CatCode$Default;
  CatCodeLiteralEncoder.prototype = Object.create(CatCodeEncoder.prototype);
  CatCodeLiteralEncoder.prototype.constructor = CatCodeLiteralEncoder;
  CatCodeLiteralDecoder.prototype = Object.create(CatCodeDecoder.prototype);
  CatCodeLiteralDecoder.prototype.constructor = CatCodeLiteralDecoder;
  CatCodeImpl.prototype = Object.create(CatCode.prototype);
  CatCodeImpl.prototype.constructor = CatCodeImpl;
  function requireCatCode$lambda(closure$codeValue) {
    return function () {
      return "code value '" + closure$codeValue + "' not a catcode";
    };
  }
  function CatCode(serializersModule, configuration) {
    CatCode$Default_getInstance();
    this.serializersModule_pixhqj$_0 = serializersModule;
    this.configuration = configuration;
  }
  Object.defineProperty(CatCode.prototype, 'serializersModule', {
    get: function () {
      return this.serializersModule_pixhqj$_0;
    }
  });
  function CatCode$Default() {
    CatCode$Default_instance = this;
    CatCode.call(this, EmptySerializersModule(), CatCodeConfiguration$Companion_getInstance().Default);
  }
  CatCode$Default.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Default',
    interfaces: [CatCode]
  };
  var CatCode$Default_instance = null;
  function CatCode$Default_getInstance() {
    if (CatCode$Default_instance === null) {
      new CatCode$Default();
    }
    return CatCode$Default_instance;
  }
  CatCode.prototype.decodeFromString_awif5v$ = function (deserializer, string) {
    return this.decodeFromCatCodeLiteral_aosatt$_0(deserializer, string);
  };
  CatCode.prototype.decodeFromCatCodeLiteral_aosatt$_0 = function (deserializer, catcode) {
    var properties = LinkedHashMap_init();
    if (this.configuration.isLenient) {
      var lazyMessage;
      lazyMessage = requireCatCode$lambda(catcode);
      if (!checkCatCode(catcode)) {
        var message = lazyMessage();
        throw IllegalArgumentException_init(message.toString());
      }
    }
    var walk = getCallableRef('set', function ($receiver, p1, p2) {
      $receiver.put_xwzc9p$(p1, p2);
      return Unit;
    }.bind(null, properties));
    if (!checkCatCodeLoosely(catcode))
      throw IllegalArgumentException_init("codeValue '" + catcode + "' is not a catcode: Not wrapped by '" + String.fromCharCode(catcode2.CAT_PREFIX) + "' and '" + String.fromCharCode(catcode2.CAT_SUFFIX) + "' or length < 5");
    if (true) {
      var startIndex0 = indexOf(catcode, catcode2.CAT_PROPERTIES_SEPARATOR);
      var lastIndex = get_lastIndex(catcode);
      var startIndex = startIndex0;
      while (1 <= startIndex && startIndex < lastIndex) {
        var propertyIndex = indexOf(catcode, catcode2.CAT_PROPERTY_SEPARATOR, startIndex);
        if (propertyIndex < 0) {
          throw IllegalArgumentException_init("Property separator '" + String.fromCharCode(catcode2.CAT_PROPERTY_SEPARATOR) + "' not found after properties separator '" + String.fromCharCode(catcode2.CAT_PROPERTIES_SEPARATOR) + "' of index " + startIndex);
        }
        var endIndex = indexOf(catcode, catcode2.CAT_PROPERTIES_SEPARATOR, propertyIndex);
        if (endIndex < 0) {
          endIndex = lastIndex;
        }
        var si = startIndex + 1 | 0;
        var ei = endIndex;
        var key = catcode.substring(si, propertyIndex);
        var startIndex_0 = propertyIndex + 1 | 0;
        var value = catcode.substring(startIndex_0, ei);
        walk(key, catcode2.CatEscalator.decodeParam_61zpoe$(value));
        startIndex = endIndex;
      }
    } else {
      var startIndex0_0 = indexOf(catcode, catcode2.CAT_PROPERTIES_SEPARATOR);
      var lastIndex_0 = get_lastIndex(catcode);
      var startIndex_1 = startIndex0_0;
      while (1 <= startIndex_1 && startIndex_1 < lastIndex_0) {
        var propertyIndex_0 = indexOf(catcode, catcode2.CAT_PROPERTY_SEPARATOR, startIndex_1);
        if (propertyIndex_0 < 0) {
          throw IllegalArgumentException_init("Property separator '" + String.fromCharCode(catcode2.CAT_PROPERTY_SEPARATOR) + "' not found after properties separator '" + String.fromCharCode(catcode2.CAT_PROPERTIES_SEPARATOR) + "' of index " + startIndex_1);
        }
        var endIndex_0 = indexOf(catcode, catcode2.CAT_PROPERTIES_SEPARATOR, propertyIndex_0);
        if (endIndex_0 < 0) {
          endIndex_0 = lastIndex_0;
        }
        var si_0 = startIndex_1 + 1 | 0;
        var ei_0 = endIndex_0;
        var key_0 = catcode.substring(si_0, propertyIndex_0);
        var startIndex_2 = propertyIndex_0 + 1 | 0;
        var value_0 = catcode.substring(startIndex_2, ei_0);
        walk(key_0, value_0);
        startIndex_1 = endIndex_0;
      }
    }
    return deserializer.deserialize_bq71mq$(new CatCodeLiteralDecoder(this, deserializer.descriptor, properties));
  };
  CatCode.prototype.encodeToString_tf03ej$ = function (serializer, value) {
    return this.encodeToString_b35oc3$(serializer, value, this.configuration.catHead);
  };
  CatCode.prototype.encodeToString_b35oc3$ = function (serializer, value, catHead) {
    return this.encodeToCatCodeLiteral_s5w73s$_0(serializer, value, catHead);
  };
  CatCode.prototype.encodeToCatCodeLiteral_s5w73s$_0 = function (serializer, value, catHead) {
    var builder = CatCodeLiteralBuilder.Companion.of(this.catTypeName_q8rpzd$_0(serializer), catHead);
    var encoder = new CatCodeLiteralEncoder(this, builder);
    encoder.encodeSerializableValue_tf03ej$(serializer, value);
    return builder.build();
  };
  CatCode.prototype.catTypeName_q8rpzd$_0 = function (serializer) {
    var tmp$;
    tmp$ = serializer.descriptor.annotations.iterator();
    while (tmp$.hasNext()) {
      var annotation = tmp$.next();
      if (Kotlin.isType(annotation, CatCodeTypeName)) {
        return annotation.name;
      }
    }
    return serializer.descriptor.serialName;
  };
  CatCode.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CatCode',
    interfaces: [StringFormat]
  };
  function CatCodeLiteralEncoder(catCode, catBuilder) {
    CatCodeEncoder.call(this);
    this.catCode_1yc432$_0 = catCode;
    this.catBuilder_0 = catBuilder;
    this.serializersModule_vls894$_0 = this.catCode.serializersModule;
    this.configuration_0 = this.catCode.configuration;
  }
  Object.defineProperty(CatCodeLiteralEncoder.prototype, 'catCode', {
    get: function () {
      return this.catCode_1yc432$_0;
    }
  });
  Object.defineProperty(CatCodeLiteralEncoder.prototype, 'serializersModule', {
    configurable: true,
    get: function () {
      return this.serializersModule_vls894$_0;
    }
  });
  CatCodeLiteralEncoder.prototype.getTag_av9bu7$ = function ($receiver, index) {
    return this.nested_0(this.elementName_0($receiver, index));
  };
  CatCodeLiteralEncoder.prototype.nested_0 = function (nestedName) {
    var tmp$;
    return this.composeName_0((tmp$ = this.currentTagOrNull_0) != null ? tmp$ : '', nestedName);
  };
  CatCodeLiteralEncoder.prototype.elementName_0 = function (descriptor, index) {
    var tmp$;
    if (!Kotlin.isType(descriptor.kind, PolymorphicKind)) {
      return descriptor.getElementName_za3lpa$(index);
    }
    var elementName = descriptor.getElementName_za3lpa$(index);
    switch (elementName) {
      case 'type':
        tmp$ = this.configuration_0.classDiscriminator;
        break;
      case 'value':
        tmp$ = this.configuration_0.valueDiscriminator;
        break;
      default:
        tmp$ = elementName;
        break;
    }
    return tmp$;
  };
  CatCodeLiteralEncoder.prototype.composeName_0 = function (parentName, childName) {
    return parentName.length === 0 ? childName : parentName + '.' + childName;
  };
  CatCodeLiteralEncoder.prototype.encodeTaggedValue_yhz2mk$ = function (tag, value) {
    this.encode_0(tag, value.toString());
  };
  CatCodeLiteralEncoder.prototype.encodeTaggedBoolean_onkqg$ = function (tag, value) {
    this.encode_0(tag, value.toString(), false);
  };
  CatCodeLiteralEncoder.prototype.encodeTaggedByte_1r7uvc$ = function (tag, value) {
    this.encode_0(tag, value.toString(), false);
  };
  CatCodeLiteralEncoder.prototype.encodeTaggedInt_nygwzz$ = function (tag, value) {
    this.encode_0(tag, value.toString(), false);
  };
  CatCodeLiteralEncoder.prototype.encodeTaggedDouble_cywou9$ = function (tag, value) {
    this.encode_0(tag, value.toString(), false);
  };
  CatCodeLiteralEncoder.prototype.encodeTaggedFloat_mv9gn0$ = function (tag, value) {
    this.encode_0(tag, value.toString(), false);
  };
  CatCodeLiteralEncoder.prototype.encodeTaggedShort_s4b8v0$ = function (tag, value) {
    this.encode_0(tag, value.toString(), false);
  };
  CatCodeLiteralEncoder.prototype.encodeTaggedChar_j7cd6i$ = function (tag, value) {
    var tmp$;
    var encoded = (tmp$ = catcode2.CatEscalator.getParamEncode(value)) != null ? tmp$ : String.fromCharCode(value);
    this.encode_0(tag, encoded, false);
  };
  CatCodeLiteralEncoder.prototype.encodeTaggedLong_weyjw$ = function (tag, value) {
    this.encode_0(tag, value.toString(), false);
  };
  CatCodeLiteralEncoder.prototype.encodeTaggedNull_trkh7z$ = function (tag) {
    if (this.configuration_0.encodeNullAsEmpty) {
      this.encode_0(tag, '', false);
    }
  };
  CatCodeLiteralEncoder.prototype.encodeTaggedEnum_6xfju7$ = function (tag, enumDescriptor, ordinal) {
    this.encode_0(tag, enumDescriptor.getElementName_za3lpa$(ordinal));
  };
  CatCodeLiteralEncoder.prototype.encode_0 = function (key, value, encode) {
    if (encode === void 0)
      encode = true;
    this.catBuilder_0.set(key, value, encode);
  };
  CatCodeLiteralEncoder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CatCodeLiteralEncoder',
    interfaces: [CatCodeEncoder]
  };
  function CatCodeLiteralDecoder(catCode, descriptor, properties) {
    CatCodeDecoder.call(this);
    this.catCode_4t2192$_0 = catCode;
    this.properties_0 = properties;
    this.currentIndex_0 = 0;
    this.isCollection_0 = equals(descriptor.kind, StructureKind.LIST) || equals(descriptor.kind, StructureKind.MAP);
    this.size_0 = this.isCollection_0 ? 2147483647 : descriptor.elementsCount;
    this.serializersModule_evsns0$_0 = this.catCode.serializersModule;
  }
  Object.defineProperty(CatCodeLiteralDecoder.prototype, 'catCode', {
    get: function () {
      return this.catCode_4t2192$_0;
    }
  });
  Object.defineProperty(CatCodeLiteralDecoder.prototype, 'serializersModule', {
    configurable: true,
    get: function () {
      return this.serializersModule_evsns0$_0;
    }
  });
  CatCodeLiteralDecoder.prototype.getTag_av9bu7$ = function ($receiver, index) {
    return this.nested_0(this.elementName_0($receiver, index));
  };
  CatCodeLiteralDecoder.prototype.nested_0 = function (nestedName) {
    var tmp$;
    return this.composeName_0((tmp$ = this.currentTagOrNull_0) != null ? tmp$ : '', nestedName);
  };
  CatCodeLiteralDecoder.prototype.elementName_0 = function (desc, index) {
    return desc.getElementName_za3lpa$(index);
  };
  CatCodeLiteralDecoder.prototype.composeName_0 = function (parentName, childName) {
    return parentName.length === 0 ? childName : parentName + '.' + childName;
  };
  CatCodeLiteralDecoder.prototype.structure_0 = function (descriptor) {
    return new CatCodeLiteralDecoder(this.catCode, descriptor, this.properties_0);
  };
  CatCodeLiteralDecoder.prototype.beginStructure_24f42q$ = function (descriptor) {
    var $receiver = this.structure_0(descriptor);
    this.copyTagsTo_0($receiver);
    return $receiver;
  };
  CatCodeLiteralDecoder.prototype.decodeElementIndex_24f42q$ = function (descriptor) {
    var tmp$;
    loop_label: while (this.currentIndex_0 < this.size_0) {
      var name = this.getTag_av9bu7$(descriptor, (tmp$ = this.currentIndex_0, this.currentIndex_0 = tmp$ + 1 | 0, tmp$));
      var $receiver = this.properties_0.keys;
      var any$result;
      any$break: do {
        var tmp$_0;
        if (Kotlin.isType($receiver, Collection) && $receiver.isEmpty()) {
          any$result = false;
          break any$break;
        }
        tmp$_0 = $receiver.iterator();
        while (tmp$_0.hasNext()) {
          var element = tmp$_0.next();
          if (startsWith(element, name) && (element.length === name.length || element.charCodeAt(name.length) === 46)) {
            any$result = true;
            break any$break;
          }
        }
        any$result = false;
      }
       while (false);
      if (any$result)
        return this.currentIndex_0 - 1 | 0;
      if (this.isCollection_0) {
        break loop_label;
      }
    }
    return -1;
  };
  CatCodeLiteralDecoder.prototype.decodeTaggedEnum_gaombr$ = function (tag, enumDescriptor) {
    var taggedValue = getValue(this.properties_0, tag);
    var $receiver = enumDescriptor.getElementIndex_61zpoe$(taggedValue);
    if ($receiver === -3)
      throw SerializationException_init("Enum '" + enumDescriptor.serialName + "' does not contain element with name '" + taggedValue + "'");
    return $receiver;
  };
  CatCodeLiteralDecoder.prototype.decodeTaggedValue_11rb$ = function (tag) {
    return getValue(this.properties_0, tag);
  };
  CatCodeLiteralDecoder.prototype.decodeTaggedBoolean_11rb$ = function (tag) {
    return toBoolean(this.decodeTaggedValue_11rb$(tag));
  };
  CatCodeLiteralDecoder.prototype.decodeTaggedByte_11rb$ = function (tag) {
    return toByte(this.decodeTaggedValue_11rb$(tag));
  };
  CatCodeLiteralDecoder.prototype.decodeTaggedShort_11rb$ = function (tag) {
    return toShort(this.decodeTaggedValue_11rb$(tag));
  };
  CatCodeLiteralDecoder.prototype.decodeTaggedInt_11rb$ = function (tag) {
    return toInt(this.decodeTaggedValue_11rb$(tag));
  };
  CatCodeLiteralDecoder.prototype.decodeTaggedLong_11rb$ = function (tag) {
    return toLong(this.decodeTaggedValue_11rb$(tag));
  };
  CatCodeLiteralDecoder.prototype.decodeTaggedFloat_11rb$ = function (tag) {
    return toDouble(this.decodeTaggedValue_11rb$(tag));
  };
  CatCodeLiteralDecoder.prototype.decodeTaggedDouble_11rb$ = function (tag) {
    return toDouble(this.decodeTaggedValue_11rb$(tag));
  };
  CatCodeLiteralDecoder.prototype.decodeTaggedChar_11rb$ = function (tag) {
    return toBoxedChar(single(this.decodeTaggedValue_11rb$(tag)));
  };
  CatCodeLiteralDecoder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CatCodeLiteralDecoder',
    interfaces: [CatCodeDecoder]
  };
  function CatCodeImpl(serializersModule, configuration) {
    CatCode.call(this, serializersModule, configuration);
    this.validate_0(configuration);
  }
  CatCodeImpl.prototype.validate_0 = function ($receiver) {
    if (!($receiver.classDiscriminator.length > 0)) {
      var message = "'classDiscriminator' cannot be empty";
      throw IllegalArgumentException_init(message.toString());
    }
    if (!($receiver.valueDiscriminator.length > 0)) {
      var message_0 = "'valueDiscriminator' cannot be empty";
      throw IllegalArgumentException_init(message_0.toString());
    }
    if (!!equals($receiver.classDiscriminator, $receiver.valueDiscriminator)) {
      var message_1 = "'classDiscriminator' and 'valueDiscriminator' cannot be the same, but they are both '" + $receiver.classDiscriminator + "' now";
      throw IllegalArgumentException_init(message_1.toString());
    }
    if (!($receiver.catHead.length > 0)) {
      var message_2 = "'catHead' cannot be empty";
      throw IllegalArgumentException_init(message_2.toString());
    }
  };
  CatCodeImpl.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CatCodeImpl',
    interfaces: [CatCode]
  };
  function catCode(builder) {
    var $receiver = new CatCodeBuilder();
    builder.invoke_fnhrt2$($receiver);
    return buildToCatCode($receiver);
  }
  function CatCodeBuilderFunction(f) {
    this.function$ = f;
  }
  CatCodeBuilderFunction.prototype.invoke_fnhrt2$ = function ($receiver) {
    return this.function$($receiver);
  };
  CatCodeBuilderFunction.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'CatCodeBuilderFunction',
    interfaces: []
  };
  function buildToCatCode($receiver) {
    return new CatCodeImpl($receiver.serializersModule, new CatCodeConfiguration($receiver.catHead, $receiver.classDiscriminator, $receiver.valueDiscriminator, $receiver.encodeNullAsEmpty, $receiver.decodeEmptyAsNull, $receiver.isLenient));
  }
  function CatCodeBuilder() {
    this.serializersModule = EmptySerializersModule();
    this.catHead = CatCodeConfiguration$Companion_getInstance().Default.catHead;
    this.classDiscriminator = CatCodeConfiguration$Companion_getInstance().Default.classDiscriminator;
    this.valueDiscriminator = CatCodeConfiguration$Companion_getInstance().Default.valueDiscriminator;
    this.encodeNullAsEmpty = CatCodeConfiguration$Companion_getInstance().Default.encodeNullAsEmpty;
    this.decodeEmptyAsNull = CatCodeConfiguration$Companion_getInstance().Default.decodeEmptyAsNull;
    this.isLenient = CatCodeConfiguration$Companion_getInstance().Default.isLenient;
  }
  CatCodeBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CatCodeBuilder',
    interfaces: []
  };
  function CatCodeConfiguration(catHead, classDiscriminator, valueDiscriminator, encodeNullAsEmpty, decodeEmptyAsNull, isLenient) {
    CatCodeConfiguration$Companion_getInstance();
    if (catHead === void 0)
      catHead = catcode2.CAT_HEAD;
    if (classDiscriminator === void 0)
      classDiscriminator = 'type';
    if (valueDiscriminator === void 0)
      valueDiscriminator = 'value';
    if (encodeNullAsEmpty === void 0)
      encodeNullAsEmpty = false;
    if (decodeEmptyAsNull === void 0)
      decodeEmptyAsNull = true;
    if (isLenient === void 0)
      isLenient = false;
    this.catHead = catHead;
    this.classDiscriminator = classDiscriminator;
    this.valueDiscriminator = valueDiscriminator;
    this.encodeNullAsEmpty = encodeNullAsEmpty;
    this.decodeEmptyAsNull = decodeEmptyAsNull;
    this.isLenient = isLenient;
  }
  function CatCodeConfiguration$Companion() {
    CatCodeConfiguration$Companion_instance = this;
    this.Default = new CatCodeConfiguration();
  }
  CatCodeConfiguration$Companion.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Companion',
    interfaces: []
  };
  var CatCodeConfiguration$Companion_instance = null;
  function CatCodeConfiguration$Companion_getInstance() {
    if (CatCodeConfiguration$Companion_instance === null) {
      new CatCodeConfiguration$Companion();
    }
    return CatCodeConfiguration$Companion_instance;
  }
  CatCodeConfiguration.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CatCodeConfiguration',
    interfaces: []
  };
  CatCodeConfiguration.prototype.component1 = function () {
    return this.catHead;
  };
  CatCodeConfiguration.prototype.component2 = function () {
    return this.classDiscriminator;
  };
  CatCodeConfiguration.prototype.component3 = function () {
    return this.valueDiscriminator;
  };
  CatCodeConfiguration.prototype.component4 = function () {
    return this.encodeNullAsEmpty;
  };
  CatCodeConfiguration.prototype.component5 = function () {
    return this.decodeEmptyAsNull;
  };
  CatCodeConfiguration.prototype.component6 = function () {
    return this.isLenient;
  };
  CatCodeConfiguration.prototype.copy_5418n9$ = function (catHead, classDiscriminator, valueDiscriminator, encodeNullAsEmpty, decodeEmptyAsNull, isLenient) {
    return new CatCodeConfiguration(catHead === void 0 ? this.catHead : catHead, classDiscriminator === void 0 ? this.classDiscriminator : classDiscriminator, valueDiscriminator === void 0 ? this.valueDiscriminator : valueDiscriminator, encodeNullAsEmpty === void 0 ? this.encodeNullAsEmpty : encodeNullAsEmpty, decodeEmptyAsNull === void 0 ? this.decodeEmptyAsNull : decodeEmptyAsNull, isLenient === void 0 ? this.isLenient : isLenient);
  };
  CatCodeConfiguration.prototype.toString = function () {
    return 'CatCodeConfiguration(catHead=' + Kotlin.toString(this.catHead) + (', classDiscriminator=' + Kotlin.toString(this.classDiscriminator)) + (', valueDiscriminator=' + Kotlin.toString(this.valueDiscriminator)) + (', encodeNullAsEmpty=' + Kotlin.toString(this.encodeNullAsEmpty)) + (', decodeEmptyAsNull=' + Kotlin.toString(this.decodeEmptyAsNull)) + (', isLenient=' + Kotlin.toString(this.isLenient)) + ')';
  };
  CatCodeConfiguration.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.catHead) | 0;
    result = result * 31 + Kotlin.hashCode(this.classDiscriminator) | 0;
    result = result * 31 + Kotlin.hashCode(this.valueDiscriminator) | 0;
    result = result * 31 + Kotlin.hashCode(this.encodeNullAsEmpty) | 0;
    result = result * 31 + Kotlin.hashCode(this.decodeEmptyAsNull) | 0;
    result = result * 31 + Kotlin.hashCode(this.isLenient) | 0;
    return result;
  };
  CatCodeConfiguration.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.catHead, other.catHead) && Kotlin.equals(this.classDiscriminator, other.classDiscriminator) && Kotlin.equals(this.valueDiscriminator, other.valueDiscriminator) && Kotlin.equals(this.encodeNullAsEmpty, other.encodeNullAsEmpty) && Kotlin.equals(this.decodeEmptyAsNull, other.decodeEmptyAsNull) && Kotlin.equals(this.isLenient, other.isLenient)))));
  };
  function CatCodeDecoder() {
    this.tagStack_0 = ArrayList_init();
    this.flag_0 = false;
  }
  CatCodeDecoder.prototype.decodeTaggedNotNullMark_11rb$ = function (tag) {
    return true;
  };
  CatCodeDecoder.prototype.decodeTaggedNull_11rb$ = function (tag) {
    return null;
  };
  CatCodeDecoder.prototype.decodeTaggedBoolean_11rb$ = function (tag) {
    var tmp$;
    return typeof (tmp$ = this.decodeTaggedValue_11rb$(tag)) === 'boolean' ? tmp$ : throwCCE();
  };
  CatCodeDecoder.prototype.decodeTaggedByte_11rb$ = function (tag) {
    var tmp$;
    return typeof (tmp$ = this.decodeTaggedValue_11rb$(tag)) === 'number' ? tmp$ : throwCCE();
  };
  CatCodeDecoder.prototype.decodeTaggedShort_11rb$ = function (tag) {
    var tmp$;
    return typeof (tmp$ = this.decodeTaggedValue_11rb$(tag)) === 'number' ? tmp$ : throwCCE();
  };
  CatCodeDecoder.prototype.decodeTaggedInt_11rb$ = function (tag) {
    var tmp$;
    return typeof (tmp$ = this.decodeTaggedValue_11rb$(tag)) === 'number' ? tmp$ : throwCCE();
  };
  CatCodeDecoder.prototype.decodeTaggedLong_11rb$ = function (tag) {
    var tmp$;
    return Kotlin.isType(tmp$ = this.decodeTaggedValue_11rb$(tag), Kotlin.Long) ? tmp$ : throwCCE();
  };
  CatCodeDecoder.prototype.decodeTaggedFloat_11rb$ = function (tag) {
    var tmp$;
    return typeof (tmp$ = this.decodeTaggedValue_11rb$(tag)) === 'number' ? tmp$ : throwCCE();
  };
  CatCodeDecoder.prototype.decodeTaggedDouble_11rb$ = function (tag) {
    var tmp$;
    return typeof (tmp$ = this.decodeTaggedValue_11rb$(tag)) === 'number' ? tmp$ : throwCCE();
  };
  CatCodeDecoder.prototype.decodeTaggedChar_11rb$ = function (tag) {
    var tmp$;
    return Kotlin.isChar(tmp$ = this.decodeTaggedValue_11rb$(tag)) ? tmp$ : throwCCE();
  };
  CatCodeDecoder.prototype.decodeTaggedString_11rb$ = function (tag) {
    var tmp$;
    return typeof (tmp$ = this.decodeTaggedValue_11rb$(tag)) === 'string' ? tmp$ : throwCCE();
  };
  CatCodeDecoder.prototype.decodeTaggedEnum_gaombr$ = function (tag, enumDescriptor) {
    var tmp$;
    return typeof (tmp$ = this.decodeTaggedValue_11rb$(tag)) === 'number' ? tmp$ : throwCCE();
  };
  CatCodeDecoder.prototype.decodeTaggedInline_gaombr$ = function (tag, inlineDescriptor) {
    this.pushTag_0(tag);
    return this;
  };
  CatCodeDecoder.prototype.decodeSerializableValue_19c8k5$ = function (deserializer, previousValue) {
    return this.decodeSerializableValue_w63s0f$(deserializer);
  };
  CatCodeDecoder.prototype.decodeInline_24f42q$ = function (descriptor) {
    return this.decodeTaggedInline_gaombr$(this.popTag_0(), descriptor);
  };
  CatCodeDecoder.prototype.decodeNotNullMark = function () {
    var tmp$;
    tmp$ = this.currentTagOrNull_0;
    if (tmp$ == null) {
      return false;
    }
    var currentTag = tmp$;
    return this.decodeTaggedNotNullMark_11rb$(currentTag);
  };
  CatCodeDecoder.prototype.decodeNull = function () {
    return null;
  };
  CatCodeDecoder.prototype.decodeBoolean = function () {
    return this.decodeTaggedBoolean_11rb$(this.popTag_0());
  };
  CatCodeDecoder.prototype.decodeByte = function () {
    return this.decodeTaggedByte_11rb$(this.popTag_0());
  };
  CatCodeDecoder.prototype.decodeShort = function () {
    return this.decodeTaggedShort_11rb$(this.popTag_0());
  };
  CatCodeDecoder.prototype.decodeInt = function () {
    return this.decodeTaggedInt_11rb$(this.popTag_0());
  };
  CatCodeDecoder.prototype.decodeLong = function () {
    return this.decodeTaggedLong_11rb$(this.popTag_0());
  };
  CatCodeDecoder.prototype.decodeFloat = function () {
    return this.decodeTaggedFloat_11rb$(this.popTag_0());
  };
  CatCodeDecoder.prototype.decodeDouble = function () {
    return this.decodeTaggedDouble_11rb$(this.popTag_0());
  };
  CatCodeDecoder.prototype.decodeChar = function () {
    return this.decodeTaggedChar_11rb$(this.popTag_0());
  };
  CatCodeDecoder.prototype.decodeString = function () {
    return this.decodeTaggedString_11rb$(this.popTag_0());
  };
  CatCodeDecoder.prototype.decodeEnum_24f42q$ = function (enumDescriptor) {
    return this.decodeTaggedEnum_gaombr$(this.popTag_0(), enumDescriptor);
  };
  CatCodeDecoder.prototype.beginStructure_24f42q$ = function (descriptor) {
    return this;
  };
  CatCodeDecoder.prototype.endStructure_24f42q$ = function (descriptor) {
  };
  CatCodeDecoder.prototype.decodeBooleanElement_szpzho$ = function (descriptor, index) {
    return this.decodeTaggedBoolean_11rb$(this.getTag_av9bu7$(descriptor, index));
  };
  CatCodeDecoder.prototype.decodeByteElement_szpzho$ = function (descriptor, index) {
    return this.decodeTaggedByte_11rb$(this.getTag_av9bu7$(descriptor, index));
  };
  CatCodeDecoder.prototype.decodeShortElement_szpzho$ = function (descriptor, index) {
    return this.decodeTaggedShort_11rb$(this.getTag_av9bu7$(descriptor, index));
  };
  CatCodeDecoder.prototype.decodeIntElement_szpzho$ = function (descriptor, index) {
    return this.decodeTaggedInt_11rb$(this.getTag_av9bu7$(descriptor, index));
  };
  CatCodeDecoder.prototype.decodeLongElement_szpzho$ = function (descriptor, index) {
    return this.decodeTaggedLong_11rb$(this.getTag_av9bu7$(descriptor, index));
  };
  CatCodeDecoder.prototype.decodeFloatElement_szpzho$ = function (descriptor, index) {
    return this.decodeTaggedFloat_11rb$(this.getTag_av9bu7$(descriptor, index));
  };
  CatCodeDecoder.prototype.decodeDoubleElement_szpzho$ = function (descriptor, index) {
    return this.decodeTaggedDouble_11rb$(this.getTag_av9bu7$(descriptor, index));
  };
  CatCodeDecoder.prototype.decodeCharElement_szpzho$ = function (descriptor, index) {
    return this.decodeTaggedChar_11rb$(this.getTag_av9bu7$(descriptor, index));
  };
  CatCodeDecoder.prototype.decodeStringElement_szpzho$ = function (descriptor, index) {
    return this.decodeTaggedString_11rb$(this.getTag_av9bu7$(descriptor, index));
  };
  CatCodeDecoder.prototype.decodeInlineElement_szpzho$ = function (descriptor, index) {
    return this.decodeTaggedInline_gaombr$(this.getTag_av9bu7$(descriptor, index), descriptor.getElementDescriptor_za3lpa$(index));
  };
  function CatCodeDecoder$decodeSerializableElement$lambda(closure$deserializer, closure$previousValue, this$CatCodeDecoder) {
    return function () {
      return this$CatCodeDecoder.decodeSerializableValue_19c8k5$(closure$deserializer, closure$previousValue);
    };
  }
  CatCodeDecoder.prototype.decodeSerializableElement_12e8id$$default = function (descriptor, index, deserializer, previousValue) {
    return this.tagBlock_0(this.getTag_av9bu7$(descriptor, index), CatCodeDecoder$decodeSerializableElement$lambda(deserializer, previousValue, this));
  };
  function CatCodeDecoder$decodeNullableSerializableElement$lambda(this$CatCodeDecoder, closure$deserializer, closure$previousValue) {
    return function () {
      return this$CatCodeDecoder.decodeNotNullMark() ? this$CatCodeDecoder.decodeSerializableValue_19c8k5$(closure$deserializer, closure$previousValue) : this$CatCodeDecoder.decodeNull();
    };
  }
  CatCodeDecoder.prototype.decodeNullableSerializableElement_8viuyw$$default = function (descriptor, index, deserializer, previousValue) {
    return this.tagBlock_0(this.getTag_av9bu7$(descriptor, index), CatCodeDecoder$decodeNullableSerializableElement$lambda(this, deserializer, previousValue));
  };
  CatCodeDecoder.prototype.tagBlock_0 = function (tag, block) {
    this.pushTag_0(tag);
    var r = block();
    if (!this.flag_0) {
      this.popTag_0();
    }
    this.flag_0 = false;
    return r;
  };
  Object.defineProperty(CatCodeDecoder.prototype, 'currentTag_0', {
    configurable: true,
    get: function () {
      return last(this.tagStack_0);
    }
  });
  Object.defineProperty(CatCodeDecoder.prototype, 'currentTagOrNull_0', {
    configurable: true,
    get: function () {
      return lastOrNull(this.tagStack_0);
    }
  });
  CatCodeDecoder.prototype.pushTag_0 = function (name) {
    this.tagStack_0.add_11rb$(name);
  };
  CatCodeDecoder.prototype.copyTagsTo_0 = function (other) {
    other.tagStack_0.addAll_brywnq$(this.tagStack_0);
  };
  CatCodeDecoder.prototype.popTag_0 = function () {
    var r = this.tagStack_0.removeAt_za3lpa$(get_lastIndex_0(this.tagStack_0));
    this.flag_0 = true;
    return r;
  };
  CatCodeDecoder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CatCodeDecoder',
    interfaces: [CompositeDecoder, Decoder]
  };
  function CatCodeEncoder() {
    this.tagStack_0 = ArrayList_init();
  }
  CatCodeEncoder.prototype.encodeTaggedNonNullMark_trkh7z$ = function (tag) {
  };
  CatCodeEncoder.prototype.encodeTaggedNull_trkh7z$ = function (tag) {
    throw SerializationException_init('null is not supported');
  };
  CatCodeEncoder.prototype.encodeTaggedInt_nygwzz$ = function (tag, value) {
    this.encodeTaggedValue_yhz2mk$(tag, value);
  };
  CatCodeEncoder.prototype.encodeTaggedByte_1r7uvc$ = function (tag, value) {
    this.encodeTaggedValue_yhz2mk$(tag, value);
  };
  CatCodeEncoder.prototype.encodeTaggedShort_s4b8v0$ = function (tag, value) {
    this.encodeTaggedValue_yhz2mk$(tag, value);
  };
  CatCodeEncoder.prototype.encodeTaggedLong_weyjw$ = function (tag, value) {
    this.encodeTaggedValue_yhz2mk$(tag, value);
  };
  CatCodeEncoder.prototype.encodeTaggedFloat_mv9gn0$ = function (tag, value) {
    this.encodeTaggedValue_yhz2mk$(tag, value);
  };
  CatCodeEncoder.prototype.encodeTaggedDouble_cywou9$ = function (tag, value) {
    this.encodeTaggedValue_yhz2mk$(tag, value);
  };
  CatCodeEncoder.prototype.encodeTaggedBoolean_onkqg$ = function (tag, value) {
    this.encodeTaggedValue_yhz2mk$(tag, value);
  };
  CatCodeEncoder.prototype.encodeTaggedChar_j7cd6i$ = function (tag, value) {
    this.encodeTaggedValue_yhz2mk$(tag, toBoxedChar(value));
  };
  CatCodeEncoder.prototype.encodeTaggedString_reudxd$ = function (tag, value) {
    this.encodeTaggedValue_yhz2mk$(tag, value);
  };
  CatCodeEncoder.prototype.encodeTaggedEnum_6xfju7$ = function (tag, enumDescriptor, ordinal) {
    this.encodeTaggedValue_yhz2mk$(tag, ordinal);
  };
  CatCodeEncoder.prototype.encodeTaggedInline_9yg8i7$ = function (tag, inlineDescriptor) {
    this.pushTag_0(tag);
    return this;
  };
  CatCodeEncoder.prototype.encodeInline_24f42q$ = function (descriptor) {
    return this.encodeTaggedInline_9yg8i7$(this.popTag_0(), descriptor);
  };
  CatCodeEncoder.prototype.encodeElement_0 = function (desc, index) {
    var tag = this.getTag_av9bu7$(desc, index);
    this.pushTag_0(tag);
    return true;
  };
  CatCodeEncoder.prototype.encodeNotNullMark = function () {
    this.encodeTaggedNonNullMark_trkh7z$(this.currentTag_0);
  };
  CatCodeEncoder.prototype.encodeNull = function () {
    this.encodeTaggedNull_trkh7z$(this.popTag_0());
  };
  CatCodeEncoder.prototype.encodeBoolean_6taknv$ = function (value) {
    this.encodeTaggedBoolean_onkqg$(this.popTag_0(), value);
  };
  CatCodeEncoder.prototype.encodeByte_s8j3t7$ = function (value) {
    this.encodeTaggedByte_1r7uvc$(this.popTag_0(), value);
  };
  CatCodeEncoder.prototype.encodeShort_mq22fl$ = function (value) {
    this.encodeTaggedShort_s4b8v0$(this.popTag_0(), value);
  };
  CatCodeEncoder.prototype.encodeInt_za3lpa$ = function (value) {
    this.encodeTaggedInt_nygwzz$(this.popTag_0(), value);
  };
  CatCodeEncoder.prototype.encodeLong_s8cxhz$ = function (value) {
    this.encodeTaggedLong_weyjw$(this.popTag_0(), value);
  };
  CatCodeEncoder.prototype.encodeFloat_mx4ult$ = function (value) {
    this.encodeTaggedFloat_mv9gn0$(this.popTag_0(), value);
  };
  CatCodeEncoder.prototype.encodeDouble_14dthe$ = function (value) {
    this.encodeTaggedDouble_cywou9$(this.popTag_0(), value);
  };
  CatCodeEncoder.prototype.encodeChar_s8itvh$ = function (value) {
    this.encodeTaggedChar_j7cd6i$(this.popTag_0(), value);
  };
  CatCodeEncoder.prototype.encodeString_61zpoe$ = function (value) {
    this.encodeTaggedString_reudxd$(this.popTag_0(), value);
  };
  CatCodeEncoder.prototype.encodeEnum_szpzho$ = function (enumDescriptor, index) {
    this.encodeTaggedEnum_6xfju7$(this.popTag_0(), enumDescriptor, index);
  };
  CatCodeEncoder.prototype.beginStructure_24f42q$ = function (descriptor) {
    return this;
  };
  CatCodeEncoder.prototype.endStructure_24f42q$ = function (descriptor) {
    if (!this.tagStack_0.isEmpty()) {
      this.popTag_0();
    }
    this.endEncode_24f42q$(descriptor);
  };
  CatCodeEncoder.prototype.endEncode_24f42q$ = function (descriptor) {
  };
  CatCodeEncoder.prototype.encodeBooleanElement_qh7jdn$ = function (descriptor, index, value) {
    this.encodeTaggedBoolean_onkqg$(this.getTag_av9bu7$(descriptor, index), value);
  };
  CatCodeEncoder.prototype.encodeByteElement_j0u8y3$ = function (descriptor, index, value) {
    this.encodeTaggedByte_1r7uvc$(this.getTag_av9bu7$(descriptor, index), value);
  };
  CatCodeEncoder.prototype.encodeShortElement_l83pjl$ = function (descriptor, index, value) {
    this.encodeTaggedShort_s4b8v0$(this.getTag_av9bu7$(descriptor, index), value);
  };
  CatCodeEncoder.prototype.encodeIntElement_ptg7oe$ = function (descriptor, index, value) {
    this.encodeTaggedInt_nygwzz$(this.getTag_av9bu7$(descriptor, index), value);
  };
  CatCodeEncoder.prototype.encodeLongElement_j0o2mv$ = function (descriptor, index, value) {
    this.encodeTaggedLong_weyjw$(this.getTag_av9bu7$(descriptor, index), value);
  };
  CatCodeEncoder.prototype.encodeFloatElement_lf6hpt$ = function (descriptor, index, value) {
    this.encodeTaggedFloat_mv9gn0$(this.getTag_av9bu7$(descriptor, index), value);
  };
  CatCodeEncoder.prototype.encodeDoubleElement_powrwi$ = function (descriptor, index, value) {
    this.encodeTaggedDouble_cywou9$(this.getTag_av9bu7$(descriptor, index), value);
  };
  CatCodeEncoder.prototype.encodeCharElement_j0tz0d$ = function (descriptor, index, value) {
    this.encodeTaggedChar_j7cd6i$(this.getTag_av9bu7$(descriptor, index), value);
  };
  CatCodeEncoder.prototype.encodeStringElement_iij8qq$ = function (descriptor, index, value) {
    this.encodeTaggedString_reudxd$(this.getTag_av9bu7$(descriptor, index), value);
  };
  CatCodeEncoder.prototype.encodeInlineElement_szpzho$ = function (descriptor, index) {
    return this.encodeTaggedInline_9yg8i7$(this.getTag_av9bu7$(descriptor, index), descriptor.getElementDescriptor_za3lpa$(index));
  };
  CatCodeEncoder.prototype.encodeSerializableElement_r4qlx7$ = function (descriptor, index, serializer, value) {
    if (this.encodeElement_0(descriptor, index))
      this.encodeSerializableValue_tf03ej$(serializer, value);
  };
  CatCodeEncoder.prototype.encodeNullableSerializableElement_qw92s8$ = function (descriptor, index, serializer, value) {
    if (this.encodeElement_0(descriptor, index))
      this.encodeNullableSerializableValue_f4686g$(serializer, value);
  };
  Object.defineProperty(CatCodeEncoder.prototype, 'currentTag_0', {
    configurable: true,
    get: function () {
      return last(this.tagStack_0);
    }
  });
  Object.defineProperty(CatCodeEncoder.prototype, 'currentTagOrNull_0', {
    configurable: true,
    get: function () {
      return lastOrNull(this.tagStack_0);
    }
  });
  CatCodeEncoder.prototype.pushTag_0 = function (name) {
    this.tagStack_0.add_11rb$(name);
  };
  CatCodeEncoder.prototype.popTag_0 = function () {
    if (!this.tagStack_0.isEmpty())
      return this.tagStack_0.removeAt_za3lpa$(get_lastIndex_0(this.tagStack_0));
    else
      throw SerializationException_init('No tag in stack for requested element');
  };
  CatCodeEncoder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CatCodeEncoder',
    interfaces: [CompositeEncoder, Encoder]
  };
  function CatCodeTypeName(name) {
    this.name = name;
  }
  CatCodeTypeName.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'CatCodeTypeName',
    interfaces: [Annotation]
  };
  Object.defineProperty(CatCode, 'Default', {
    get: CatCode$Default_getInstance
  });
  $$importsForInline$$['catcode2-core'] = $module$catcode2_core;
  var package$catcode2 = _.catcode2 || (_.catcode2 = {});
  var package$serialization = package$catcode2.serialization || (package$catcode2.serialization = {});
  package$serialization.CatCode = CatCode;
  package$serialization.buildCatCode = catCode;
  package$serialization.CatCodeBuilderFunction = CatCodeBuilderFunction;
  package$serialization.CatCodeBuilder = CatCodeBuilder;
  Object.defineProperty(CatCodeConfiguration, 'Companion', {
    get: CatCodeConfiguration$Companion_getInstance
  });
  package$serialization.CatCodeConfiguration = CatCodeConfiguration;
  package$serialization.CatCodeDecoder = CatCodeDecoder;
  package$serialization.CatCodeEncoder = CatCodeEncoder;
  package$serialization.CatCodeTypeName = CatCodeTypeName;
  CatCodeEncoder.prototype.beginCollection_szpzho$ = Encoder.prototype.beginCollection_szpzho$;
  CatCodeEncoder.prototype.encodeNullableSerializableValue_f4686g$ = Encoder.prototype.encodeNullableSerializableValue_f4686g$;
  CatCodeEncoder.prototype.encodeSerializableValue_tf03ej$ = Encoder.prototype.encodeSerializableValue_tf03ej$;
  CatCodeEncoder.prototype.shouldEncodeElementDefault_szpzho$ = CompositeEncoder.prototype.shouldEncodeElementDefault_szpzho$;
  CatCodeDecoder.prototype.decodeSerializableValue_w63s0f$ = Decoder.prototype.decodeSerializableValue_w63s0f$;
  CatCodeDecoder.prototype.decodeNullableSerializableValue_aae3ea$ = Decoder.prototype.decodeNullableSerializableValue_aae3ea$;
  CatCodeDecoder.prototype.decodeCollectionSize_24f42q$ = CompositeDecoder.prototype.decodeCollectionSize_24f42q$;
  CatCodeDecoder.prototype.decodeSequentially = CompositeDecoder.prototype.decodeSequentially;
  CatCodeDecoder.prototype.decodeSerializableElement_12e8id$ = CompositeDecoder.prototype.decodeSerializableElement_12e8id$;
  CatCodeDecoder.prototype.decodeNullableSerializableElement_8viuyw$ = CompositeDecoder.prototype.decodeNullableSerializableElement_8viuyw$;
  Kotlin.defineModule('catcode2-serialization-kotlinx', _);
  return _;
}));

//# sourceMappingURL=catcode2-serialization-kotlinx.js.map
