/*
 * Decompiled with CFR 0.152.
 */
package love.forte.simbot.logger;

import java.io.PrintStream;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import love.forte.simbot.logger.ConsoleSimbotLoggerProcessorKt;
import love.forte.simbot.logger.LogInfo;
import love.forte.simbot.logger.SimbotLoggerProcessor;
import love.forte.simbot.logger.color.Color;
import love.forte.simbot.logger.color.ColorKt;
import love.forte.simbot.logger.color.FontColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Marker;
import org.slf4j.event.Level;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Llove/forte/simbot/logger/ConsoleSimbotLoggerProcessor;", "Llove/forte/simbot/logger/SimbotLoggerProcessor;", "level", "Lorg/slf4j/event/Level;", "(Lorg/slf4j/event/Level;)V", "doHandle", "", "info", "Llove/forte/simbot/logger/LogInfo;", "isLevelEnabled", "", "marker", "Lorg/slf4j/Marker;", "loadLevel", "printLog", "Companion", "simbot-logger"})
public final class ConsoleSimbotLoggerProcessor
implements SimbotLoggerProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Level level;
    @NotNull
    private static final String SIMBOT_LEVEL_PROPERTY_KEY = "simbot.logger.level";

    public ConsoleSimbotLoggerProcessor(@Nullable Level level) {
        Level level2 = level;
        if (level2 == null) {
            level2 = this.loadLevel();
        }
        this.level = level2;
    }

    @Override
    public boolean isLevelEnabled(@NotNull Level level, @Nullable Marker marker) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return this.level.toInt() <= level.toInt();
    }

    private final void printLog(LogInfo info) {
        StringBuilder stringBuilder;
        PrintStream printStream;
        PrintStream printStream2;
        if (info.getLevel() == Level.ERROR) {
            printStream2 = System.err;
            Intrinsics.checkNotNullExpressionValue((Object)printStream2, (String)"err");
            printStream = printStream2;
        } else {
            printStream2 = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream2, (String)"out");
            printStream = printStream2;
        }
        PrintStream printer = printStream;
        int n = info.getFormattedMsg().length() + 80;
        StringBuilder $this$printLog_u24lambda_u2d1 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        Color color = FontColor.BLUE;
        String string = Instant.ofEpochMilli(info.getTimestamp()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ofEpochMilli(info.timestamp).toString()");
        ColorKt.appendColor($this$printLog_u24lambda_u2d1, color, string).append(' ');
        if (info.getLevel().toString().length() <= 4) {
            $this$printLog_u24lambda_u2d1.append(' ');
        }
        Color color2 = ConsoleSimbotLoggerProcessorKt.getColor(info.getLevel());
        string = info.getLevel().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"info.level.toString()");
        ColorKt.appendColor($this$printLog_u24lambda_u2d1, color2, string).append(' ').append(" --- [");
        String string2 = info.getThread().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"info.thread.name");
        String threadName = ConsoleSimbotLoggerProcessorKt.getOnMax(string2, 20);
        if (threadName.length() < 20) {
            int n2 = 20 - threadName.length();
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int it = n4 = n3++;
                boolean bl2 = false;
                $this$printLog_u24lambda_u2d1.append(' ');
            }
        }
        $this$printLog_u24lambda_u2d1.append(threadName).append("] ");
        ColorKt.appendColor($this$printLog_u24lambda_u2d1, (Color)FontColor.BLUE, info.getName()).append("  : ").append(info.getFormattedMsg());
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        String printMsg = string3;
        printer.println(printMsg);
        if (info.getError() != null) {
            info.getError().printStackTrace(printer);
        }
    }

    @Override
    public void doHandle(@NotNull LogInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.printLog(info);
    }

    private final Level loadLevel() {
        Level level;
        Level level2;
        block3: {
            String string = System.getProperty(SIMBOT_LEVEL_PROPERTY_KEY);
            if (string == null) {
                return Level.INFO;
            }
            String levelName = string;
            for (Level level3 : Level.values()) {
                Level it = level3;
                boolean bl = false;
                if (!StringsKt.equals((String)it.name(), (String)levelName, (boolean)true)) continue;
                level2 = level3;
                break block3;
            }
            level2 = level = null;
        }
        if (level2 == null) {
            level = Level.INFO;
        }
        return level;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llove/forte/simbot/logger/ConsoleSimbotLoggerProcessor$Companion;", "", "()V", "SIMBOT_LEVEL_PROPERTY_KEY", "", "simbot-logger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

