/*
 * Decompiled with CFR 0.152.
 */
package love.forte.simbot.spring.autoconfigure;

import love.forte.common.configuration.Configuration;
import love.forte.simbot.SimbotArgsEnvironment;
import love.forte.simbot.SimbotEnvironment;
import love.forte.simbot.SimbotPackageScanEnvironment;
import love.forte.simbot.SimbotResourceEnvironment;
import love.forte.simbot.api.message.MessageContentBuilderFactory;
import love.forte.simbot.bot.BotManager;
import love.forte.simbot.core.SimbotContext;
import love.forte.simbot.listener.MsgGetProcessor;
import love.forte.simbot.spring.autoconfigure.SimbotAppConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@org.springframework.context.annotation.Configuration
@Import(value={SimbotAppConfiguration.class})
public class SimbotAppInfoConfiguration {
    private final SimbotContext simbotContext;

    public SimbotAppInfoConfiguration(SimbotContext simbotContext) {
        this.simbotContext = simbotContext;
    }

    @Bean(value={"simbotBotManager"})
    public BotManager botManager() {
        return this.simbotContext.getBotManager();
    }

    @Bean(value={"simbotSimbotEnvironment"})
    public SimbotEnvironment simbotEnvironment() {
        return this.simbotContext.getEnvironment();
    }

    @Bean(value={"simbotResourceEnvironment"})
    public SimbotResourceEnvironment resourceEnvironment() {
        return this.simbotContext.getEnvironment().getResourceEnvironment();
    }

    @Bean(value={"simbotArgsEnvironment"})
    public SimbotArgsEnvironment argsEnvironment() {
        return this.simbotContext.getEnvironment().getArgsEnvironment();
    }

    @Bean(value={"simbotPackageScanEnvironment"})
    public SimbotPackageScanEnvironment packageScanEnvironment() {
        return this.simbotContext.getEnvironment().getPackageScanEnvironment();
    }

    @Bean(value={"simbotMsgGetProcessor"})
    public MsgGetProcessor msgGetProcessor() {
        return this.simbotContext.getMsgProcessor();
    }

    @Bean(value={"simbotConfiguration"})
    public Configuration configuration() {
        return this.simbotContext.getConfiguration();
    }

    @Bean(value={"simbotMessageContentBuilderFactory"})
    public MessageContentBuilderFactory messageContentBuilderFactory() {
        return (MessageContentBuilderFactory)this.simbotContext.get(MessageContentBuilderFactory.class);
    }
}

