/*
 * Decompiled with CFR 0.152.
 */
package love.forte.simbot.spring.autoconfigure;

import cn.hutool.core.convert.ConverterRegistry;
import love.forte.common.configuration.Configuration;
import love.forte.common.ioc.DependBeanFactory;
import love.forte.common.utils.convert.ConverterManager;
import love.forte.common.utils.convert.HutoolConverterManagerImpl;
import love.forte.simbot.annotation.SimbotApplication;
import love.forte.simbot.core.SimbotApp;
import love.forte.simbot.core.SimbotContext;
import love.forte.simbot.spring.autoconfigure.SimbotAppProperties;
import love.forte.simbot.spring.autoconfigure.SpringDependBeanFactory;
import love.forte.simbot.spring.autoconfigure.SpringEnvironmentConfiguration;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;

@org.springframework.context.annotation.Configuration(proxyBeanMethods=false)
@Import(value={SimbotAppProperties.class, SpringDependBeanFactory.class})
@SimbotApplication
public class SimbotAppConfiguration {
    private final SimbotAppProperties simbotAppProperties;
    private final SpringDependBeanFactory springDependBeanFactory;
    private final ApplicationArguments applicationArguments;

    public SimbotAppConfiguration(SimbotAppProperties simbotAppProperties, SpringDependBeanFactory springDependBeanFactory, ApplicationArguments applicationArguments) {
        this.simbotAppProperties = simbotAppProperties;
        this.springDependBeanFactory = springDependBeanFactory;
        this.applicationArguments = applicationArguments;
    }

    @Bean
    @ConditionalOnMissingBean(value={ConverterManager.class})
    public ConverterManager converterManager() {
        return new HutoolConverterManagerImpl(ConverterRegistry.getInstance());
    }

    @Bean(value={"simbotContext"})
    public SimbotContext simbotApp(ConfigurableEnvironment environment, ConverterManager converterManager) {
        Class<Object> applicationClass = this.simbotAppProperties.getAppClass();
        if (applicationClass == null) {
            applicationClass = SimbotAppConfiguration.class;
        }
        String[] sourceArgs = this.applicationArguments.getSourceArgs();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        SpringEnvironmentConfiguration springEnvironmentConfiguration = new SpringEnvironmentConfiguration(environment, converterManager);
        return SimbotApp.run(applicationClass, (ClassLoader)loader, (DependBeanFactory)this.springDependBeanFactory, (Configuration)springEnvironmentConfiguration, (String[])sourceArgs);
    }
}

