/*
 * Decompiled with CFR 0.152.
 */
package love.forte.simbot.spring.autoconfigure;

import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import love.forte.common.ioc.DependBeanFactory;
import love.forte.common.ioc.exception.DependException;
import love.forte.common.ioc.exception.NoSuchDependException;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SpringDependBeanFactory
implements DependBeanFactory {
    private final ListableBeanFactory beanFactory;

    public SpringDependBeanFactory(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public <T> T get(Class<T> type) {
        try {
            return (T)this.beanFactory.getBean(type);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new NoSuchDependException((Throwable)e);
        }
    }

    public <T> T get(Class<T> type, String name) {
        try {
            return (T)this.beanFactory.getBean(type, new Object[]{name});
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new NoSuchDependException((Throwable)e);
        }
    }

    public Object get(String name) {
        try {
            return this.beanFactory.getBean(name);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new NoSuchDependException((Throwable)e);
        }
    }

    public <T> T getOrNull(Class<T> type) {
        try {
            return (T)this.beanFactory.getBean(type);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public <T> T getOrNull(Class<T> type, String name) {
        try {
            return (T)this.beanFactory.getBean(type, new Object[]{name});
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public Object getOrNull(String name) {
        try {
            return this.beanFactory.getBean(name);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public <T> T getOrThrow(Class<T> type, Function<NoSuchDependException, DependException> exceptionCompute) {
        try {
            return (T)this.beanFactory.getBean(type);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw exceptionCompute.apply(new NoSuchDependException((Throwable)e));
        }
    }

    public <T> T getOrThrow(Class<T> type, String name, Function<NoSuchDependException, DependException> exceptionCompute) {
        try {
            return (T)this.beanFactory.getBean(type, new Object[]{name});
        }
        catch (NoSuchBeanDefinitionException e) {
            throw exceptionCompute.apply(new NoSuchDependException((Throwable)e));
        }
    }

    public Object getOrThrow(String name, Function<NoSuchDependException, DependException> exceptionCompute) {
        try {
            return this.beanFactory.getBean(name);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw exceptionCompute.apply(new NoSuchDependException((Throwable)e));
        }
    }

    public Set<String> getAllBeans() {
        String[] beanDefinitionNames = this.beanFactory.getBeanDefinitionNames();
        return Arrays.stream(beanDefinitionNames).collect(Collectors.toSet());
    }

    public Class<?> getType(String name) {
        try {
            boolean isProxy;
            Class type = this.beanFactory.getType(name);
            if (type == null) {
                return null;
            }
            boolean bl = isProxy = SpringProxy.class.isAssignableFrom(type) && Proxy.isProxyClass(type) || type.getName().contains("$$");
            if (isProxy) {
                type = AopUtils.getTargetClass((Object)this.beanFactory.getBean(name));
            }
            return type;
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }
}

