/*
 * Decompiled with CFR 0.152.
 */
package love.forte.simbot.spring.autoconfigure;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.stream.IntStream;
import love.forte.common.configuration.Configuration;
import love.forte.common.configuration.ConfigurationProperty;
import love.forte.common.utils.convert.ConverterManager;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class SpringEnvironmentConfiguration
implements Configuration {
    private final ConfigurableEnvironment environment;
    private final ConverterManager converterManager;

    public SpringEnvironmentConfiguration(ConfigurableEnvironment environment, ConverterManager converterManager) {
        this.environment = environment;
        this.converterManager = converterManager;
    }

    public ConfigurationProperty getConfig(String key) {
        return this.containsConfig(key) ? new SpringConfigurationProperty(key) : null;
    }

    public ConfigurationProperty setConfig(String key, ConfigurationProperty config) {
        MutablePropertySources propertySources = this.environment.getPropertySources();
        Object value = config.getObject();
        Map<String, Object> singletonMap = Collections.singletonMap(key, value);
        MapPropertySource propertySource = new MapPropertySource(key, singletonMap);
        propertySources.addLast((PropertySource)propertySource);
        return config;
    }

    public boolean containsConfig(String key) {
        boolean contains = this.environment.containsProperty(key);
        if (!contains) {
            String newKey = SpringEnvironmentConfiguration.resetKey(key);
            contains = this.environment.containsProperty(newKey);
        }
        return contains;
    }

    public int size() {
        return this.environment.getPropertySources().size();
    }

    private static String resetKey(String key) {
        StringBuilder sb = new StringBuilder(key.length());
        key.chars().flatMap(c -> {
            if (Character.isUpperCase(c)) {
                return IntStream.of(45, Character.toLowerCase(c));
            }
            return IntStream.of(c);
        }).forEach(c -> sb.append((char)c));
        return sb.toString();
    }

    private class SpringConfigurationProperty
    implements ConfigurationProperty {
        private final String key;

        SpringConfigurationProperty(String key) {
            if (SpringEnvironmentConfiguration.this.environment.containsProperty(key)) {
                this.key = key;
            } else {
                String resetKey = SpringEnvironmentConfiguration.resetKey(key);
                if (SpringEnvironmentConfiguration.this.environment.containsProperty(resetKey)) {
                    this.key = resetKey;
                } else {
                    throw new IllegalArgumentException("cannot found config properties for key '" + key + "' or '" + resetKey + "'");
                }
            }
        }

        public String getKey() {
            return this.key;
        }

        public Object getObject() {
            return this.getString();
        }

        public <T> T getObject(Class<T> type) {
            return (T)SpringEnvironmentConfiguration.this.environment.getProperty(this.key, type);
        }

        public <T> T getObject(Type type) {
            if (type instanceof Class) {
                return this.getObject((Class)type);
            }
            String property = SpringEnvironmentConfiguration.this.environment.getProperty(this.key);
            return (T)SpringEnvironmentConfiguration.this.converterManager.convert(type, (Object)property);
        }

        public String getString() {
            return SpringEnvironmentConfiguration.this.environment.getProperty(this.key);
        }

        public int getInt() {
            return (Integer)SpringEnvironmentConfiguration.this.environment.getProperty(this.key, Integer.TYPE);
        }

        public long getLong() {
            return (Long)SpringEnvironmentConfiguration.this.environment.getProperty(this.key, Long.TYPE);
        }

        public boolean getBoolean() {
            return (Boolean)SpringEnvironmentConfiguration.this.environment.getProperty(this.key, Boolean.TYPE);
        }
    }
}

