/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import javax.management.NotificationEmitter;
import javax.management.openmbean.CompositeData;
import love.kill.methodcache.MethodcacheProperties;
import love.kill.methodcache.util.ThreadPoolBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryMonitor {
    private static Logger logger = LoggerFactory.getLogger(MemoryMonitor.class);
    private static final MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
    private static final String memoryPoolMXBeanOldGen = "old gen";
    private final double memoryThreshold;
    private final double gcThreshold;
    private static final List<Consumer<MemoryUsage>> subscribers = new CopyOnWriteArrayList<Consumer<MemoryUsage>>();
    private static final ExecutorService executorService = ThreadPoolBuilder.buildDefaultThreadPool();

    public MemoryMonitor(MethodcacheProperties methodcacheProperties) {
        logger.info("\u5f00\u542f\u5185\u5b58\u76d1\u63a7...");
        this.gcThreshold = new BigDecimal(methodcacheProperties.getGcThreshold()).divide(new BigDecimal(100), 2, 4).doubleValue();
        this.memoryThreshold = new BigDecimal(methodcacheProperties.getMemoryThreshold()).divide(new BigDecimal(100), 2, 4).doubleValue();
        logger.info("\u5185\u5b58\u544a\u8b66\u9608\u503c=" + this.memoryThreshold + "\uff0cGC\u9608\u503c=" + this.gcThreshold);
        this.setUsageThreshold();
        NotificationEmitter ne = (NotificationEmitter)((Object)memBean);
        ne.addNotificationListener((notification, handback) -> {
            Object userData = notification.getUserData();
            if (userData instanceof CompositeData) {
                CompositeData cd = (CompositeData)notification.getUserData();
                MemoryNotificationInfo mni = MemoryNotificationInfo.from(cd);
                MemoryUsage memUsage = mni.getUsage();
                String poolName = mni.getPoolName();
                long used = memUsage.getUsed();
                long max = memUsage.getMax();
                if (poolName.toLowerCase().endsWith(memoryPoolMXBeanOldGen) && this.isAlarmed(used, max, this.memoryThreshold) && subscribers.size() > 0) {
                    for (Consumer<MemoryUsage> sub : subscribers) {
                        executorService.execute(() -> sub.accept(memUsage));
                    }
                }
            }
        }, null, null);
    }

    private void setUsageThreshold() {
        List<MemoryPoolMXBean> memPools = ManagementFactory.getMemoryPoolMXBeans();
        if (memPools == null) {
            return;
        }
        for (MemoryPoolMXBean mp : memPools) {
            String mpName = mp.getName();
            if (!mpName.toLowerCase().endsWith(memoryPoolMXBeanOldGen) || !mp.isUsageThresholdSupported()) continue;
            MemoryUsage usage = mp.getUsage();
            long max = usage.getMax();
            mp.setUsageThreshold(new BigDecimal(max).multiply(new BigDecimal(this.memoryThreshold)).longValue());
        }
    }

    private boolean isAlarmed(long used, long limit, double cordon) {
        BigDecimal bigUsed = new BigDecimal(used);
        BigDecimal bigLimit = new BigDecimal(limit);
        return bigUsed.compareTo(bigLimit.multiply(new BigDecimal(cordon))) >= 0;
    }

    public void sub(Consumer<MemoryUsage> subscriber) {
        subscribers.add(subscriber);
    }
}

