/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache;

import java.lang.reflect.Method;
import love.kill.methodcache.MemoryMonitor;
import love.kill.methodcache.MethodcacheProperties;
import love.kill.methodcache.SpringApplicationProperties;
import love.kill.methodcache.advisor.CacheDataInterceptor;
import love.kill.methodcache.advisor.CacheIsolationInterceptor;
import love.kill.methodcache.advisor.DeleteDataInterceptor;
import love.kill.methodcache.annotation.CacheData;
import love.kill.methodcache.annotation.CacheIsolation;
import love.kill.methodcache.annotation.DeleteData;
import love.kill.methodcache.datahelper.DataHelper;
import love.kill.methodcache.datahelper.impl.MemoryDataHelper;
import love.kill.methodcache.datahelper.impl.RedisDataHelper;
import love.kill.methodcache.util.AnnotationUtil;
import love.kill.methodcache.util.RedisUtil;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.lang.Nullable;

@Configuration
@EnableConfigurationProperties(value={MethodcacheProperties.class, SpringApplicationProperties.class})
@ConditionalOnProperty(prefix="methodcache", name={"enable"}, havingValue="true")
@ComponentScan(basePackages={"love.kill.methodcache.controller"})
public class MethodcacheAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="methodcache", name={"cache-type"}, havingValue="R")
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={RedisTemplate.class})
    DataHelper redisDataHelper(MethodcacheProperties methodcacheProperties, SpringApplicationProperties springProperties, RedisTemplate redisTemplate) {
        RedisTemplate cacheRedisTemplate = new RedisTemplate();
        cacheRedisTemplate.setConnectionFactory(redisTemplate.getConnectionFactory());
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        cacheRedisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        cacheRedisTemplate.setValueSerializer((RedisSerializer)stringRedisSerializer);
        cacheRedisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        cacheRedisTemplate.setHashValueSerializer((RedisSerializer)stringRedisSerializer);
        cacheRedisTemplate.afterPropertiesSet();
        return new RedisDataHelper(methodcacheProperties, springProperties, new RedisUtil(cacheRedisTemplate));
    }

    @Bean
    @ConditionalOnClass(value={MemoryDataHelper.class})
    @ConditionalOnProperty(prefix="methodcache", name={"enable-memory-monitor"}, havingValue="true")
    MemoryMonitor memoryMonitor(MethodcacheProperties methodcacheProperties) {
        return new MemoryMonitor(methodcacheProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    DataHelper memoryDataHelper(MethodcacheProperties methodcacheProperties, SpringApplicationProperties springProperties, @Nullable MemoryMonitor memoryMonitor) {
        return new MemoryDataHelper(methodcacheProperties, springProperties, memoryMonitor);
    }

    @Bean
    @Role(value=2)
    public DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator() {
        return new DefaultAdvisorAutoProxyCreator();
    }

    @Bean
    public StaticMethodMatcherPointcutAdvisor cacheDataPointcutAdvisor(MethodcacheProperties methodcacheProperties, DataHelper dataHelper) {
        CacheDataInterceptor cacheDataInterceptor = new CacheDataInterceptor(methodcacheProperties, dataHelper);
        StaticMethodMatcherPointcutAdvisor advisor = new StaticMethodMatcherPointcutAdvisor(){

            public boolean matches(Method method, Class<?> targetClass) {
                return AnnotationUtil.getAnnotation(method, targetClass, CacheData.class) != null && CacheDataInterceptor.setProxyClass(method.getDeclaringClass(), targetClass);
            }
        };
        advisor.setAdvice((Advice)cacheDataInterceptor);
        advisor.setOrder(methodcacheProperties.getOrder());
        return advisor;
    }

    @Bean
    public StaticMethodMatcherPointcutAdvisor deleteDataPointcutAdvisor(MethodcacheProperties methodcacheProperties, DataHelper dataHelper) {
        DeleteDataInterceptor deleteDataInterceptor = new DeleteDataInterceptor(methodcacheProperties, dataHelper);
        StaticMethodMatcherPointcutAdvisor advisor = new StaticMethodMatcherPointcutAdvisor(){

            public boolean matches(Method method, Class<?> targetClass) {
                return AnnotationUtil.getAnnotation(method, targetClass, DeleteData.class) != null && DeleteDataInterceptor.setProxyClass(method.getDeclaringClass(), targetClass);
            }
        };
        advisor.setAdvice((Advice)deleteDataInterceptor);
        advisor.setOrder(methodcacheProperties.getOrder() - 2);
        return advisor;
    }

    @Bean
    public StaticMethodMatcherPointcutAdvisor cacheIsolationPointcutAdvisor(MethodcacheProperties methodcacheProperties, DataHelper dataHelper) {
        CacheIsolationInterceptor cacheIsolationInterceptor = new CacheIsolationInterceptor(dataHelper);
        StaticMethodMatcherPointcutAdvisor advisor = new StaticMethodMatcherPointcutAdvisor(){

            public boolean matches(Method method, Class<?> targetClass) {
                return AnnotationUtil.getAnnotation(method, targetClass, CacheIsolation.class) != null && CacheIsolationInterceptor.setProxyClass(method.getDeclaringClass(), targetClass);
            }
        };
        advisor.setAdvice((Advice)cacheIsolationInterceptor);
        advisor.setOrder(methodcacheProperties.getOrder() - 1);
        return advisor;
    }
}

