/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache.advisor;

import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import love.kill.methodcache.MethodcacheProperties;
import love.kill.methodcache.annotation.CacheData;
import love.kill.methodcache.annotation.CapitalExpiration;
import love.kill.methodcache.datahelper.DataHelper;
import love.kill.methodcache.util.AnnotationUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.annotation.Autowired;

public class CacheDataInterceptor
implements MethodInterceptor {
    private MethodcacheProperties methodcacheProperties;
    private DataHelper dataHelper;
    private static Map<Class<?>, Class<?>> targetProxyClass = new HashMap();

    public CacheDataInterceptor(MethodcacheProperties methodcacheProperties, DataHelper dataHelper) {
        this.methodcacheProperties = methodcacheProperties;
        this.dataHelper = dataHelper;
    }

    private static synchronized Class getProxyClass(Class<?> target) {
        for (Class<?> key : targetProxyClass.keySet()) {
            if (!key.isAssignableFrom(target) && !target.isAssignableFrom(key)) continue;
            return targetProxyClass.get(key);
        }
        return null;
    }

    public static synchronized boolean setProxyClass(Class<?> target, Class<?> proxy) {
        Class proxyClass = CacheDataInterceptor.getProxyClass(target);
        if (proxyClass != null) {
            return proxyClass == proxy;
        }
        targetProxyClass.put(target, proxy);
        return true;
    }

    public Object invoke(final MethodInvocation methodInvocation) throws Throwable {
        if (!this.methodcacheProperties.isEnable()) {
            return methodInvocation.proceed();
        }
        Method method = methodInvocation.getMethod();
        Object proxy = methodInvocation.getThis();
        Class<?> target = method.getDeclaringClass();
        if (CacheDataInterceptor.getProxyClass(target) != proxy.getClass()) {
            return methodInvocation.proceed();
        }
        CacheData cacheData = AnnotationUtil.getAnnotation(method, proxy.getClass(), CacheData.class);
        if (cacheData == null) {
            return methodInvocation.proceed();
        }
        boolean refresh = cacheData.refresh();
        final long expiration = cacheData.expiration();
        final long behindExpiration = cacheData.behindExpiration();
        final CapitalExpiration capitalExpiration = cacheData.capitalExpiration();
        boolean nullable = cacheData.nullable();
        boolean shared = cacheData.shared();
        String isolationSignal = DataHelper.threadLocal.get();
        return this.dataHelper.getData(proxy, methodInvocation.getMethod(), methodInvocation.getArguments(), isolationSignal, refresh, new DataHelper.ActualDataFunctional(){

            @Override
            @Autowired
            public Object getActualData() throws Throwable {
                try {
                    return methodInvocation.proceed();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw throwable;
                }
            }

            @Override
            public long getExpirationTime() {
                return CacheDataInterceptor.expirationTime(expiration, behindExpiration, capitalExpiration);
            }
        }, cacheData.id(), cacheData.remark(), nullable, shared);
    }

    private static long expirationTime(long expiration, long behindExpiration, CapitalExpiration capitalExpiration) {
        int calendarAddType;
        if (expiration < 0L) {
            return -1L;
        }
        Calendar calendar = Calendar.getInstance();
        switch (capitalExpiration) {
            case YEAR: {
                calendar.set(2, 0);
            }
            case MONTH: {
                calendar.set(5, 1);
            }
            case DAY: {
                calendar.set(11, 0);
            }
            case HOUR: {
                calendar.set(12, 0);
            }
            case MINUTE: {
                calendar.set(13, 0);
            }
        }
        switch (capitalExpiration) {
            case MINUTE: {
                calendarAddType = 12;
                break;
            }
            case HOUR: {
                calendarAddType = 11;
                break;
            }
            case DAY: {
                calendarAddType = 5;
                break;
            }
            case MONTH: {
                calendarAddType = 2;
                break;
            }
            case YEAR: {
                calendarAddType = 1;
                break;
            }
            default: {
                calendarAddType = -1;
            }
        }
        expiration = (long)((double)expiration + Math.random() * (double)behindExpiration);
        if (calendarAddType != -1) {
            calendar.add(calendarAddType, 1);
        }
        return calendar.getTime().getTime() + expiration;
    }
}

