/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache.advisor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import love.kill.methodcache.annotation.CacheIsolation;
import love.kill.methodcache.datahelper.DataHelper;
import love.kill.methodcache.util.AnnotationUtil;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.StringUtils;

public class CacheIsolationInterceptor
implements MethodInterceptor {
    private DataHelper dataHelper;
    private static Map<Class<?>, Class<?>> targetProxyClass = new HashMap();

    public CacheIsolationInterceptor(DataHelper dataHelper) {
        this.dataHelper = dataHelper;
    }

    private static synchronized Class getProxyClass(Class<?> target) {
        for (Class<?> key : targetProxyClass.keySet()) {
            if (!key.isAssignableFrom(target) && !target.isAssignableFrom(key)) continue;
            return targetProxyClass.get(key);
        }
        return null;
    }

    public static synchronized boolean setProxyClass(Class<?> target, Class<?> proxy) {
        Class proxyClass = CacheIsolationInterceptor.getProxyClass(target);
        if (proxyClass != null) {
            return proxyClass == proxy;
        }
        targetProxyClass.put(target, proxy);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method method = methodInvocation.getMethod();
        Object proxy = methodInvocation.getThis();
        Class<?> target = method.getDeclaringClass();
        if (CacheIsolationInterceptor.getProxyClass(target) != proxy.getClass()) {
            return methodInvocation.proceed();
        }
        CacheIsolation cacheIsolation = AnnotationUtil.getAnnotation(method, proxy.getClass(), CacheIsolation.class);
        if (cacheIsolation == null) {
            return methodInvocation.proceed();
        }
        if ('T' == cacheIsolation.isolationStrategy()) {
            boolean setIsolationSignal = false;
            try {
                String isolationSignal = DataHelper.threadLocal.get();
                if (StringUtils.isEmpty((Object)isolationSignal)) {
                    isolationSignal = UUID.randomUUID().toString() + "@" + String.valueOf(Thread.currentThread().getId());
                    DataHelper.threadLocal.set(isolationSignal);
                    setIsolationSignal = true;
                }
                Object object = methodInvocation.proceed();
                return object;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (setIsolationSignal) {
                    DataHelper.threadLocal.remove();
                }
            }
        }
        return methodInvocation.proceed();
    }
}

