/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache.advisor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import love.kill.methodcache.MethodcacheProperties;
import love.kill.methodcache.annotation.DeleteData;
import love.kill.methodcache.datahelper.DataHelper;
import love.kill.methodcache.util.AnnotationUtil;
import love.kill.methodcache.util.ThreadPoolBuilder;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.StringUtils;

public class DeleteDataInterceptor
implements MethodInterceptor {
    private MethodcacheProperties methodcacheProperties;
    private DataHelper dataHelper;
    private static Map<Class<?>, Class<?>> targetProxyClass = new HashMap();
    private ExecutorService deleteCacheExecutorService = ThreadPoolBuilder.buildDefaultThreadPool();

    public DeleteDataInterceptor(MethodcacheProperties methodcacheProperties, DataHelper dataHelper) {
        this.methodcacheProperties = methodcacheProperties;
        this.dataHelper = dataHelper;
    }

    private static synchronized Class getProxyClass(Class<?> target) {
        for (Class<?> key : targetProxyClass.keySet()) {
            if (!key.isAssignableFrom(target) && !target.isAssignableFrom(key)) continue;
            return targetProxyClass.get(key);
        }
        return null;
    }

    public static synchronized boolean setProxyClass(Class<?> target, Class<?> proxy) {
        Class proxyClass = DeleteDataInterceptor.getProxyClass(target);
        if (proxyClass != null) {
            return proxyClass == proxy;
        }
        targetProxyClass.put(target, proxy);
        return true;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object result;
        if (!this.methodcacheProperties.isEnable()) {
            return methodInvocation.proceed();
        }
        Method method = methodInvocation.getMethod();
        Object proxy = methodInvocation.getThis();
        Class<?> target = method.getDeclaringClass();
        if (DeleteDataInterceptor.getProxyClass(target) != proxy.getClass()) {
            return methodInvocation.proceed();
        }
        DeleteData deleteData = AnnotationUtil.getAnnotation(method, proxy.getClass(), DeleteData.class);
        if (deleteData == null) {
            return methodInvocation.proceed();
        }
        String[] ids = deleteData.id();
        if (ids.length <= 0) {
            return methodInvocation.proceed();
        }
        try {
            result = methodInvocation.proceed();
            for (String id : ids) {
                if (StringUtils.isEmpty((Object)id)) continue;
                this.deleteCacheExecutorService.execute(() -> this.dataHelper.wipeCache(id, null));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw throwable;
        }
        return result;
    }
}

