/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache.controller;

import java.util.HashMap;
import java.util.Map;
import love.kill.methodcache.datahelper.DataHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnProperty(prefix="methodcache", name={"enable-endpoint"}, havingValue="true")
@RestController
@RequestMapping(value={"/methodcache/cache"})
public class Cache {
    @Autowired
    private DataHelper dataHelper;

    @GetMapping
    public Map<String, Map<String, Object>> get(@RequestParam(value="match", required=false) String match) {
        return this.dataHelper.getCaches(match);
    }

    @DeleteMapping
    public Map<String, Map<String, Object>> delete(@RequestParam(value="id", required=false) String id, @RequestParam(value="hashcode", required=false) String hashCode) {
        if (StringUtils.isEmpty((Object)id) && StringUtils.isEmpty((Object)hashCode)) {
            return new HashMap<String, Map<String, Object>>();
        }
        return this.dataHelper.wipeCache(id, hashCode);
    }

    @DeleteMapping(value={"/all"})
    public Map<String, Map<String, Object>> deleteAll() {
        return this.dataHelper.wipeCache(null, null);
    }
}

